/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

import java.util.function.Supplier;

public final class SupplyOnce {
    private SupplyOnce() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> loader) {
        return new NonLockingSupplyOnce(loader);
    }

    private static final class NonLockingSupplyOnce<T>
    implements Supplier<T> {
        private final Supplier<T> loader;
        private Object result;
        private boolean loaded;

        private NonLockingSupplyOnce(Supplier<T> loader) {
            this.loader = loader;
        }

        @Override
        public T get() {
            if (this.loaded) {
                return this.eval(this.result);
            }
            try {
                T obj = this.loader.get();
                this.result = obj;
                T t = obj;
                return t;
            }
            catch (RuntimeException re) {
                this.result = re;
                throw re;
            }
            finally {
                this.loaded = true;
            }
        }

        private T eval(Object i) {
            if (i instanceof RuntimeException) {
                throw (RuntimeException)i;
            }
            return (T)i;
        }
    }
}

