/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.indexes.AbstractStoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.util.Ser;

final class StoreIndexImpl<V>
implements StoreIndex<V> {
    static final int MAX_KEY_BYTES = 4096;
    private static final int ASSUMED_PER_ENTRY_OVERHEAD = 4;
    private static final int CURRENT_STORE_INDEX_VERSION = 2;
    private static final int SERIALIZE_VERSION = Integer.getInteger("nessie.internal.store-index-format-version", 2);
    public static final Comparator<StoreIndexElement<?>> KEY_COMPARATOR = Comparator.comparing(StoreIndexElement::key);
    private final int originalSerializedSize;
    private int estimatedSerializedSizeDiff;
    private final List<StoreIndexElement<V>> elements;
    private final ElementSerializer<V> serializer;
    private final ByteBuffer serialized;
    private final ByteBuffer scratchKeyBuffer = StoreIndexImpl.newKeyBuffer();
    private boolean modified;
    private ObjId objId;

    StoreIndexImpl(ElementSerializer<V> serializer) {
        this(new ArrayList<StoreIndexElement<V>>(), 2, serializer, false);
    }

    private StoreIndexImpl(List<StoreIndexElement<V>> elements, int originalSerializedSize, ElementSerializer<V> serializer, boolean modified) {
        this.elements = elements;
        this.originalSerializedSize = originalSerializedSize;
        this.serializer = serializer;
        this.modified = modified;
        this.serialized = null;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @VisibleForTesting
    StoreIndexImpl<V> setModified() {
        this.modified = true;
        return this;
    }

    @Override
    public ObjId getObjId() {
        return this.objId;
    }

    @Override
    public StoreIndex<V> setObjId(ObjId objId) {
        this.objId = objId;
        return this;
    }

    @Override
    public StoreIndex<V> loadIfNecessary(Set<StoreKey> keys) {
        return this;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public StoreIndex<V> asMutableIndex() {
        return this;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public List<StoreIndex<V>> divide(int parts) {
        List<StoreIndexElement<V>> elems = this.elements;
        int size = elems.size();
        Preconditions.checkArgument((parts > 0 && parts <= size ? 1 : 0) != 0, (String)"Number of parts %s must be greater than 0 and less or equal to number of elements %s", (int)parts, (int)size);
        int partSize = size / parts;
        int serializedMax = this.originalSerializedSize + this.estimatedSerializedSizeDiff;
        ArrayList<StoreIndex<V>> result = new ArrayList<StoreIndex<V>>(parts);
        int index = 0;
        for (int i = 0; i < parts; ++i) {
            int end = i < parts - 1 ? index + partSize : elems.size();
            ArrayList<StoreIndexElement<V>> partElements = new ArrayList<StoreIndexElement<V>>(this.elements.subList(index, end));
            StoreIndexImpl<V> part = new StoreIndexImpl<V>(partElements, serializedMax, this.serializer, true);
            result.add(part);
            index = end;
        }
        return result;
    }

    @Override
    public List<StoreIndex<V>> stripes() {
        return Collections.singletonList(this);
    }

    @Override
    public int elementCount() {
        return this.elements.size();
    }

    @Override
    public void updateAll(Function<StoreIndexElement<V>, V> updater) {
        List<StoreIndexElement<V>> e = this.elements;
        ElementSerializer<V> serializer = this.serializer;
        int size = e.size();
        for (int i = 0; i < size; ++i) {
            StoreIndexElement<V> el = e.get(i);
            V updated = updater.apply(el);
            if (updated == el) continue;
            this.modified = true;
            int oldSerializedSize = el.contentSerializedSize(serializer);
            if (updated == null) {
                e.remove(i);
                --i;
                --size;
                continue;
            }
            int newSerializedSize = serializer.serializedSize(updated);
            this.estimatedSerializedSizeDiff += newSerializedSize - oldSerializedSize;
            e.set(i, StoreIndexElement.indexElement(el.key(), updated));
        }
    }

    @Override
    public boolean add(@javax.annotation.Nonnull @Nonnull StoreIndexElement<V> element) {
        this.modified = true;
        List<StoreIndexElement<V>> e = this.elements;
        ElementSerializer<V> serializer = this.serializer;
        int idx = StoreIndexImpl.search(e, element);
        int elementSerializedSize = element.contentSerializedSize(serializer);
        if (idx >= 0) {
            StoreIndexElement<V> prev = e.get(idx);
            int prevSerializedSize = prev.contentSerializedSize(serializer);
            this.estimatedSerializedSizeDiff += elementSerializedSize - prevSerializedSize;
            e.set(idx, element);
            return false;
        }
        this.estimatedSerializedSizeDiff += StoreIndexImpl.addElementDiff(element, elementSerializedSize);
        int insertionPoint = -idx - 1;
        if (insertionPoint == e.size()) {
            e.add(element);
        } else {
            e.add(insertionPoint, element);
        }
        return true;
    }

    private static <V> int addElementDiff(StoreIndexElement<V> element, int elementSerializedSize) {
        return StoreIndexImpl.serializedSize(element.key()) + 4 + elementSerializedSize;
    }

    @Override
    public boolean remove(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        List<StoreIndexElement<V>> e = this.elements;
        int idx = StoreIndexImpl.search(e, key);
        if (idx < 0) {
            return false;
        }
        this.modified = true;
        StoreIndexElement<V> element = e.remove(idx);
        this.estimatedSerializedSizeDiff -= this.removeSizeDiff(element);
        return true;
    }

    private int removeSizeDiff(StoreIndexElement<V> element) {
        return 2 + element.contentSerializedSize(this.serializer);
    }

    @Override
    public boolean contains(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        int idx = StoreIndexImpl.search(this.elements, key);
        return idx >= 0;
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreIndexElement<V> get(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        List<StoreIndexElement<V>> e = this.elements;
        int idx = StoreIndexImpl.search(e, key);
        if (idx < 0) {
            return null;
        }
        return e.get(idx);
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreKey first() {
        List<StoreIndexElement<V>> e = this.elements;
        return e.isEmpty() ? null : e.get(0).key();
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreKey last() {
        List<StoreIndexElement<V>> e = this.elements;
        return e.isEmpty() ? null : e.get(e.size() - 1).key();
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator(final @javax.annotation.Nullable @Nullable StoreKey begin, @javax.annotation.Nullable @Nullable StoreKey end, boolean prefetch) {
        List<StoreIndexElement<V>> e = this.elements;
        if (begin == null && end == null) {
            return e.iterator();
        }
        boolean prefix = begin != null && begin.equals(end);
        int fromIdx = begin != null ? this.iteratorIndex(begin, 0) : 0;
        int toIdx = !prefix && end != null ? this.iteratorIndex(end, 1) : e.size();
        Preconditions.checkArgument((toIdx >= fromIdx ? 1 : 0) != 0, (Object)"'to' must be greater than 'from'");
        e = e.subList(fromIdx, toIdx);
        final Iterator<StoreIndexElement<V>> base = e.iterator();
        return prefix ? new AbstractIterator<StoreIndexElement<V>>(){

            protected StoreIndexElement<V> computeNext() {
                if (!base.hasNext()) {
                    return (StoreIndexElement)this.endOfData();
                }
                StoreIndexElement v = (StoreIndexElement)base.next();
                if (!v.key().startsWith(begin)) {
                    return (StoreIndexElement)this.endOfData();
                }
                return v;
            }
        } : base;
    }

    private int iteratorIndex(StoreKey from, int exactAdd) {
        int fromIdx = StoreIndexImpl.search(this.elements, from);
        fromIdx = fromIdx < 0 ? -fromIdx - 1 : (fromIdx += exactAdd);
        return fromIdx;
    }

    @VisibleForTesting
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoreIndexImpl)) {
            return false;
        }
        StoreIndexImpl that = (StoreIndexImpl)o;
        return this.elements.equals(that.elements);
    }

    @VisibleForTesting
    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        StoreKey f = this.first();
        StoreKey l = this.last();
        String fk = f != null ? f.toString() : "";
        String lk = l != null ? l.toString() : "";
        return "StoreIndexImpl{size=" + this.elementCount() + ", first=" + fk + ", last=" + lk + "}";
    }

    @Override
    public List<StoreKey> asKeyList() {
        return new AbstractList<StoreKey>(){

            @Override
            public StoreKey get(int index) {
                return StoreIndexImpl.this.elements.get(index).key();
            }

            @Override
            public int size() {
                return StoreIndexImpl.this.elements.size();
            }
        };
    }

    @Override
    public int estimatedSerializedSize() {
        return this.originalSerializedSize + this.estimatedSerializedSizeDiff;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ByteString serialize() {
        ByteBuffer target;
        if (this.serialized == null || this.modified) {
            target = ByteBuffer.allocate(this.estimatedSerializedSize());
            if (SERIALIZE_VERSION >= 2) {
                target.put((byte)2);
                Ser.putVarInt(target, this.elementCount());
            } else {
                target.put((byte)1);
            }
            ByteBuffer previousKey = null;
            ElementSerializer<V> ser = this.serializer;
            List<StoreIndexElement<V>> elements = this.elements;
            for (int i = 0; i < elements.size(); ++i) {
                StoreIndexElement<V> el = elements.get(i);
                StoreKey key = el.key();
                previousKey = StoreIndexImpl.serializeKey(previousKey, key, target, this.scratchKeyBuffer);
                el.serializeContent(ser, target);
            }
            target.flip();
        } else {
            target = this.serialized.position(0).limit(this.originalSerializedSize);
        }
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)target);
    }

    private static ByteBuffer serializeKey(ByteBuffer previousKey, StoreKey key, ByteBuffer target, ByteBuffer serializationBuffer) {
        ByteBuffer keyBuf = key.serialize(serializationBuffer);
        int keyPos = keyBuf.position();
        if (previousKey != null) {
            int mismatch = previousKey.mismatch(keyBuf);
            Preconditions.checkState((mismatch != -1 ? 1 : 0) != 0, (Object)"Previous and current keys must not be equal");
            int strip = previousKey.remaining() - mismatch;
            Ser.putVarInt(target, strip);
            keyBuf.position(keyPos + mismatch);
        } else {
            previousKey = StoreIndexImpl.newKeyBuffer();
        }
        target.put(keyBuf);
        previousKey.clear();
        keyBuf.position(keyPos);
        previousKey.put(keyBuf).flip();
        return previousKey;
    }

    static <V> StoreIndex<V> deserializeStoreIndex(ByteBuffer serialized, ElementSerializer<V> ser) {
        return new StoreIndexImpl<V>(serialized, ser);
    }

    private StoreIndexImpl(ByteBuffer serialized, ElementSerializer<V> ser) {
        byte version = serialized.get();
        Preconditions.checkArgument((version == 1 || version == 2 ? 1 : 0) != 0, (Object)"Unsupported serialized representation of KeyIndexSegment");
        ArrayList<StoreIndexElement<V>> elements = version >= 2 ? new ArrayList<StoreIndexElement<V>>(Ser.readVarInt(serialized)) : new ArrayList();
        boolean first = true;
        ByteBuffer previousKey = StoreIndexImpl.newKeyBuffer();
        while (serialized.remaining() > 0) {
            int strip = first ? 0 : Ser.readVarInt(serialized);
            first = false;
            previousKey.position(previousKey.position() - strip);
            previousKey.limit(4096);
            int limitSave = serialized.limit();
            previousKey.put(serialized.limit(StoreKey.findPositionAfterKey(serialized)));
            serialized.limit(limitSave);
            previousKey.flip();
            StoreKey key = StoreKey.deserializeKey(previousKey);
            int valueOffset = serialized.position();
            ser.skip(serialized);
            int endOffset = serialized.position();
            LazyStoreIndexElement element = new LazyStoreIndexElement(key, valueOffset, endOffset);
            elements.add(element);
        }
        this.elements = elements;
        this.serializer = ser;
        this.serialized = serialized.duplicate().clear();
        this.originalSerializedSize = serialized.position();
    }

    @VisibleForTesting
    static int serializedSize(StoreKey key) {
        int size = 2;
        return size += key.rawString().getBytes(StandardCharsets.UTF_8).length;
    }

    @VisibleForTesting
    static ByteBuffer newKeyBuffer() {
        return ByteBuffer.allocate(4096);
    }

    private static <V> int search(List<StoreIndexElement<V>> e, @javax.annotation.Nonnull @Nonnull StoreKey key) {
        return StoreIndexImpl.search(e, StoreIndexElement.indexElement(key, ""));
    }

    private static <V> int search(List<StoreIndexElement<V>> e, StoreIndexElement<?> element) {
        return Collections.binarySearch(e, element, KEY_COMPARATOR);
    }

    private final class LazyStoreIndexElement
    extends AbstractStoreIndexElement<V> {
        final int valueOffset;
        final int endOffset;
        private final StoreKey key;
        private V content;

        LazyStoreIndexElement(StoreKey key, int valueOffset, int endOffset) {
            this.key = key;
            this.valueOffset = valueOffset;
            this.endOffset = endOffset;
        }

        private ByteBuffer serializedForContent() {
            StoreIndexImpl index = StoreIndexImpl.this;
            ByteBuffer serialized = Objects.requireNonNull(index.serialized);
            return serialized.limit(this.endOffset).position(this.valueOffset);
        }

        private V materializeContent() {
            return StoreIndexImpl.this.serializer.deserialize(this.serializedForContent());
        }

        @Override
        public void serializeContent(ElementSerializer<V> ser, ByteBuffer target) {
            target.put(this.serializedForContent());
        }

        @Override
        public int contentSerializedSize(ElementSerializer<V> ser) {
            return this.endOffset - this.valueOffset;
        }

        @Override
        public StoreKey key() {
            return this.key;
        }

        @Override
        public V content() {
            Object c = this.content;
            if (c == null) {
                c = this.content = this.materializeContent();
            }
            return c;
        }

        @Override
        public String toString() {
            if (this.content != null) {
                return super.toString();
            }
            return "LazyStoreIndexElement(key = " + this.key + ", valueOffset='" + this.valueOffset + ")";
        }
    }
}

