/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import java.util.List;

public final class StoreKey
implements Comparable<StoreKey> {
    public static final int MAX_LENGTH = 500;
    private final String key;

    private StoreKey(String key) {
        this.key = key;
    }

    public String rawString() {
        return this.key;
    }

    @Override
    public int compareTo(StoreKey that) {
        return this.key.compareTo(that.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StoreKey)) {
            return false;
        }
        StoreKey that = (StoreKey)obj;
        return this.key.equals(that.key);
    }

    public static StoreKey keyFromString(String rawString) {
        return new StoreKey(rawString);
    }

    public static StoreKey key(String ... elements) {
        for (String element : elements) {
            StoreKey.checkElement(element);
        }
        return new StoreKey(String.join((CharSequence)"\u0000", elements));
    }

    public static StoreKey key(List<String> elements) {
        elements.forEach(StoreKey::checkElement);
        return new StoreKey(String.join((CharSequence)"\u0000", elements));
    }

    private static void checkElement(String element) {
        Preconditions.checkArgument((element != null && !element.isEmpty() ? 1 : 0) != 0, (Object)"Empty key elements are not allowed");
    }

    public ByteBuffer serialize(ByteBuffer keySerializationBuffer) {
        keySerializationBuffer.clear();
        try {
            StoreKey.putString(keySerializationBuffer, this.key);
            keySerializationBuffer.put((byte)0);
            keySerializationBuffer.put((byte)0);
        }
        catch (BufferOverflowException e) {
            throw new IllegalArgumentException("Serialized key too big");
        }
        keySerializationBuffer.flip();
        return keySerializationBuffer;
    }

    @VisibleForTesting
    static void putString(ByteBuffer buffer, String s) {
        char c;
        int i;
        int l = s.length();
        for (i = 0; i < l && (c = s.charAt(i)) <= '\u007f'; ++i) {
            buffer.put((byte)c);
        }
        while (i < l) {
            c = s.charAt(i);
            if (c <= '\u007f') {
                buffer.put((byte)c);
            } else if (c <= '\u07ff') {
                buffer.put((byte)(0xC0 | 0x1F & c >> 6));
                buffer.put((byte)(0x80 | 0x3F & c));
            } else if (Character.isSurrogate(c)) {
                char c2;
                int codePoint;
                int n = codePoint = i < l - 1 && Character.isSurrogatePair(c, c2 = s.charAt(i + 1)) ? Character.toCodePoint(c, c2) : -1;
                if (codePoint < 0) {
                    throw new IllegalArgumentException("Unmappable surrogate character (0x" + Integer.toString(c & 0xFFFF, 16) + " 0c" + Integer.toString(c & 0xFFFF, 16) + ")");
                }
                buffer.put((byte)(0xF0 | codePoint >> 18));
                buffer.put((byte)(0x80 | 0x3F & codePoint >> 12));
                buffer.put((byte)(0x80 | 0x3F & codePoint >> 6));
                buffer.put((byte)(0x80 | 0x3F & codePoint));
                ++i;
            } else {
                buffer.put((byte)(0xE0 | 0xF & c >> 12));
                buffer.put((byte)(0x80 | 0x3F & c >> 6));
                buffer.put((byte)(0x80 | 0x3F & c));
            }
            ++i;
        }
    }

    public static int findPositionAfterKey(ByteBuffer src) {
        int p = src.position();
        block0: while (true) {
            int i = 0;
            while (true) {
                if (src.get(p++) == 0) {
                    if (i != 0) continue block0;
                    return p;
                }
                ++i;
            }
            break;
        }
    }

    public static StoreKey deserializeKey(ByteBuffer src) {
        int p0 = src.position();
        block0: while (true) {
            int i = 0;
            while (true) {
                if (src.get() == 0) {
                    String s;
                    if (i != 0) continue block0;
                    int end = src.position() - 2;
                    int len = end - p0;
                    if (src.hasArray()) {
                        s = new String(src.array(), src.arrayOffset() + p0, len, StandardCharsets.UTF_8);
                    } else {
                        byte[] array = new byte[len];
                        src.position(p0);
                        src.get(array);
                        s = new String(array, StandardCharsets.UTF_8);
                    }
                    return new StoreKey(s);
                }
                ++i;
            }
            break;
        }
    }

    public StoreKey check() {
        Preconditions.checkState((this.key.length() <= 500 ? 1 : 0) != 0, (String)"Key too long, max allowed length: %s", (int)500);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.key.length());
        for (int i = 0; i < this.key.length(); ++i) {
            char c = this.key.charAt(i);
            switch (c) {
                case '\u0000': {
                    c = '/';
                    break;
                }
                case '\u0001': {
                    c = '.';
                    break;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public boolean startsWith(StoreKey prefix) {
        return this.key.startsWith(prefix.key);
    }

    public boolean startsWithElementsOrParts(StoreKey prefix) {
        int m = CharBuffer.wrap(this.key).mismatch(CharBuffer.wrap(prefix.key));
        if (m == -1) {
            return true;
        }
        if (m < prefix.key.length()) {
            return false;
        }
        char c = this.key.charAt(m);
        return c == '\u0000' || c == '\u0001';
    }

    public boolean endsWithElement(String element) {
        int elLen = element.length();
        int len = this.key.length();
        if (len < elLen + 1) {
            if (len == elLen) {
                return this.key.equals(element);
            }
            return false;
        }
        return this.key.charAt(len - elLen - 1) == '\u0000' && this.key.endsWith(element);
    }
}

