/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.time.Instant;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.InternalRef;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.RepositoryDescription;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.util.Ser;

final class RepositoryLogicImpl
implements RepositoryLogic {
    static final String REFS_HEADS = "refs/heads/";
    private final Persist persist;

    RepositoryLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    public void initialize(@javax.annotation.Nonnull @Nonnull String defaultBranchName) {
        this.initialize(defaultBranchName, true, b -> {});
    }

    @Override
    public void initialize(@javax.annotation.Nonnull @Nonnull String defaultBranchName, boolean createDefaultBranch, Consumer<RepositoryDescription.Builder> repositoryDescription) {
        this.initializeInternalRef(InternalRef.REF_REFS, b -> {});
        if (createDefaultBranch) {
            try {
                Logics.referenceLogic(this.persist).createReference(REFS_HEADS + defaultBranchName, ObjId.EMPTY_OBJ_ID, null);
            }
            catch (RefAlreadyExistsException refAlreadyExistsException) {
            }
            catch (RetryTimeoutException e) {
                throw new RuntimeException(e);
            }
        }
        this.initializeInternalRef(InternalRef.REF_REPO, b -> this.addRepositoryDescription((CreateCommit.Builder)b, repositoryDescription, defaultBranchName));
    }

    @Override
    public boolean repositoryExists() {
        try {
            Reference ref = this.persist.fetchReference(InternalRef.REF_REPO.name());
            if (ref == null) {
                return false;
            }
            CommitObj repoDescCommit = Logics.commitLogic(this.persist).fetchCommit(ref.pointer());
            return repoDescCommit != null;
        }
        catch (ObjNotFoundException e) {
            return false;
        }
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public RepositoryDescription fetchRepositoryDescription() {
        try {
            Reference ref = this.persist.fetchReference(InternalRef.REF_REPO.name());
            if (ref == null) {
                return null;
            }
            CommitObj repoDescCommit = Logics.commitLogic(this.persist).fetchCommit(ref.pointer());
            if (repoDescCommit == null) {
                return null;
            }
            StoreIndex<CommitOp> index = Logics.indexesLogic(this.persist).buildCompleteIndex(repoDescCommit, Optional.empty());
            StoreIndexElement<CommitOp> el = index.get(InternalRef.KEY_REPO_DESCRIPTION);
            if (el == null) {
                return null;
            }
            CommitOp op = el.content();
            if (!op.action().exists()) {
                return null;
            }
            StringObj obj = this.persist.fetchTypedObj(Objects.requireNonNull(op.value(), "Commit operation for repository description has no value"), ObjType.STRING, StringObj.class);
            return this.readRepositoryDescription(obj);
        }
        catch (ObjNotFoundException e) {
            return null;
        }
    }

    private RepositoryDescription readRepositoryDescription(StringObj stringObj) {
        try {
            return (RepositoryDescription)Ser.SHARED_OBJECT_MAPPER.readValue(stringObj.text().toByteArray(), RepositoryDescription.class);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void addRepositoryDescription(CreateCommit.Builder b, Consumer<RepositoryDescription.Builder> repositoryDescription, String defaultBranchName) {
        try {
            Instant now = Instant.now(this.persist.config().clock());
            RepositoryDescription.Builder repoDesc = RepositoryDescription.builder().oldestPossibleCommitTime(now).repositoryCreatedTime(now).defaultBranchName(defaultBranchName);
            repositoryDescription.accept(repoDesc);
            ByteString text = UnsafeByteOperations.unsafeWrap((byte[])Ser.SHARED_OBJECT_MAPPER.writeValueAsBytes((Object)repoDesc.build()));
            StringObj string = StringObj.stringData("application/json", Compression.NONE, null, Collections.emptyList(), text);
            this.persist.storeObj(string);
            b.addAdds(CreateCommit.Add.commitAdd(InternalRef.KEY_REPO_DESCRIPTION, 0, Objects.requireNonNull(string.id()), null, null));
        }
        catch (IOException | ObjTooLargeException e) {
            throw new RuntimeException(e);
        }
    }

    private void initializeInternalRef(InternalRef internalRef, Consumer<CreateCommit.Builder> commitEnhancer) {
        Reference reference = this.persist.fetchReference(internalRef.name());
        if (reference == null) {
            CommitObj commit;
            CreateCommit.Builder c = CreateCommit.newCommitBuilder().parentCommitId(ObjId.EMPTY_OBJ_ID).headers(CommitHeaders.EMPTY_COMMIT_HEADERS).message("Initialize reference " + internalRef.name()).commitType(CommitType.INTERNAL);
            commitEnhancer.accept(c);
            CommitLogic commitLogic = Logics.commitLogic(this.persist);
            try {
                commit = commitLogic.doCommit(c.build(), Collections.emptyList());
            }
            catch (CommitConflictException | ObjNotFoundException e) {
                throw new RuntimeException(e);
            }
            try {
                this.persist.addReference(Reference.reference(internalRef.name(), commit.id(), false, this.persist.config().currentTimeMicros(), null));
            }
            catch (RefAlreadyExistsException refAlreadyExistsException) {
                // empty catch block
            }
        }
    }
}

