/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.indexes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.indexes.AbstractStoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.ElementSerializer;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.util.Ser;

final class StoreIndexImpl<V>
implements StoreIndex<V> {
    static final int MAX_KEY_BYTES = 4096;
    private static final int ASSUMED_PER_ENTRY_OVERHEAD = 4;
    private static final int CURRENT_STORE_INDEX_VERSION = 2;
    private static final int SERIALIZE_VERSION = Integer.getInteger("nessie.internal.store-index-format-version", 2);
    public static final Comparator<StoreIndexElement<?>> KEY_COMPARATOR = Comparator.comparing(StoreIndexElement::key);
    private final int originalSerializedSize;
    private int estimatedSerializedSizeDiff;
    private final List<StoreIndexElement<V>> elements;
    private final ElementSerializer<V> serializer;
    private final ByteBuffer serialized;
    private final ByteBuffer scratchKeyBuffer = StoreIndexImpl.newKeyBuffer();
    private boolean modified;
    private ObjId objId;

    StoreIndexImpl(ElementSerializer<V> serializer) {
        this(new ArrayList<StoreIndexElement<V>>(), 2, serializer, false);
    }

    private StoreIndexImpl(List<StoreIndexElement<V>> elements, int originalSerializedSize, ElementSerializer<V> serializer, boolean modified) {
        this.elements = elements;
        this.originalSerializedSize = originalSerializedSize;
        this.serializer = serializer;
        this.modified = modified;
        this.serialized = null;
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @VisibleForTesting
    StoreIndexImpl<V> setModified() {
        this.modified = true;
        return this;
    }

    @Override
    public ObjId getObjId() {
        return this.objId;
    }

    @Override
    public StoreIndex<V> setObjId(ObjId objId) {
        this.objId = objId;
        return this;
    }

    @Override
    public StoreIndex<V> loadIfNecessary(Set<StoreKey> keys) {
        return this;
    }

    @Override
    public boolean isLoaded() {
        return true;
    }

    @Override
    public StoreIndex<V> asMutableIndex() {
        return this;
    }

    @Override
    public boolean isMutable() {
        return true;
    }

    @Override
    public List<StoreIndex<V>> divide(int parts) {
        List<StoreIndexElement<V>> elems = this.elements;
        int size = elems.size();
        Preconditions.checkArgument((parts > 0 && parts <= size ? 1 : 0) != 0, (String)"Number of parts %s must be greater than 0 and less or equal to number of elements %s", (int)parts, (int)size);
        int partSize = size / parts;
        int serializedMax = this.originalSerializedSize + this.estimatedSerializedSizeDiff;
        ArrayList<StoreIndex<V>> result = new ArrayList<StoreIndex<V>>(parts);
        int index = 0;
        for (int i = 0; i < parts; ++i) {
            int end = i < parts - 1 ? index + partSize : elems.size();
            ArrayList<StoreIndexElement<V>> partElements = new ArrayList<StoreIndexElement<V>>(this.elements.subList(index, end));
            StoreIndexImpl<V> part = new StoreIndexImpl<V>(partElements, serializedMax, this.serializer, true);
            result.add(part);
            index = end;
        }
        return result;
    }

    @Override
    public List<StoreIndex<V>> stripes() {
        return Collections.singletonList(this);
    }

    @Override
    public int elementCount() {
        return this.elements.size();
    }

    @Override
    public void updateAll(Function<StoreIndexElement<V>, V> updater) {
        List<StoreIndexElement<V>> e = this.elements;
        ElementSerializer<V> serializer = this.serializer;
        int size = e.size();
        for (int i = 0; i < size; ++i) {
            StoreIndexElement<V> el = e.get(i);
            V updated = updater.apply(el);
            if (updated == el) continue;
            this.modified = true;
            int oldSerializedSize = el.contentSerializedSize(serializer);
            if (updated == null) {
                e.remove(i);
                --i;
                --size;
                continue;
            }
            int newSerializedSize = serializer.serializedSize(updated);
            this.estimatedSerializedSizeDiff += newSerializedSize - oldSerializedSize;
            e.set(i, StoreIndexElement.indexElement(el.key(), updated));
        }
    }

    @Override
    public boolean add(@javax.annotation.Nonnull @Nonnull StoreIndexElement<V> element) {
        this.modified = true;
        List<StoreIndexElement<V>> e = this.elements;
        ElementSerializer<V> serializer = this.serializer;
        int idx = StoreIndexImpl.search(e, element);
        int elementSerializedSize = element.contentSerializedSize(serializer);
        if (idx >= 0) {
            StoreIndexElement<V> prev = e.get(idx);
            int prevSerializedSize = prev.contentSerializedSize(serializer);
            this.estimatedSerializedSizeDiff += elementSerializedSize - prevSerializedSize;
            e.set(idx, element);
            return false;
        }
        this.estimatedSerializedSizeDiff += StoreIndexImpl.addElementDiff(element, elementSerializedSize);
        int insertionPoint = -idx - 1;
        if (insertionPoint == e.size()) {
            e.add(element);
        } else {
            e.add(insertionPoint, element);
        }
        return true;
    }

    private static <V> int addElementDiff(StoreIndexElement<V> element, int elementSerializedSize) {
        return StoreIndexImpl.serializedSize(element.key()) + 4 + elementSerializedSize;
    }

    @Override
    public boolean remove(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        List<StoreIndexElement<V>> e = this.elements;
        int idx = StoreIndexImpl.search(e, key);
        if (idx < 0) {
            return false;
        }
        this.modified = true;
        StoreIndexElement<V> element = e.remove(idx);
        this.estimatedSerializedSizeDiff -= this.removeSizeDiff(element);
        return true;
    }

    private int removeSizeDiff(StoreIndexElement<V> element) {
        return 2 + element.contentSerializedSize(this.serializer);
    }

    @Override
    public boolean contains(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        int idx = StoreIndexImpl.search(this.elements, key);
        return idx >= 0;
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreIndexElement<V> get(@javax.annotation.Nonnull @Nonnull StoreKey key) {
        List<StoreIndexElement<V>> e = this.elements;
        int idx = StoreIndexImpl.search(e, key);
        if (idx < 0) {
            return null;
        }
        return e.get(idx);
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreKey first() {
        List<StoreIndexElement<V>> e = this.elements;
        return e.isEmpty() ? null : e.get(0).key();
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreKey last() {
        List<StoreIndexElement<V>> e = this.elements;
        return e.isEmpty() ? null : e.get(e.size() - 1).key();
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterator<StoreIndexElement<V>> iterator(final @javax.annotation.Nullable @Nullable StoreKey begin, @javax.annotation.Nullable @Nullable StoreKey end, boolean prefetch) {
        List<StoreIndexElement<V>> e = this.elements;
        if (begin == null && end == null) {
            return e.iterator();
        }
        boolean prefix = begin != null && begin.equals(end);
        int fromIdx = begin != null ? this.iteratorIndex(begin, 0) : 0;
        int toIdx = !prefix && end != null ? this.iteratorIndex(end, 1) : e.size();
        Preconditions.checkArgument((toIdx >= fromIdx ? 1 : 0) != 0, (Object)"'to' must be greater than 'from'");
        e = e.subList(fromIdx, toIdx);
        final Iterator<StoreIndexElement<V>> base = e.iterator();
        return prefix ? new AbstractIterator<StoreIndexElement<V>>(){

            protected StoreIndexElement<V> computeNext() {
                if (!base.hasNext()) {
                    return (StoreIndexElement)this.endOfData();
                }
                StoreIndexElement v = (StoreIndexElement)base.next();
                if (!v.key().startsWith(begin)) {
                    return (StoreIndexElement)this.endOfData();
                }
                return v;
            }
        } : base;
    }

    private int iteratorIndex(StoreKey from, int exactAdd) {
        int fromIdx = StoreIndexImpl.search(this.elements, from);
        fromIdx = fromIdx < 0 ? -fromIdx - 1 : (fromIdx += exactAdd);
        return fromIdx;
    }

    @VisibleForTesting
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StoreIndexImpl)) {
            return false;
        }
        StoreIndexImpl that = (StoreIndexImpl)o;
        return this.elements.equals(that.elements);
    }

    @VisibleForTesting
    public int hashCode() {
        return this.elements.hashCode();
    }

    public String toString() {
        StoreKey f = this.first();
        StoreKey l = this.last();
        String fk = f != null ? f.toString() : "";
        String lk = l != null ? l.toString() : "";
        return "StoreIndexImpl{size=" + this.elementCount() + ", first=" + fk + ", last=" + lk + "}";
    }

    @Override
    public List<StoreKey> asKeyList() {
        return new AbstractList<StoreKey>(){

            @Override
            public StoreKey get(int index) {
                return StoreIndexImpl.this.elements.get(index).key();
            }

            @Override
            public int size() {
                return StoreIndexImpl.this.elements.size();
            }
        };
    }

    @Override
    public int estimatedSerializedSize() {
        return this.originalSerializedSize + this.estimatedSerializedSizeDiff;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ByteString serialize() {
        ByteBuffer target;
        if (this.serialized == null || this.modified) {
            target = ByteBuffer.allocate(this.estimatedSerializedSize());
            if (SERIALIZE_VERSION >= 2) {
                target.put((byte)2);
                Ser.putVarInt(target, this.elementCount());
            } else {
                target.put((byte)1);
            }
            ByteBuffer previousKey = null;
            ElementSerializer<V> ser = this.serializer;
            List<StoreIndexElement<V>> elements = this.elements;
            StoreIndexElement<V> previous = null;
            for (int i = 0; i < elements.size(); ++i) {
                boolean onlyLazy;
                StoreIndexElement<V> el = elements.get(i);
                ByteBuffer keyBuf = null;
                if (el.getClass() == LazyStoreIndexElement.class) {
                    LazyStoreIndexElement lazyEl = (LazyStoreIndexElement)el;
                    onlyLazy = lazyEl.prefixLen == 0 || lazyEl.previous == previous;
                    if (onlyLazy) {
                        keyBuf = lazyEl.serializeKey(this.scratchKeyBuffer, previousKey);
                    }
                } else {
                    onlyLazy = false;
                }
                if (!onlyLazy) {
                    keyBuf = el.key().serialize(this.scratchKeyBuffer);
                }
                previousKey = this.serializeKey(keyBuf, previousKey, target);
                el.serializeContent(ser, target);
                previous = el;
            }
            target.flip();
        } else {
            target = this.serialized.position(0).limit(this.originalSerializedSize);
        }
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)target);
    }

    private ByteBuffer serializeKey(ByteBuffer keyBuf, ByteBuffer previousKey, ByteBuffer target) {
        int keyPos = keyBuf.position();
        if (previousKey != null) {
            int mismatch = previousKey.mismatch(keyBuf);
            Preconditions.checkState((mismatch != -1 ? 1 : 0) != 0, (Object)"Previous and current keys must not be equal");
            int strip = previousKey.remaining() - mismatch;
            Ser.putVarInt(target, strip);
            keyBuf.position(keyPos + mismatch);
        } else {
            previousKey = StoreIndexImpl.newKeyBuffer();
        }
        target.put(keyBuf);
        previousKey.clear();
        keyBuf.position(keyPos);
        previousKey.put(keyBuf).flip();
        return previousKey;
    }

    static <V> StoreIndex<V> deserializeStoreIndex(ByteBuffer serialized, ElementSerializer<V> ser) {
        return new StoreIndexImpl<V>(serialized, ser);
    }

    private StoreIndexImpl(ByteBuffer serialized, ElementSerializer<V> ser) {
        byte version = serialized.get();
        Preconditions.checkArgument((version == 1 || version == 2 ? 1 : 0) != 0, (Object)"Unsupported serialized representation of KeyIndexSegment");
        ArrayList<StoreIndexElement<V>> elements = version >= 2 ? new ArrayList<StoreIndexElement<V>>(Ser.readVarInt(serialized)) : new ArrayList();
        boolean first = true;
        int previousKeyLen = 0;
        LazyStoreIndexElement predecessor = null;
        LazyStoreIndexElement previous = null;
        while (serialized.remaining() > 0) {
            int strip = first ? 0 : Ser.readVarInt(serialized);
            first = false;
            int prefixLen = previousKeyLen - strip;
            int keyOffset = serialized.position();
            StoreKey.skipKey(serialized);
            int valueOffset = serialized.position();
            ser.skip(serialized);
            int endOffset = serialized.position();
            int keyPartLen = valueOffset - keyOffset;
            int totalKeyLen = prefixLen + keyPartLen;
            predecessor = this.cutPredecessor(predecessor, prefixLen, previous);
            LazyStoreIndexElement elementPredecessor = prefixLen > 0 ? predecessor : null;
            LazyStoreIndexElement element = new LazyStoreIndexElement(elementPredecessor, previous, keyOffset, prefixLen, valueOffset, endOffset);
            if (elementPredecessor == null) {
                predecessor = element;
            } else if (predecessor.prefixLen > prefixLen) {
                predecessor = element;
            }
            elements.add(element);
            previous = element;
            previousKeyLen = totalKeyLen;
        }
        this.elements = elements;
        this.serializer = ser;
        this.serialized = serialized.duplicate().clear();
        this.originalSerializedSize = serialized.position();
    }

    private LazyStoreIndexElement cutPredecessor(LazyStoreIndexElement predecessor, int prefixLen, LazyStoreIndexElement previous) {
        if (predecessor != null) {
            if (predecessor.prefixLen < prefixLen) {
                predecessor = previous;
            } else {
                LazyStoreIndexElement p = predecessor;
                while (p != null && p.prefixLen >= prefixLen) {
                    predecessor = p;
                    p = p.predecessor;
                }
            }
        }
        return predecessor;
    }

    @VisibleForTesting
    static int serializedSize(StoreKey key) {
        int size = 2;
        return size += key.rawString().getBytes(StandardCharsets.UTF_8).length;
    }

    @VisibleForTesting
    static ByteBuffer newKeyBuffer() {
        return ByteBuffer.allocate(4096);
    }

    private static <V> int search(List<StoreIndexElement<V>> e, @javax.annotation.Nonnull @Nonnull StoreKey key) {
        return StoreIndexImpl.search(e, StoreIndexElement.indexElement(key, ""));
    }

    private static <V> int search(List<StoreIndexElement<V>> e, StoreIndexElement<?> element) {
        return Collections.binarySearch(e, element, KEY_COMPARATOR);
    }

    private final class LazyStoreIndexElement
    extends AbstractStoreIndexElement<V> {
        final LazyStoreIndexElement predecessor;
        final LazyStoreIndexElement previous;
        final int prefixLen;
        final int keyOffset;
        final int valueOffset;
        final int endOffset;
        private StoreKey key;
        private V content;

        LazyStoreIndexElement(LazyStoreIndexElement predecessor, LazyStoreIndexElement previous, int keyOffset, int prefixLen, int valueOffset, int endOffset) {
            this.predecessor = predecessor;
            this.previous = previous;
            this.keyOffset = keyOffset;
            this.prefixLen = prefixLen;
            this.valueOffset = valueOffset;
            this.endOffset = endOffset;
        }

        ByteBuffer serializeKey(ByteBuffer keySerBuffer, ByteBuffer previousKey) {
            keySerBuffer.clear();
            if (previousKey != null) {
                int limitSave = previousKey.limit();
                keySerBuffer.put(previousKey.limit(this.prefixLen).position(0));
                previousKey.limit(limitSave).position(0);
            }
            StoreIndexImpl index = StoreIndexImpl.this;
            ByteBuffer serialized = Objects.requireNonNull(index.serialized);
            return keySerBuffer.put(serialized.limit(this.valueOffset).position(this.keyOffset)).flip();
        }

        private StoreKey materializeKey() {
            StoreIndexImpl index = StoreIndexImpl.this;
            ByteBuffer serialized = Objects.requireNonNull(index.serialized);
            ByteBuffer suffix = serialized.limit(this.valueOffset).position(this.keyOffset);
            int preLen = this.prefixLen;
            ByteBuffer keyBuffer = preLen > 0 ? this.prefixKey(serialized, this, preLen).position(preLen).put(suffix).flip() : suffix;
            return StoreKey.deserializeKey(keyBuffer);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ByteBuffer prefixKey(ByteBuffer serialized, LazyStoreIndexElement me, int remaining) {
            ByteBuffer keyBuffer = StoreIndexImpl.this.scratchKeyBuffer.clear();
            LazyStoreIndexElement e = me.predecessor;
            while (e != null) {
                if (e.key != null) {
                    int limitSave = keyBuffer.limit();
                    try {
                        StoreKey.putString(keyBuffer.limit(remaining).position(0), e.key.rawString(), true);
                        break;
                    }
                    finally {
                        keyBuffer.limit(limitSave);
                    }
                }
                int prefixLen = e.prefixLen;
                int take = remaining - prefixLen;
                if (take > 0) {
                    remaining -= take;
                    int src = e.keyOffset;
                    int dst = e.prefixLen;
                    while (take-- > 0) {
                        keyBuffer.put(dst, serialized.get(src));
                        ++src;
                        ++dst;
                    }
                }
                e = e.predecessor;
            }
            return keyBuffer;
        }

        private ByteBuffer serializedForContent() {
            StoreIndexImpl index = StoreIndexImpl.this;
            ByteBuffer serialized = Objects.requireNonNull(index.serialized);
            return serialized.limit(this.endOffset).position(this.valueOffset);
        }

        private V materializeContent() {
            return StoreIndexImpl.this.serializer.deserialize(this.serializedForContent());
        }

        @Override
        public void serializeContent(ElementSerializer<V> ser, ByteBuffer target) {
            target.put(this.serializedForContent());
        }

        @Override
        public int contentSerializedSize(ElementSerializer<V> ser) {
            return this.endOffset - this.valueOffset;
        }

        @Override
        public StoreKey key() {
            StoreKey k = this.key;
            if (k == null) {
                k = this.key = this.materializeKey();
            }
            return k;
        }

        @Override
        public V content() {
            Object c = this.content;
            if (c == null) {
                c = this.content = this.materializeContent();
            }
            return c;
        }

        @Override
        public String toString() {
            StoreKey k = this.key;
            Object c = this.content;
            if (k != null && c != null) {
                return super.toString();
            }
            StringBuilder sb = new StringBuilder("LazyStoreIndexElement(");
            if (k != null) {
                sb.append("key=").append(k);
            } else {
                sb.append("keyOffset=").append(this.keyOffset).append(", prefixLen=").append(this.prefixLen);
            }
            if (c != null) {
                sb.append(", content=").append(c);
            } else {
                sb.append(", valueOffset=").append(this.valueOffset).append(" endOffset=").append(this.endOffset);
            }
            return sb.toString();
        }
    }
}

