/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.logic.PagingToken;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="PagingToken", generator="Immutables")
@Immutable
public final class ImmutablePagingToken
implements PagingToken {
    private final ByteString token;

    private ImmutablePagingToken(ByteString token) {
        this.token = Objects.requireNonNull(token, "token");
    }

    private ImmutablePagingToken(ImmutablePagingToken original, ByteString token) {
        this.token = token;
    }

    @Override
    public ByteString token() {
        return this.token;
    }

    public final ImmutablePagingToken withToken(ByteString value) {
        if (this.token == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "token");
        return new ImmutablePagingToken(this, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutablePagingToken && this.equalTo(0, (ImmutablePagingToken)another);
    }

    private boolean equalTo(int synthetic, ImmutablePagingToken another) {
        return this.token.equals((Object)another.token);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.token.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"PagingToken").omitNullValues().add("token", (Object)this.token).toString();
    }

    public static ImmutablePagingToken of(ByteString token) {
        return new ImmutablePagingToken(token);
    }

    public static ImmutablePagingToken copyOf(PagingToken instance) {
        if (instance instanceof ImmutablePagingToken) {
            return (ImmutablePagingToken)instance;
        }
        return ImmutablePagingToken.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="PagingToken", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TOKEN = 1L;
        private long initBits = 1L;
        @Nullable
        private ByteString token;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(PagingToken instance) {
            Objects.requireNonNull(instance, "instance");
            this.token(instance.token());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder token(ByteString token) {
            this.token = Objects.requireNonNull(token, "token");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutablePagingToken build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutablePagingToken(null, this.token);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("token");
            }
            return "Cannot build PagingToken, some of required attributes are not set " + attributes;
        }
    }
}

