/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="Reference", generator="Immutables")
@Immutable
public final class ImmutableReference
implements Reference {
    private final String name;
    private final ObjId pointer;
    private final boolean deleted;
    private final long createdAtMicros;
    @jakarta.annotation.Nullable
    private final ObjId extendedInfoObj;

    private ImmutableReference(String name, ObjId pointer, boolean deleted, long createdAtMicros, @jakarta.annotation.Nullable ObjId extendedInfoObj) {
        this.name = Objects.requireNonNull(name, "name");
        this.pointer = Objects.requireNonNull(pointer, "pointer");
        this.deleted = deleted;
        this.createdAtMicros = createdAtMicros;
        this.extendedInfoObj = extendedInfoObj;
    }

    private ImmutableReference(ImmutableReference original, String name, ObjId pointer, boolean deleted, long createdAtMicros, @jakarta.annotation.Nullable ObjId extendedInfoObj) {
        this.name = name;
        this.pointer = pointer;
        this.deleted = deleted;
        this.createdAtMicros = createdAtMicros;
        this.extendedInfoObj = extendedInfoObj;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public ObjId pointer() {
        return this.pointer;
    }

    @Override
    public boolean deleted() {
        return this.deleted;
    }

    @Override
    public long createdAtMicros() {
        return this.createdAtMicros;
    }

    @Override
    @jakarta.annotation.Nullable
    public ObjId extendedInfoObj() {
        return this.extendedInfoObj;
    }

    public final ImmutableReference withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableReference(this, newValue, this.pointer, this.deleted, this.createdAtMicros, this.extendedInfoObj);
    }

    public final ImmutableReference withPointer(ObjId value) {
        if (this.pointer == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "pointer");
        return new ImmutableReference(this, this.name, newValue, this.deleted, this.createdAtMicros, this.extendedInfoObj);
    }

    @Override
    public final ImmutableReference withDeleted(boolean value) {
        if (this.deleted == value) {
            return this;
        }
        return new ImmutableReference(this, this.name, this.pointer, value, this.createdAtMicros, this.extendedInfoObj);
    }

    public final ImmutableReference withCreatedAtMicros(long value) {
        if (this.createdAtMicros == value) {
            return this;
        }
        return new ImmutableReference(this, this.name, this.pointer, this.deleted, value, this.extendedInfoObj);
    }

    public final ImmutableReference withExtendedInfoObj(@jakarta.annotation.Nullable ObjId value) {
        if (this.extendedInfoObj == value) {
            return this;
        }
        return new ImmutableReference(this, this.name, this.pointer, this.deleted, this.createdAtMicros, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableReference && this.equalTo(0, (ImmutableReference)another);
    }

    private boolean equalTo(int synthetic, ImmutableReference another) {
        return this.name.equals(another.name) && this.pointer.equals(another.pointer) && this.deleted == another.deleted && this.createdAtMicros == another.createdAtMicros && Objects.equals(this.extendedInfoObj, another.extendedInfoObj);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.pointer.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.deleted);
        h += (h << 5) + Longs.hashCode((long)this.createdAtMicros);
        h += (h << 5) + Objects.hashCode(this.extendedInfoObj);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Reference").omitNullValues().add("name", (Object)this.name).add("pointer", (Object)this.pointer).add("deleted", this.deleted).add("createdAtMicros", this.createdAtMicros).add("extendedInfoObj", (Object)this.extendedInfoObj).toString();
    }

    public static ImmutableReference of(String name, ObjId pointer, boolean deleted, long createdAtMicros, @jakarta.annotation.Nullable ObjId extendedInfoObj) {
        return new ImmutableReference(name, pointer, deleted, createdAtMicros, extendedInfoObj);
    }

    public static ImmutableReference copyOf(Reference instance) {
        if (instance instanceof ImmutableReference) {
            return (ImmutableReference)instance;
        }
        return ImmutableReference.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="Reference", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_NAME = 1L;
        private static final long INIT_BIT_POINTER = 2L;
        private static final long INIT_BIT_DELETED = 4L;
        private static final long INIT_BIT_CREATED_AT_MICROS = 8L;
        private long initBits = 15L;
        @Nullable
        private String name;
        @Nullable
        private ObjId pointer;
        private boolean deleted;
        private long createdAtMicros;
        @Nullable
        private ObjId extendedInfoObj;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(Reference instance) {
            Objects.requireNonNull(instance, "instance");
            this.name(instance.name());
            this.pointer(instance.pointer());
            this.deleted(instance.deleted());
            this.createdAtMicros(instance.createdAtMicros());
            ObjId extendedInfoObjValue = instance.extendedInfoObj();
            if (extendedInfoObjValue != null) {
                this.extendedInfoObj(extendedInfoObjValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder pointer(ObjId pointer) {
            this.pointer = Objects.requireNonNull(pointer, "pointer");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleted(boolean deleted) {
            this.deleted = deleted;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder createdAtMicros(long createdAtMicros) {
            this.createdAtMicros = createdAtMicros;
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder extendedInfoObj(@jakarta.annotation.Nullable ObjId extendedInfoObj) {
            this.extendedInfoObj = extendedInfoObj;
            return this;
        }

        public ImmutableReference build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableReference(null, this.name, this.pointer, this.deleted, this.createdAtMicros, this.extendedInfoObj);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("pointer");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("deleted");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("createdAtMicros");
            }
            return "Cannot build Reference, some of required attributes are not set " + attributes;
        }
    }
}

