/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.config;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.config.StoreConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="StoreConfig.Adjustable", generator="Immutables")
@Immutable
public final class ImmutableAdjustable
implements StoreConfig.Adjustable {
    private final boolean validateNamespaces;
    private final String repositoryId;
    private final int commitRetries;
    private final long commitTimeoutMillis;
    private final long retryInitialSleepMillisLower;
    private final long retryInitialSleepMillisUpper;
    private final long retryMaxSleepMillis;
    private final int parentsPerCommit;
    private final int maxSerializedIndexSize;
    private final int maxIncrementalIndexSize;
    private final int maxReferenceStripesPerCommit;
    private final long assumedWallClockDriftMicros;
    private final Clock clock;
    private final int referencePreviousHeadCount;
    private final long referencePreviousHeadTimeSpanSeconds;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAdjustable(Builder builder) {
        if (builder.validateNamespacesIsSet()) {
            this.initShim.validateNamespaces(builder.validateNamespaces);
        }
        if (builder.repositoryId != null) {
            this.initShim.repositoryId(builder.repositoryId);
        }
        if (builder.commitRetriesIsSet()) {
            this.initShim.commitRetries(builder.commitRetries);
        }
        if (builder.commitTimeoutMillisIsSet()) {
            this.initShim.commitTimeoutMillis(builder.commitTimeoutMillis);
        }
        if (builder.retryInitialSleepMillisLowerIsSet()) {
            this.initShim.retryInitialSleepMillisLower(builder.retryInitialSleepMillisLower);
        }
        if (builder.retryInitialSleepMillisUpperIsSet()) {
            this.initShim.retryInitialSleepMillisUpper(builder.retryInitialSleepMillisUpper);
        }
        if (builder.retryMaxSleepMillisIsSet()) {
            this.initShim.retryMaxSleepMillis(builder.retryMaxSleepMillis);
        }
        if (builder.parentsPerCommitIsSet()) {
            this.initShim.parentsPerCommit(builder.parentsPerCommit);
        }
        if (builder.maxSerializedIndexSizeIsSet()) {
            this.initShim.maxSerializedIndexSize(builder.maxSerializedIndexSize);
        }
        if (builder.maxIncrementalIndexSizeIsSet()) {
            this.initShim.maxIncrementalIndexSize(builder.maxIncrementalIndexSize);
        }
        if (builder.maxReferenceStripesPerCommitIsSet()) {
            this.initShim.maxReferenceStripesPerCommit(builder.maxReferenceStripesPerCommit);
        }
        if (builder.assumedWallClockDriftMicrosIsSet()) {
            this.initShim.assumedWallClockDriftMicros(builder.assumedWallClockDriftMicros);
        }
        if (builder.clock != null) {
            this.initShim.clock(builder.clock);
        }
        if (builder.referencePreviousHeadCountIsSet()) {
            this.initShim.referencePreviousHeadCount(builder.referencePreviousHeadCount);
        }
        if (builder.referencePreviousHeadTimeSpanSecondsIsSet()) {
            this.initShim.referencePreviousHeadTimeSpanSeconds(builder.referencePreviousHeadTimeSpanSeconds);
        }
        this.validateNamespaces = this.initShim.validateNamespaces();
        this.repositoryId = this.initShim.repositoryId();
        this.commitRetries = this.initShim.commitRetries();
        this.commitTimeoutMillis = this.initShim.commitTimeoutMillis();
        this.retryInitialSleepMillisLower = this.initShim.retryInitialSleepMillisLower();
        this.retryInitialSleepMillisUpper = this.initShim.retryInitialSleepMillisUpper();
        this.retryMaxSleepMillis = this.initShim.retryMaxSleepMillis();
        this.parentsPerCommit = this.initShim.parentsPerCommit();
        this.maxSerializedIndexSize = this.initShim.maxSerializedIndexSize();
        this.maxIncrementalIndexSize = this.initShim.maxIncrementalIndexSize();
        this.maxReferenceStripesPerCommit = this.initShim.maxReferenceStripesPerCommit();
        this.assumedWallClockDriftMicros = this.initShim.assumedWallClockDriftMicros();
        this.clock = this.initShim.clock();
        this.referencePreviousHeadCount = this.initShim.referencePreviousHeadCount();
        this.referencePreviousHeadTimeSpanSeconds = this.initShim.referencePreviousHeadTimeSpanSeconds();
        this.initShim = null;
    }

    private ImmutableAdjustable(boolean validateNamespaces, String repositoryId, int commitRetries, long commitTimeoutMillis, long retryInitialSleepMillisLower, long retryInitialSleepMillisUpper, long retryMaxSleepMillis, int parentsPerCommit, int maxSerializedIndexSize, int maxIncrementalIndexSize, int maxReferenceStripesPerCommit, long assumedWallClockDriftMicros, Clock clock, int referencePreviousHeadCount, long referencePreviousHeadTimeSpanSeconds) {
        this.validateNamespaces = validateNamespaces;
        this.repositoryId = repositoryId;
        this.commitRetries = commitRetries;
        this.commitTimeoutMillis = commitTimeoutMillis;
        this.retryInitialSleepMillisLower = retryInitialSleepMillisLower;
        this.retryInitialSleepMillisUpper = retryInitialSleepMillisUpper;
        this.retryMaxSleepMillis = retryMaxSleepMillis;
        this.parentsPerCommit = parentsPerCommit;
        this.maxSerializedIndexSize = maxSerializedIndexSize;
        this.maxIncrementalIndexSize = maxIncrementalIndexSize;
        this.maxReferenceStripesPerCommit = maxReferenceStripesPerCommit;
        this.assumedWallClockDriftMicros = assumedWallClockDriftMicros;
        this.clock = clock;
        this.referencePreviousHeadCount = referencePreviousHeadCount;
        this.referencePreviousHeadTimeSpanSeconds = referencePreviousHeadTimeSpanSeconds;
        this.initShim = null;
    }

    private boolean validateNamespacesInitialize() {
        return StoreConfig.Adjustable.super.validateNamespaces();
    }

    private String repositoryIdInitialize() {
        return StoreConfig.Adjustable.super.repositoryId();
    }

    private int commitRetriesInitialize() {
        return StoreConfig.Adjustable.super.commitRetries();
    }

    private long commitTimeoutMillisInitialize() {
        return StoreConfig.Adjustable.super.commitTimeoutMillis();
    }

    private long retryInitialSleepMillisLowerInitialize() {
        return StoreConfig.Adjustable.super.retryInitialSleepMillisLower();
    }

    private long retryInitialSleepMillisUpperInitialize() {
        return StoreConfig.Adjustable.super.retryInitialSleepMillisUpper();
    }

    private long retryMaxSleepMillisInitialize() {
        return StoreConfig.Adjustable.super.retryMaxSleepMillis();
    }

    private int parentsPerCommitInitialize() {
        return StoreConfig.Adjustable.super.parentsPerCommit();
    }

    private int maxSerializedIndexSizeInitialize() {
        return StoreConfig.Adjustable.super.maxSerializedIndexSize();
    }

    private int maxIncrementalIndexSizeInitialize() {
        return StoreConfig.Adjustable.super.maxIncrementalIndexSize();
    }

    private int maxReferenceStripesPerCommitInitialize() {
        return StoreConfig.Adjustable.super.maxReferenceStripesPerCommit();
    }

    private long assumedWallClockDriftMicrosInitialize() {
        return StoreConfig.Adjustable.super.assumedWallClockDriftMicros();
    }

    private Clock clockInitialize() {
        return StoreConfig.Adjustable.super.clock();
    }

    private int referencePreviousHeadCountInitialize() {
        return StoreConfig.Adjustable.super.referencePreviousHeadCount();
    }

    private long referencePreviousHeadTimeSpanSecondsInitialize() {
        return StoreConfig.Adjustable.super.referencePreviousHeadTimeSpanSeconds();
    }

    @Override
    public boolean validateNamespaces() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validateNamespaces() : this.validateNamespaces;
    }

    @Override
    public String repositoryId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.repositoryId() : this.repositoryId;
    }

    @Override
    public int commitRetries() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commitRetries() : this.commitRetries;
    }

    @Override
    public long commitTimeoutMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.commitTimeoutMillis() : this.commitTimeoutMillis;
    }

    @Override
    public long retryInitialSleepMillisLower() {
        InitShim shim = this.initShim;
        return shim != null ? shim.retryInitialSleepMillisLower() : this.retryInitialSleepMillisLower;
    }

    @Override
    public long retryInitialSleepMillisUpper() {
        InitShim shim = this.initShim;
        return shim != null ? shim.retryInitialSleepMillisUpper() : this.retryInitialSleepMillisUpper;
    }

    @Override
    public long retryMaxSleepMillis() {
        InitShim shim = this.initShim;
        return shim != null ? shim.retryMaxSleepMillis() : this.retryMaxSleepMillis;
    }

    @Override
    public int parentsPerCommit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.parentsPerCommit() : this.parentsPerCommit;
    }

    @Override
    public int maxSerializedIndexSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxSerializedIndexSize() : this.maxSerializedIndexSize;
    }

    @Override
    public int maxIncrementalIndexSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxIncrementalIndexSize() : this.maxIncrementalIndexSize;
    }

    @Override
    public int maxReferenceStripesPerCommit() {
        InitShim shim = this.initShim;
        return shim != null ? shim.maxReferenceStripesPerCommit() : this.maxReferenceStripesPerCommit;
    }

    @Override
    public long assumedWallClockDriftMicros() {
        InitShim shim = this.initShim;
        return shim != null ? shim.assumedWallClockDriftMicros() : this.assumedWallClockDriftMicros;
    }

    @Override
    public Clock clock() {
        InitShim shim = this.initShim;
        return shim != null ? shim.clock() : this.clock;
    }

    @Override
    public int referencePreviousHeadCount() {
        InitShim shim = this.initShim;
        return shim != null ? shim.referencePreviousHeadCount() : this.referencePreviousHeadCount;
    }

    @Override
    public long referencePreviousHeadTimeSpanSeconds() {
        InitShim shim = this.initShim;
        return shim != null ? shim.referencePreviousHeadTimeSpanSeconds() : this.referencePreviousHeadTimeSpanSeconds;
    }

    @Override
    public final ImmutableAdjustable withValidateNamespaces(boolean value) {
        if (this.validateNamespaces == value) {
            return this;
        }
        return new ImmutableAdjustable(value, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withRepositoryId(String value) {
        String newValue = Objects.requireNonNull(value, "repositoryId");
        if (this.repositoryId.equals(newValue)) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, newValue, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withCommitRetries(int value) {
        if (this.commitRetries == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, value, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withCommitTimeoutMillis(long value) {
        if (this.commitTimeoutMillis == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, value, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withRetryInitialSleepMillisLower(long value) {
        if (this.retryInitialSleepMillisLower == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, value, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withRetryInitialSleepMillisUpper(long value) {
        if (this.retryInitialSleepMillisUpper == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, value, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withRetryMaxSleepMillis(long value) {
        if (this.retryMaxSleepMillis == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, value, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withParentsPerCommit(int value) {
        if (this.parentsPerCommit == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, value, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withMaxSerializedIndexSize(int value) {
        if (this.maxSerializedIndexSize == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, value, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withMaxIncrementalIndexSize(int value) {
        if (this.maxIncrementalIndexSize == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, value, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withMaxReferenceStripesPerCommit(int value) {
        if (this.maxReferenceStripesPerCommit == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, value, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withAssumedWallClockDriftMicros(long value) {
        if (this.assumedWallClockDriftMicros == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, value, this.clock, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withClock(Clock value) {
        if (this.clock == value) {
            return this;
        }
        Clock newValue = Objects.requireNonNull(value, "clock");
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, newValue, this.referencePreviousHeadCount, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withReferencePreviousHeadCount(int value) {
        if (this.referencePreviousHeadCount == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, value, this.referencePreviousHeadTimeSpanSeconds);
    }

    @Override
    public final ImmutableAdjustable withReferencePreviousHeadTimeSpanSeconds(long value) {
        if (this.referencePreviousHeadTimeSpanSeconds == value) {
            return this;
        }
        return new ImmutableAdjustable(this.validateNamespaces, this.repositoryId, this.commitRetries, this.commitTimeoutMillis, this.retryInitialSleepMillisLower, this.retryInitialSleepMillisUpper, this.retryMaxSleepMillis, this.parentsPerCommit, this.maxSerializedIndexSize, this.maxIncrementalIndexSize, this.maxReferenceStripesPerCommit, this.assumedWallClockDriftMicros, this.clock, this.referencePreviousHeadCount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAdjustable && this.equalTo(0, (ImmutableAdjustable)another);
    }

    private boolean equalTo(int synthetic, ImmutableAdjustable another) {
        return this.validateNamespaces == another.validateNamespaces && this.repositoryId.equals(another.repositoryId) && this.commitRetries == another.commitRetries && this.commitTimeoutMillis == another.commitTimeoutMillis && this.retryInitialSleepMillisLower == another.retryInitialSleepMillisLower && this.retryInitialSleepMillisUpper == another.retryInitialSleepMillisUpper && this.retryMaxSleepMillis == another.retryMaxSleepMillis && this.parentsPerCommit == another.parentsPerCommit && this.maxSerializedIndexSize == another.maxSerializedIndexSize && this.maxIncrementalIndexSize == another.maxIncrementalIndexSize && this.maxReferenceStripesPerCommit == another.maxReferenceStripesPerCommit && this.assumedWallClockDriftMicros == another.assumedWallClockDriftMicros && this.clock.equals(another.clock) && this.referencePreviousHeadCount == another.referencePreviousHeadCount && this.referencePreviousHeadTimeSpanSeconds == another.referencePreviousHeadTimeSpanSeconds;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.validateNamespaces);
        h += (h << 5) + this.repositoryId.hashCode();
        h += (h << 5) + this.commitRetries;
        h += (h << 5) + Longs.hashCode((long)this.commitTimeoutMillis);
        h += (h << 5) + Longs.hashCode((long)this.retryInitialSleepMillisLower);
        h += (h << 5) + Longs.hashCode((long)this.retryInitialSleepMillisUpper);
        h += (h << 5) + Longs.hashCode((long)this.retryMaxSleepMillis);
        h += (h << 5) + this.parentsPerCommit;
        h += (h << 5) + this.maxSerializedIndexSize;
        h += (h << 5) + this.maxIncrementalIndexSize;
        h += (h << 5) + this.maxReferenceStripesPerCommit;
        h += (h << 5) + Longs.hashCode((long)this.assumedWallClockDriftMicros);
        h += (h << 5) + this.clock.hashCode();
        h += (h << 5) + this.referencePreviousHeadCount;
        h += (h << 5) + Longs.hashCode((long)this.referencePreviousHeadTimeSpanSeconds);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Adjustable").omitNullValues().add("validateNamespaces", this.validateNamespaces).add("repositoryId", (Object)this.repositoryId).add("commitRetries", this.commitRetries).add("commitTimeoutMillis", this.commitTimeoutMillis).add("retryInitialSleepMillisLower", this.retryInitialSleepMillisLower).add("retryInitialSleepMillisUpper", this.retryInitialSleepMillisUpper).add("retryMaxSleepMillis", this.retryMaxSleepMillis).add("parentsPerCommit", this.parentsPerCommit).add("maxSerializedIndexSize", this.maxSerializedIndexSize).add("maxIncrementalIndexSize", this.maxIncrementalIndexSize).add("maxReferenceStripesPerCommit", this.maxReferenceStripesPerCommit).add("assumedWallClockDriftMicros", this.assumedWallClockDriftMicros).add("clock", (Object)this.clock).add("referencePreviousHeadCount", this.referencePreviousHeadCount).add("referencePreviousHeadTimeSpanSeconds", this.referencePreviousHeadTimeSpanSeconds).toString();
    }

    public static ImmutableAdjustable copyOf(StoreConfig.Adjustable instance) {
        if (instance instanceof ImmutableAdjustable) {
            return (ImmutableAdjustable)instance;
        }
        return ImmutableAdjustable.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="StoreConfig.Adjustable", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_VALIDATE_NAMESPACES = 1L;
        private static final long OPT_BIT_COMMIT_RETRIES = 2L;
        private static final long OPT_BIT_COMMIT_TIMEOUT_MILLIS = 4L;
        private static final long OPT_BIT_RETRY_INITIAL_SLEEP_MILLIS_LOWER = 8L;
        private static final long OPT_BIT_RETRY_INITIAL_SLEEP_MILLIS_UPPER = 16L;
        private static final long OPT_BIT_RETRY_MAX_SLEEP_MILLIS = 32L;
        private static final long OPT_BIT_PARENTS_PER_COMMIT = 64L;
        private static final long OPT_BIT_MAX_SERIALIZED_INDEX_SIZE = 128L;
        private static final long OPT_BIT_MAX_INCREMENTAL_INDEX_SIZE = 256L;
        private static final long OPT_BIT_MAX_REFERENCE_STRIPES_PER_COMMIT = 512L;
        private static final long OPT_BIT_ASSUMED_WALL_CLOCK_DRIFT_MICROS = 1024L;
        private static final long OPT_BIT_REFERENCE_PREVIOUS_HEAD_COUNT = 2048L;
        private static final long OPT_BIT_REFERENCE_PREVIOUS_HEAD_TIME_SPAN_SECONDS = 4096L;
        private long optBits;
        private boolean validateNamespaces;
        @Nullable
        private String repositoryId;
        private int commitRetries;
        private long commitTimeoutMillis;
        private long retryInitialSleepMillisLower;
        private long retryInitialSleepMillisUpper;
        private long retryMaxSleepMillis;
        private int parentsPerCommit;
        private int maxSerializedIndexSize;
        private int maxIncrementalIndexSize;
        private int maxReferenceStripesPerCommit;
        private long assumedWallClockDriftMicros;
        @Nullable
        private Clock clock;
        private int referencePreviousHeadCount;
        private long referencePreviousHeadTimeSpanSeconds;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(StoreConfig.Adjustable instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(StoreConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            StoreConfig instance;
            long bits = 0L;
            if (object instanceof StoreConfig.Adjustable) {
                instance = (StoreConfig.Adjustable)object;
                if ((bits & 1L) == 0L) {
                    this.retryInitialSleepMillisUpper(instance.retryInitialSleepMillisUpper());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.retryMaxSleepMillis(instance.retryMaxSleepMillis());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.retryInitialSleepMillisLower(instance.retryInitialSleepMillisLower());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.assumedWallClockDriftMicros(instance.assumedWallClockDriftMicros());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.parentsPerCommit(instance.parentsPerCommit());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.clock(instance.clock());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.referencePreviousHeadCount(instance.referencePreviousHeadCount());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.commitRetries(instance.commitRetries());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.maxReferenceStripesPerCommit(instance.maxReferenceStripesPerCommit());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.referencePreviousHeadTimeSpanSeconds(instance.referencePreviousHeadTimeSpanSeconds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.validateNamespaces(instance.validateNamespaces());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.maxSerializedIndexSize(instance.maxSerializedIndexSize());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.repositoryId(instance.repositoryId());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.maxIncrementalIndexSize(instance.maxIncrementalIndexSize());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.commitTimeoutMillis(instance.commitTimeoutMillis());
                    bits |= 0x4000L;
                }
            }
            if (object instanceof StoreConfig) {
                instance = (StoreConfig)object;
                if ((bits & 1L) == 0L) {
                    this.retryInitialSleepMillisUpper(instance.retryInitialSleepMillisUpper());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.retryMaxSleepMillis(instance.retryMaxSleepMillis());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.retryInitialSleepMillisLower(instance.retryInitialSleepMillisLower());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    this.assumedWallClockDriftMicros(instance.assumedWallClockDriftMicros());
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.parentsPerCommit(instance.parentsPerCommit());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.clock(instance.clock());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.referencePreviousHeadCount(instance.referencePreviousHeadCount());
                    bits |= 0x40L;
                }
                if ((bits & 0x80L) == 0L) {
                    this.commitRetries(instance.commitRetries());
                    bits |= 0x80L;
                }
                if ((bits & 0x100L) == 0L) {
                    this.maxReferenceStripesPerCommit(instance.maxReferenceStripesPerCommit());
                    bits |= 0x100L;
                }
                if ((bits & 0x200L) == 0L) {
                    this.referencePreviousHeadTimeSpanSeconds(instance.referencePreviousHeadTimeSpanSeconds());
                    bits |= 0x200L;
                }
                if ((bits & 0x400L) == 0L) {
                    this.validateNamespaces(instance.validateNamespaces());
                    bits |= 0x400L;
                }
                if ((bits & 0x800L) == 0L) {
                    this.maxSerializedIndexSize(instance.maxSerializedIndexSize());
                    bits |= 0x800L;
                }
                if ((bits & 0x1000L) == 0L) {
                    this.repositoryId(instance.repositoryId());
                    bits |= 0x1000L;
                }
                if ((bits & 0x2000L) == 0L) {
                    this.maxIncrementalIndexSize(instance.maxIncrementalIndexSize());
                    bits |= 0x2000L;
                }
                if ((bits & 0x4000L) == 0L) {
                    this.commitTimeoutMillis(instance.commitTimeoutMillis());
                    bits |= 0x4000L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder validateNamespaces(boolean validateNamespaces) {
            this.validateNamespaces = validateNamespaces;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder repositoryId(String repositoryId) {
            this.repositoryId = Objects.requireNonNull(repositoryId, "repositoryId");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitRetries(int commitRetries) {
            this.commitRetries = commitRetries;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitTimeoutMillis(long commitTimeoutMillis) {
            this.commitTimeoutMillis = commitTimeoutMillis;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryInitialSleepMillisLower(long retryInitialSleepMillisLower) {
            this.retryInitialSleepMillisLower = retryInitialSleepMillisLower;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryInitialSleepMillisUpper(long retryInitialSleepMillisUpper) {
            this.retryInitialSleepMillisUpper = retryInitialSleepMillisUpper;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder retryMaxSleepMillis(long retryMaxSleepMillis) {
            this.retryMaxSleepMillis = retryMaxSleepMillis;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parentsPerCommit(int parentsPerCommit) {
            this.parentsPerCommit = parentsPerCommit;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxSerializedIndexSize(int maxSerializedIndexSize) {
            this.maxSerializedIndexSize = maxSerializedIndexSize;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxIncrementalIndexSize(int maxIncrementalIndexSize) {
            this.maxIncrementalIndexSize = maxIncrementalIndexSize;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder maxReferenceStripesPerCommit(int maxReferenceStripesPerCommit) {
            this.maxReferenceStripesPerCommit = maxReferenceStripesPerCommit;
            this.optBits |= 0x200L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder assumedWallClockDriftMicros(long assumedWallClockDriftMicros) {
            this.assumedWallClockDriftMicros = assumedWallClockDriftMicros;
            this.optBits |= 0x400L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder clock(Clock clock) {
            this.clock = Objects.requireNonNull(clock, "clock");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referencePreviousHeadCount(int referencePreviousHeadCount) {
            this.referencePreviousHeadCount = referencePreviousHeadCount;
            this.optBits |= 0x800L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder referencePreviousHeadTimeSpanSeconds(long referencePreviousHeadTimeSpanSeconds) {
            this.referencePreviousHeadTimeSpanSeconds = referencePreviousHeadTimeSpanSeconds;
            this.optBits |= 0x1000L;
            return this;
        }

        public ImmutableAdjustable build() {
            return new ImmutableAdjustable(this);
        }

        private boolean validateNamespacesIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean commitRetriesIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean commitTimeoutMillisIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean retryInitialSleepMillisLowerIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean retryInitialSleepMillisUpperIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean retryMaxSleepMillisIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean parentsPerCommitIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean maxSerializedIndexSizeIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean maxIncrementalIndexSizeIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean maxReferenceStripesPerCommitIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean assumedWallClockDriftMicrosIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean referencePreviousHeadCountIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }

        private boolean referencePreviousHeadTimeSpanSecondsIsSet() {
            return (this.optBits & 0x1000L) != 0L;
        }
    }

    @Generated(from="StoreConfig.Adjustable", generator="Immutables")
    private final class InitShim {
        private byte validateNamespacesBuildStage = 0;
        private boolean validateNamespaces;
        private byte repositoryIdBuildStage = 0;
        private String repositoryId;
        private byte commitRetriesBuildStage = 0;
        private int commitRetries;
        private byte commitTimeoutMillisBuildStage = 0;
        private long commitTimeoutMillis;
        private byte retryInitialSleepMillisLowerBuildStage = 0;
        private long retryInitialSleepMillisLower;
        private byte retryInitialSleepMillisUpperBuildStage = 0;
        private long retryInitialSleepMillisUpper;
        private byte retryMaxSleepMillisBuildStage = 0;
        private long retryMaxSleepMillis;
        private byte parentsPerCommitBuildStage = 0;
        private int parentsPerCommit;
        private byte maxSerializedIndexSizeBuildStage = 0;
        private int maxSerializedIndexSize;
        private byte maxIncrementalIndexSizeBuildStage = 0;
        private int maxIncrementalIndexSize;
        private byte maxReferenceStripesPerCommitBuildStage = 0;
        private int maxReferenceStripesPerCommit;
        private byte assumedWallClockDriftMicrosBuildStage = 0;
        private long assumedWallClockDriftMicros;
        private byte clockBuildStage = 0;
        private Clock clock;
        private byte referencePreviousHeadCountBuildStage = 0;
        private int referencePreviousHeadCount;
        private byte referencePreviousHeadTimeSpanSecondsBuildStage = 0;
        private long referencePreviousHeadTimeSpanSeconds;

        private InitShim() {
        }

        boolean validateNamespaces() {
            if (this.validateNamespacesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validateNamespacesBuildStage == 0) {
                this.validateNamespacesBuildStage = (byte)-1;
                this.validateNamespaces = ImmutableAdjustable.this.validateNamespacesInitialize();
                this.validateNamespacesBuildStage = 1;
            }
            return this.validateNamespaces;
        }

        void validateNamespaces(boolean validateNamespaces) {
            this.validateNamespaces = validateNamespaces;
            this.validateNamespacesBuildStage = 1;
        }

        String repositoryId() {
            if (this.repositoryIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.repositoryIdBuildStage == 0) {
                this.repositoryIdBuildStage = (byte)-1;
                this.repositoryId = Objects.requireNonNull(ImmutableAdjustable.this.repositoryIdInitialize(), "repositoryId");
                this.repositoryIdBuildStage = 1;
            }
            return this.repositoryId;
        }

        void repositoryId(String repositoryId) {
            this.repositoryId = repositoryId;
            this.repositoryIdBuildStage = 1;
        }

        int commitRetries() {
            if (this.commitRetriesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitRetriesBuildStage == 0) {
                this.commitRetriesBuildStage = (byte)-1;
                this.commitRetries = ImmutableAdjustable.this.commitRetriesInitialize();
                this.commitRetriesBuildStage = 1;
            }
            return this.commitRetries;
        }

        void commitRetries(int commitRetries) {
            this.commitRetries = commitRetries;
            this.commitRetriesBuildStage = 1;
        }

        long commitTimeoutMillis() {
            if (this.commitTimeoutMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.commitTimeoutMillisBuildStage == 0) {
                this.commitTimeoutMillisBuildStage = (byte)-1;
                this.commitTimeoutMillis = ImmutableAdjustable.this.commitTimeoutMillisInitialize();
                this.commitTimeoutMillisBuildStage = 1;
            }
            return this.commitTimeoutMillis;
        }

        void commitTimeoutMillis(long commitTimeoutMillis) {
            this.commitTimeoutMillis = commitTimeoutMillis;
            this.commitTimeoutMillisBuildStage = 1;
        }

        long retryInitialSleepMillisLower() {
            if (this.retryInitialSleepMillisLowerBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryInitialSleepMillisLowerBuildStage == 0) {
                this.retryInitialSleepMillisLowerBuildStage = (byte)-1;
                this.retryInitialSleepMillisLower = ImmutableAdjustable.this.retryInitialSleepMillisLowerInitialize();
                this.retryInitialSleepMillisLowerBuildStage = 1;
            }
            return this.retryInitialSleepMillisLower;
        }

        void retryInitialSleepMillisLower(long retryInitialSleepMillisLower) {
            this.retryInitialSleepMillisLower = retryInitialSleepMillisLower;
            this.retryInitialSleepMillisLowerBuildStage = 1;
        }

        long retryInitialSleepMillisUpper() {
            if (this.retryInitialSleepMillisUpperBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryInitialSleepMillisUpperBuildStage == 0) {
                this.retryInitialSleepMillisUpperBuildStage = (byte)-1;
                this.retryInitialSleepMillisUpper = ImmutableAdjustable.this.retryInitialSleepMillisUpperInitialize();
                this.retryInitialSleepMillisUpperBuildStage = 1;
            }
            return this.retryInitialSleepMillisUpper;
        }

        void retryInitialSleepMillisUpper(long retryInitialSleepMillisUpper) {
            this.retryInitialSleepMillisUpper = retryInitialSleepMillisUpper;
            this.retryInitialSleepMillisUpperBuildStage = 1;
        }

        long retryMaxSleepMillis() {
            if (this.retryMaxSleepMillisBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.retryMaxSleepMillisBuildStage == 0) {
                this.retryMaxSleepMillisBuildStage = (byte)-1;
                this.retryMaxSleepMillis = ImmutableAdjustable.this.retryMaxSleepMillisInitialize();
                this.retryMaxSleepMillisBuildStage = 1;
            }
            return this.retryMaxSleepMillis;
        }

        void retryMaxSleepMillis(long retryMaxSleepMillis) {
            this.retryMaxSleepMillis = retryMaxSleepMillis;
            this.retryMaxSleepMillisBuildStage = 1;
        }

        int parentsPerCommit() {
            if (this.parentsPerCommitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.parentsPerCommitBuildStage == 0) {
                this.parentsPerCommitBuildStage = (byte)-1;
                this.parentsPerCommit = ImmutableAdjustable.this.parentsPerCommitInitialize();
                this.parentsPerCommitBuildStage = 1;
            }
            return this.parentsPerCommit;
        }

        void parentsPerCommit(int parentsPerCommit) {
            this.parentsPerCommit = parentsPerCommit;
            this.parentsPerCommitBuildStage = 1;
        }

        int maxSerializedIndexSize() {
            if (this.maxSerializedIndexSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxSerializedIndexSizeBuildStage == 0) {
                this.maxSerializedIndexSizeBuildStage = (byte)-1;
                this.maxSerializedIndexSize = ImmutableAdjustable.this.maxSerializedIndexSizeInitialize();
                this.maxSerializedIndexSizeBuildStage = 1;
            }
            return this.maxSerializedIndexSize;
        }

        void maxSerializedIndexSize(int maxSerializedIndexSize) {
            this.maxSerializedIndexSize = maxSerializedIndexSize;
            this.maxSerializedIndexSizeBuildStage = 1;
        }

        int maxIncrementalIndexSize() {
            if (this.maxIncrementalIndexSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxIncrementalIndexSizeBuildStage == 0) {
                this.maxIncrementalIndexSizeBuildStage = (byte)-1;
                this.maxIncrementalIndexSize = ImmutableAdjustable.this.maxIncrementalIndexSizeInitialize();
                this.maxIncrementalIndexSizeBuildStage = 1;
            }
            return this.maxIncrementalIndexSize;
        }

        void maxIncrementalIndexSize(int maxIncrementalIndexSize) {
            this.maxIncrementalIndexSize = maxIncrementalIndexSize;
            this.maxIncrementalIndexSizeBuildStage = 1;
        }

        int maxReferenceStripesPerCommit() {
            if (this.maxReferenceStripesPerCommitBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.maxReferenceStripesPerCommitBuildStage == 0) {
                this.maxReferenceStripesPerCommitBuildStage = (byte)-1;
                this.maxReferenceStripesPerCommit = ImmutableAdjustable.this.maxReferenceStripesPerCommitInitialize();
                this.maxReferenceStripesPerCommitBuildStage = 1;
            }
            return this.maxReferenceStripesPerCommit;
        }

        void maxReferenceStripesPerCommit(int maxReferenceStripesPerCommit) {
            this.maxReferenceStripesPerCommit = maxReferenceStripesPerCommit;
            this.maxReferenceStripesPerCommitBuildStage = 1;
        }

        long assumedWallClockDriftMicros() {
            if (this.assumedWallClockDriftMicrosBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.assumedWallClockDriftMicrosBuildStage == 0) {
                this.assumedWallClockDriftMicrosBuildStage = (byte)-1;
                this.assumedWallClockDriftMicros = ImmutableAdjustable.this.assumedWallClockDriftMicrosInitialize();
                this.assumedWallClockDriftMicrosBuildStage = 1;
            }
            return this.assumedWallClockDriftMicros;
        }

        void assumedWallClockDriftMicros(long assumedWallClockDriftMicros) {
            this.assumedWallClockDriftMicros = assumedWallClockDriftMicros;
            this.assumedWallClockDriftMicrosBuildStage = 1;
        }

        Clock clock() {
            if (this.clockBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.clockBuildStage == 0) {
                this.clockBuildStage = (byte)-1;
                this.clock = Objects.requireNonNull(ImmutableAdjustable.this.clockInitialize(), "clock");
                this.clockBuildStage = 1;
            }
            return this.clock;
        }

        void clock(Clock clock) {
            this.clock = clock;
            this.clockBuildStage = 1;
        }

        int referencePreviousHeadCount() {
            if (this.referencePreviousHeadCountBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.referencePreviousHeadCountBuildStage == 0) {
                this.referencePreviousHeadCountBuildStage = (byte)-1;
                this.referencePreviousHeadCount = ImmutableAdjustable.this.referencePreviousHeadCountInitialize();
                this.referencePreviousHeadCountBuildStage = 1;
            }
            return this.referencePreviousHeadCount;
        }

        void referencePreviousHeadCount(int referencePreviousHeadCount) {
            this.referencePreviousHeadCount = referencePreviousHeadCount;
            this.referencePreviousHeadCountBuildStage = 1;
        }

        long referencePreviousHeadTimeSpanSeconds() {
            if (this.referencePreviousHeadTimeSpanSecondsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.referencePreviousHeadTimeSpanSecondsBuildStage == 0) {
                this.referencePreviousHeadTimeSpanSecondsBuildStage = (byte)-1;
                this.referencePreviousHeadTimeSpanSeconds = ImmutableAdjustable.this.referencePreviousHeadTimeSpanSecondsInitialize();
                this.referencePreviousHeadTimeSpanSecondsBuildStage = 1;
            }
            return this.referencePreviousHeadTimeSpanSeconds;
        }

        void referencePreviousHeadTimeSpanSeconds(long referencePreviousHeadTimeSpanSeconds) {
            this.referencePreviousHeadTimeSpanSeconds = referencePreviousHeadTimeSpanSeconds;
            this.referencePreviousHeadTimeSpanSecondsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.validateNamespacesBuildStage == -1) {
                attributes.add("validateNamespaces");
            }
            if (this.repositoryIdBuildStage == -1) {
                attributes.add("repositoryId");
            }
            if (this.commitRetriesBuildStage == -1) {
                attributes.add("commitRetries");
            }
            if (this.commitTimeoutMillisBuildStage == -1) {
                attributes.add("commitTimeoutMillis");
            }
            if (this.retryInitialSleepMillisLowerBuildStage == -1) {
                attributes.add("retryInitialSleepMillisLower");
            }
            if (this.retryInitialSleepMillisUpperBuildStage == -1) {
                attributes.add("retryInitialSleepMillisUpper");
            }
            if (this.retryMaxSleepMillisBuildStage == -1) {
                attributes.add("retryMaxSleepMillis");
            }
            if (this.parentsPerCommitBuildStage == -1) {
                attributes.add("parentsPerCommit");
            }
            if (this.maxSerializedIndexSizeBuildStage == -1) {
                attributes.add("maxSerializedIndexSize");
            }
            if (this.maxIncrementalIndexSizeBuildStage == -1) {
                attributes.add("maxIncrementalIndexSize");
            }
            if (this.maxReferenceStripesPerCommitBuildStage == -1) {
                attributes.add("maxReferenceStripesPerCommit");
            }
            if (this.assumedWallClockDriftMicrosBuildStage == -1) {
                attributes.add("assumedWallClockDriftMicros");
            }
            if (this.clockBuildStage == -1) {
                attributes.add("clock");
            }
            if (this.referencePreviousHeadCountBuildStage == -1) {
                attributes.add("referencePreviousHeadCount");
            }
            if (this.referencePreviousHeadTimeSpanSecondsBuildStage == -1) {
                attributes.add("referencePreviousHeadTimeSpanSeconds");
            }
            return "Cannot build Adjustable, attribute initializers form cycle " + attributes;
        }
    }
}

