/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.CommitConflictException;
import org.projectnessie.versioned.storage.common.exceptions.CommitWrappedException;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitConflict;
import org.projectnessie.versioned.storage.common.logic.CommitRetry;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.logic.InternalRef;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.logic.ReferenceLogic;
import org.projectnessie.versioned.storage.common.logic.ReferencesQuery;
import org.projectnessie.versioned.storage.common.logic.SuppliedCommitIndex;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ReferenceLogicImpl
implements ReferenceLogic {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReferenceLogicImpl.class);
    private static final String REF_REFS_ADVANCED = "ref-refs advanced";
    private final Persist persist;

    ReferenceLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public List<Reference> getReferences(@javax.annotation.Nonnull @Nonnull List<String> references) {
        String[] refsArray;
        int refCount = references.size();
        int refRefsIndex = references.indexOf(InternalRef.REF_REFS.name());
        if (refRefsIndex != -1) {
            refsArray = references.toArray(new String[refCount]);
        } else {
            refsArray = references.toArray(new String[refCount + 1]);
            refRefsIndex = references.size();
            refsArray[refRefsIndex] = InternalRef.REF_REFS.name();
        }
        Reference[] refs = this.persist.fetchReferences(refsArray);
        Supplier<SuppliedCommitIndex> refsIndexSupplier = this.createRefsIndexSupplier(refs[refRefsIndex]);
        ArrayList<Reference> r = new ArrayList<Reference>(refCount);
        for (int i = 0; i < refCount; ++i) {
            Reference ref = refs[i];
            ref = this.maybeRecover(references.get(i), ref, refsIndexSupplier);
            if (ref != null && ref.name().startsWith("int/")) {
                ref = null;
            }
            r.add(ref);
        }
        return r;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public PagedResult<Reference, String> queryReferences(@javax.annotation.Nonnull @Nonnull ReferencesQuery referencesQuery) {
        Optional<PagingToken> pagingToken = referencesQuery.pagingToken();
        StoreKey prefix = referencesQuery.referencePrefix().map(StoreKey::keyFromString).orElse(null);
        StoreKey begin = pagingToken.map(PagingToken::token).map(ByteString::toStringUtf8).map(xva$0 -> StoreKey.key(xva$0)).orElse(prefix);
        SuppliedCommitIndex index = this.createRefsIndexSupplier().get();
        return new QueryIter(index, prefix, begin, referencesQuery.prefetch());
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Reference createReference(@javax.annotation.Nonnull @Nonnull String name, @javax.annotation.Nonnull @Nonnull ObjId pointer, @javax.annotation.Nullable @Nullable ObjId extendedInfoObj) throws RefAlreadyExistsException, RetryTimeoutException {
        Preconditions.checkArgument((!Reference.isInternalReferenceName(name) ? 1 : 0) != 0);
        long refCreatedTimestamp = this.persist.config().currentTimeMicros();
        block7: while (true) {
            CommitReferenceResult commitToIndex = this.commitCreateReference(name, pointer, extendedInfoObj, refCreatedTimestamp);
            Reference created = commitToIndex.created;
            LOGGER.debug("Committed create reference {} with outcome {}, existing is {}", new Object[]{created, commitToIndex.kind, commitToIndex.existing});
            switch (commitToIndex.kind) {
                case ADDED_TO_INDEX: {
                    Reference existing;
                    Preconditions.checkState((!created.deleted() ? 1 : 0) != 0, (Object)"internal error");
                    try {
                        return this.persist.addReference(created);
                    }
                    catch (RefAlreadyExistsException e) {
                        existing = e.reference();
                        if (Objects.equals(created, existing)) continue block7;
                        throw e;
                    }
                }
                case REF_ROW_MISSING: {
                    Reference existing = commitToIndex.existing;
                    Preconditions.checkState((!existing.deleted() ? 1 : 0) != 0, (Object)"internal error");
                    existing = this.persist.addReference(existing);
                    throw new RefAlreadyExistsException(existing);
                }
                case REF_ROW_EXISTS: {
                    Reference existing = commitToIndex.existing;
                    if (created.equals(existing)) {
                        return existing;
                    }
                    if (!existing.deleted()) {
                        throw new RefAlreadyExistsException(existing);
                    }
                    this.maybeRecover(name, existing, this.createRefsIndexSupplier());
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
    }

    @Override
    public void deleteReference(@javax.annotation.Nonnull @Nonnull String name, @javax.annotation.Nonnull @Nonnull ObjId expectedPointer) throws RefNotFoundException, RefConditionFailedException, RetryTimeoutException {
        Preconditions.checkArgument((!Reference.isInternalReferenceName(name) ? 1 : 0) != 0);
        Reference reference = this.persist.fetchReference(name);
        Supplier<SuppliedCommitIndex> indexSupplier = null;
        if (reference == null) {
            StoreKey nameKey = StoreKey.key(name);
            indexSupplier = this.createRefsIndexSupplier();
            StoreIndexElement<CommitOp> index = indexSupplier.get().index().get(nameKey);
            if (index == null) {
                throw new RefNotFoundException(Reference.reference(name, expectedPointer, false, 0L, null));
            }
            reference = this.maybeRecover(name, null, indexSupplier);
            if (reference == null) {
                throw new RefNotFoundException(Reference.reference(name, expectedPointer, false, 0L, null));
            }
        }
        boolean actAsAlreadyDeleted = reference.deleted();
        if (!reference.pointer().equals(expectedPointer) && !actAsAlreadyDeleted) {
            Reference recovered;
            if (indexSupplier == null) {
                indexSupplier = this.createRefsIndexSupplier();
            }
            throw new RefConditionFailedException((recovered = this.maybeRecover(name, reference, indexSupplier)) != null ? recovered : reference);
        }
        if (!actAsAlreadyDeleted) {
            this.persist.markReferenceAsDeleted(reference);
            LOGGER.debug("Reference {} marked as deleted", (Object)reference);
        }
        LOGGER.debug("Commit deleted reference {}", (Object)reference);
        this.commitDeleteReference(reference, null);
        LOGGER.debug("Committed deleted reference {}", (Object)reference);
        try {
            this.persist.purgeReference(reference);
            LOGGER.debug("Reference {} purged", (Object)reference);
        }
        catch (RefNotFoundException refNotFoundException) {
            // empty catch block
        }
        if (actAsAlreadyDeleted) {
            throw new RefNotFoundException(Reference.reference(name, expectedPointer, false, reference.createdAtMicros(), reference.extendedInfoObj(), reference.previousPointers()));
        }
    }

    @VisibleForTesting
    CommitReferenceResult commitCreateReference(String name, ObjId pointer, ObjId extendedInfoObj, long refCreatedTimestamp) throws RetryTimeoutException {
        Reference reference = Reference.reference(name, pointer, false, refCreatedTimestamp, extendedInfoObj);
        try {
            return CommitRetry.commitRetry(this.persist, (p, retryState) -> {
                Reference refRefs = Objects.requireNonNull(p.fetchReference(InternalRef.REF_REFS.name()));
                RefObj ref = RefObj.ref(name, pointer, refCreatedTimestamp, extendedInfoObj);
                try {
                    p.storeObj(ref);
                }
                catch (ObjTooLargeException e) {
                    throw new RuntimeException(e);
                }
                StoreKey k = StoreKey.key(name);
                Instant now = this.persist.config().clock().instant();
                CreateCommit c = CreateCommit.newCommitBuilder().message("Create reference " + name + " pointing to " + pointer).parentCommitId(refRefs.pointer()).addAdds(CreateCommit.Add.commitAdd(k, 0, Objects.requireNonNull(ref.id()), null, null)).headers(CommitHeaders.newCommitHeaders().add("operation", "create").add("name", name).add("head", pointer.toString()).add("timestamp", now.toString()).add("timestamp.millis", Long.toString(now.toEpochMilli())).build()).commitType(CommitType.INTERNAL).build();
                ReferenceLogicImpl.commitReferenceChange(p, refRefs, c);
                return new CommitReferenceResult(reference, null, CommitReferenceResult.Kind.ADDED_TO_INDEX);
            });
        }
        catch (CommitConflictException e) {
            RefObj ref;
            Preconditions.checkState((e.conflicts().size() == 1 ? 1 : 0) != 0, (String)"Unexpected amount of conflicts %s", e.conflicts());
            CommitConflict conflict = e.conflicts().get(0);
            Preconditions.checkState((conflict.conflictType() == CommitConflict.ConflictType.KEY_EXISTS ? 1 : 0) != 0, (String)"Unexpected conflict type %s", (Object)conflict);
            Supplier<SuppliedCommitIndex> indexSupplier = this.createRefsIndexSupplier();
            StoreIndexElement<CommitOp> el = indexSupplier.get().index().get(StoreKey.key(name));
            Preconditions.checkNotNull(el, (String)"Key %s missing in index", (Object)name);
            Reference existing = this.persist.fetchReference(name);
            if (existing != null) {
                return new CommitReferenceResult(reference, existing, CommitReferenceResult.Kind.REF_ROW_EXISTS);
            }
            try {
                ref = this.persist.fetchTypedObj(Objects.requireNonNull(el.content().value(), "Reference commit operation has no value"), ObjType.REF, RefObj.class);
            }
            catch (ObjNotFoundException ex) {
                throw new RuntimeException("Internal error getting reference creation object", e);
            }
            return new CommitReferenceResult(reference, Reference.reference(name, ref.initialPointer(), false, ref.createdAtMicros(), ref.extendedInfoObj()), CommitReferenceResult.Kind.REF_ROW_MISSING);
        }
        catch (CommitWrappedException e) {
            throw new RuntimeException(String.format("An unexpected internal error happened while committing the creation of the reference '%s'", reference), e.getCause());
        }
    }

    @VisibleForTesting
    void commitDeleteReference(Reference reference, ObjId expectedRefRefsHead) throws RetryTimeoutException {
        try {
            CommitRetry.commitRetry(this.persist, (p, retryState) -> {
                CommitOp indexElementContent;
                CommitObj commit;
                Reference refRefs = Objects.requireNonNull(p.fetchReference(InternalRef.REF_REFS.name()));
                if (expectedRefRefsHead != null && !refRefs.pointer().equals(expectedRefRefsHead)) {
                    throw new RuntimeException(REF_REFS_ADVANCED);
                }
                try {
                    commit = p.fetchTypedObj(refRefs.pointer(), ObjType.COMMIT, CommitObj.class);
                }
                catch (ObjNotFoundException e) {
                    throw new RuntimeException("Internal error getting reference creation log commit", e);
                }
                StoreIndex<CommitOp> index = Logics.indexesLogic(this.persist).buildCompleteIndexOrEmpty(commit);
                StoreKey key = StoreKey.key(reference.name());
                StoreIndexElement<CommitOp> indexElement = index.get(key);
                if (indexElement != null && (indexElementContent = indexElement.content()).action().exists()) {
                    Instant now = this.persist.config().clock().instant();
                    CreateCommit c = CreateCommit.newCommitBuilder().message("Drop reference " + reference.name() + " pointing to " + reference.pointer()).parentCommitId(refRefs.pointer()).addRemoves(CreateCommit.Remove.commitRemove(key, 0, Objects.requireNonNull(indexElementContent.value()), indexElementContent.contentId())).headers(CommitHeaders.newCommitHeaders().add("operation", "delete").add("name", reference.name()).add("head", reference.pointer().toString()).add("timestamp", now.toString()).add("timestamp.millis", Long.toString(now.toEpochMilli())).build()).commitType(CommitType.INTERNAL).build();
                    ReferenceLogicImpl.commitReferenceChange(p, refRefs, c);
                }
                return null;
            });
        }
        catch (CommitConflictException e) {
            throw new RuntimeException(String.format("An unexpected internal error happened while committing the deletion of the reference '%s'", reference), e);
        }
        catch (CommitWrappedException e) {
            throw new RuntimeException(String.format("An unexpected internal error happened while committing the deletion of the reference '%s'", reference), e.getCause());
        }
    }

    private static void commitReferenceChange(Persist p, Reference refRefs, CreateCommit c) throws CommitConflictException, CommitRetry.RetryException {
        CommitObj commit;
        try {
            commit = Logics.commitLogic(p).doCommit(c, Collections.emptyList());
        }
        catch (ObjNotFoundException e) {
            throw new RuntimeException("Internal error committing to log of references", e);
        }
        Preconditions.checkState((commit != null ? 1 : 0) != 0);
        try {
            p.updateReferencePointer(refRefs, commit.id());
        }
        catch (RefConditionFailedException e) {
            throw new CommitRetry.RetryException();
        }
        catch (RefNotFoundException e) {
            throw new RuntimeException("Internal reference not found", e);
        }
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Reference assignReference(@javax.annotation.Nonnull @Nonnull Reference current, @javax.annotation.Nonnull @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Preconditions.checkArgument((!current.isInternal() ? 1 : 0) != 0);
        return this.persist.updateReferencePointer(current, newPointer);
    }

    private Reference maybeRecover(@javax.annotation.Nonnull @Nonnull String name, Reference ref, @javax.annotation.Nonnull @Nonnull Supplier<SuppliedCommitIndex> refsIndexSupplier) {
        if (ref == null) {
            SuppliedCommitIndex suppliedIndex = refsIndexSupplier.get();
            StoreIndexElement<CommitOp> commitOp = suppliedIndex.index().get(StoreKey.key(name));
            if (commitOp == null) {
                return null;
            }
            CommitOp commitOpContent = commitOp.content();
            if (commitOpContent.action().exists()) {
                RefObj initialRef;
                try {
                    initialRef = this.persist.fetchTypedObj(Objects.requireNonNull(commitOpContent.value(), "Reference commit operation has no value"), ObjType.REF, RefObj.class);
                }
                catch (ObjNotFoundException e) {
                    throw new RuntimeException("Internal error getting reference creation object", e);
                }
                ref = Reference.reference(name, initialRef.initialPointer(), false, initialRef.createdAtMicros(), initialRef.extendedInfoObj());
                try {
                    if (this.refRefsOutOfDate(suppliedIndex)) {
                        return null;
                    }
                    LOGGER.debug("Recovering reference creation {} from commit op {}", (Object)ref, (Object)commitOp.content().action());
                    ref = this.persist.addReference(ref);
                    LOGGER.debug("Recovered reference creation {} from commit op {}", (Object)ref, (Object)commitOp.content().action());
                }
                catch (RefAlreadyExistsException e) {
                    ref = e.reference();
                }
                return ref;
            }
            return null;
        }
        if (ref.deleted()) {
            SuppliedCommitIndex suppliedIndex = refsIndexSupplier.get();
            StoreIndexElement<CommitOp> commitOp = suppliedIndex.index().get(StoreKey.key(name));
            if (commitOp == null) {
                throw new RuntimeException("Loaded Reference is marked as deleted, but not found in index");
            }
            CommitOp commitOpContent = commitOp.content();
            if (commitOpContent.action().exists()) {
                try {
                    if (this.refRefsOutOfDate(suppliedIndex)) {
                        return ref;
                    }
                    LOGGER.debug("Recovering reference deletion commit for {} from commit op {}", (Object)ref, (Object)commitOp.content().action());
                    this.commitDeleteReference(ref, suppliedIndex.pointer());
                    LOGGER.debug("Recovered reference deletion commit for {} from commit op {}", (Object)ref, (Object)commitOp.content().action());
                    this.persist.purgeReference(ref);
                }
                catch (RefConditionFailedException | RefNotFoundException initialRef) {
                }
                catch (RetryTimeoutException e) {
                    LOGGER.debug("Recovery of reference deletion commit-retry failed for {} from commit op {}", new Object[]{ref, commitOp.content().action(), e});
                    throw new RuntimeException(e);
                }
                catch (RuntimeException e) {
                    if (REF_REFS_ADVANCED.equals(e.getMessage())) {
                        return ref;
                    }
                    throw e;
                }
            } else {
                try {
                    LOGGER.debug("Recovering reference purge for {} from commit op {}", (Object)ref, (Object)commitOp.content().action());
                    this.persist.purgeReference(ref);
                }
                catch (RefConditionFailedException | RefNotFoundException e) {
                    LOGGER.debug("Recovery of reference purge for {} from commit op {} failed", new Object[]{ref, commitOp.content().action(), e});
                }
            }
            return null;
        }
        return ref;
    }

    private boolean refRefsOutOfDate(SuppliedCommitIndex index) {
        Reference refRefs = this.persist.fetchReference(InternalRef.REF_REFS.name());
        return !index.pointer().equals(Objects.requireNonNull(refRefs).pointer());
    }

    @VisibleForTesting
    Supplier<SuppliedCommitIndex> createRefsIndexSupplier() {
        return Logics.indexesLogic(this.persist).createIndexSupplier(() -> {
            Reference ref = this.persist.fetchReference(InternalRef.REF_REFS.name());
            return ref != null ? ref.pointer() : ObjId.EMPTY_OBJ_ID;
        });
    }

    @VisibleForTesting
    Supplier<SuppliedCommitIndex> createRefsIndexSupplier(Reference refRefs) {
        return Logics.indexesLogic(this.persist).createIndexSupplier(() -> refRefs != null ? refRefs.pointer() : ObjId.EMPTY_OBJ_ID);
    }

    static final class CommitReferenceResult {
        final Reference created;
        final Reference existing;
        final Kind kind;

        CommitReferenceResult(Reference reference, Reference existing, Kind kind) {
            this.created = reference;
            this.existing = existing;
            this.kind = kind;
        }

        public String toString() {
            return "CommitReferenceResult{created=" + this.created + ", existing=" + this.existing + ", kind=" + this.kind + "}";
        }

        static enum Kind {
            ADDED_TO_INDEX,
            REF_ROW_EXISTS,
            REF_ROW_MISSING;

        }
    }

    private final class QueryIter
    extends AbstractIterator<Reference>
    implements PagedResult<Reference, String> {
        private final SuppliedCommitIndex index;
        private final Iterator<StoreIndexElement<CommitOp>> base;
        private final StoreKey prefix;
        private static final int REFERENCES_BATCH_SIZE = 50;
        private final List<String> referencesBatch;
        private Iterator<Reference> referenceIterator = Collections.emptyIterator();

        private QueryIter(SuppliedCommitIndex index, StoreKey prefix, StoreKey begin, boolean prefetch) {
            this.index = index;
            this.prefix = prefix;
            this.base = index.index().iterator(begin, null, prefetch);
            this.referencesBatch = new ArrayList<String>(50);
        }

        protected Reference computeNext() {
            while (!this.referenceIterator.hasNext()) {
                if (!this.base.hasNext()) {
                    if (this.fetchReferencesBatch()) continue;
                    return (Reference)this.endOfData();
                }
                StoreIndexElement<CommitOp> el = this.base.next();
                StoreKey k = el.key();
                if (this.prefix != null && !k.startsWith(this.prefix)) continue;
                String name = k.rawString();
                this.referencesBatch.add(name);
                if (this.referencesBatch.size() != 50) continue;
                this.fetchReferencesBatch();
            }
            return this.referenceIterator.next();
        }

        private boolean fetchReferencesBatch() {
            if (this.referencesBatch.isEmpty()) {
                return false;
            }
            Reference[] refs = ReferenceLogicImpl.this.persist.fetchReferences(this.referencesBatch.toArray(new String[0]));
            ArrayList<Reference> refsList = new ArrayList<Reference>(refs.length);
            for (int i = 0; i < refs.length; ++i) {
                Reference ref = refs[i];
                ref = ReferenceLogicImpl.this.maybeRecover(this.referencesBatch.get(i), ref, () -> this.index);
                if (ref == null) continue;
                refsList.add(ref);
            }
            this.referencesBatch.clear();
            this.referenceIterator = refsList.iterator();
            return true;
        }

        @Override
        @javax.annotation.Nonnull
        @Nonnull
        public PagingToken tokenForKey(String key) {
            return key != null ? PagingToken.pagingToken(ByteString.copyFromUtf8((String)key)) : PagingToken.emptyPagingToken();
        }
    }
}

