/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import java.util.HashSet;
import java.util.Optional;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.logic.ConsistencyLogic;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;

final class ConsistencyLogicImpl
implements ConsistencyLogic {
    private final Persist persist;

    ConsistencyLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    public <R> R checkReference(Reference reference, ConsistencyLogic.CommitStatusCallback<R> callback) {
        R r = this.checkCommit(reference.pointer(), callback);
        for (Reference.PreviousPointer previousPointer : reference.previousPointers()) {
            this.checkCommit(previousPointer.pointer(), callback);
        }
        return r;
    }

    @Override
    public <R> R checkCommit(ObjId commitId, ConsistencyLogic.CommitStatusCallback<R> callback) {
        if (ObjId.EMPTY_OBJ_ID.equals(commitId)) {
            return callback.commitCallback(ConsistencyLogic.CommitStatus.commitStatus(commitId, null, true, true));
        }
        HashSet<ObjId> test = new HashSet<ObjId>();
        CommitObj commitObj = null;
        try {
            commitObj = this.persist.fetchTypedObj(commitId, ObjType.COMMIT, CommitObj.class);
            if (commitObj.referenceIndex() != null) {
                test.add(commitObj.referenceIndex());
            }
            for (IndexStripe stripe : commitObj.referenceIndexStripes()) {
                test.add(stripe.segment());
            }
            this.persist.fetchObjs(test.toArray(new ObjId[0]));
            test.clear();
        }
        catch (ObjNotFoundException notFound) {
            return callback.commitCallback(ConsistencyLogic.CommitStatus.commitStatus(commitId, commitObj, false, false));
        }
        try {
            StoreIndex<CommitOp> index = Logics.indexesLogic(this.persist).buildCompleteIndex(commitObj, Optional.empty());
            for (StoreIndexElement<CommitOp> storeIndexElement : index) {
                CommitOp op = storeIndexElement.content();
                if (!op.action().exists()) continue;
                test.add(op.value());
                if (test.size() != 50) continue;
                this.persist.fetchObjs(test.toArray(new ObjId[0]));
                test.clear();
            }
            if (!test.isEmpty()) {
                this.persist.fetchObjs(test.toArray(new ObjId[0]));
            }
            return callback.commitCallback(ConsistencyLogic.CommitStatus.commitStatus(commitId, commitObj, true, true));
        }
        catch (ObjNotFoundException notFound) {
            return callback.commitCallback(ConsistencyLogic.CommitStatus.commitStatus(commitId, commitObj, true, false));
        }
    }
}

