/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.indexes.IndexLoader;
import org.projectnessie.versioned.storage.common.indexes.StoreIndex;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexElement;
import org.projectnessie.versioned.storage.common.indexes.StoreIndexes;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CommitLogQuery;
import org.projectnessie.versioned.storage.common.logic.CommitLogic;
import org.projectnessie.versioned.storage.common.logic.IndexesLogic;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.SuppliedCommitIndex;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitOp;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.util.SupplyOnce;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class IndexesLogicImpl
implements IndexesLogic {
    private static final Logger LOGGER = LoggerFactory.getLogger(IndexesLogicImpl.class);
    private final Persist persist;

    IndexesLogicImpl(Persist persist) {
        this.persist = persist;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Supplier<SuppliedCommitIndex> createIndexSupplier(@javax.annotation.Nonnull @Nonnull Supplier<ObjId> commitIdSupplier) {
        return SupplyOnce.memoize(() -> {
            try {
                ObjId commitId = (ObjId)commitIdSupplier.get();
                CommitObj c = ObjId.EMPTY_OBJ_ID.equals(commitId) ? null : this.persist.fetchTypedObj(commitId, ObjType.COMMIT, CommitObj.class);
                return SuppliedCommitIndex.suppliedCommitIndex(commitId, this.buildCompleteIndexOrEmpty(c));
            }
            catch (ObjNotFoundException e) {
                throw new RuntimeException(e);
            }
        });
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> incrementalIndexForUpdate(@javax.annotation.Nonnull @Nonnull CommitObj commit, Optional<StoreIndex<CommitOp>> loadedIncrementalIndex) {
        Preconditions.checkArgument((!commit.incompleteIndex() ? 1 : 0) != 0, (String)"Commit %s has no complete key index", (Object)commit.id());
        boolean hasReferenceIndex = commit.hasReferenceIndex();
        StoreIndex i = loadedIncrementalIndex.orElseGet(() -> this.incrementalIndexFromCommit(commit));
        i.updateAll(el -> {
            CommitOp c = (CommitOp)el.content();
            switch (c.action()) {
                case ADD: {
                    c = CommitOp.commitOp(CommitOp.Action.INCREMENTAL_ADD, c.payload(), c.value(), c.contentId());
                    break;
                }
                case REMOVE: {
                    if (hasReferenceIndex) {
                        c = CommitOp.commitOp(CommitOp.Action.INCREMENTAL_REMOVE, c.payload(), c.value(), c.contentId());
                        break;
                    }
                    c = null;
                    break;
                }
                case INCREMENTAL_REMOVE: {
                    if (hasReferenceIndex) break;
                    c = null;
                    break;
                }
            }
            return c;
        });
        return i;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterable<StoreIndexElement<CommitOp>> commitOperations(@javax.annotation.Nonnull @Nonnull CommitObj commitObj) {
        return this.commitOperations(this.incrementalIndexFromCommit(commitObj));
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public Iterable<StoreIndexElement<CommitOp>> commitOperations(final @javax.annotation.Nonnull @Nonnull StoreIndex<CommitOp> index) {
        return () -> new AbstractIterator<StoreIndexElement<CommitOp>>(){
            final Iterator delegate;
            {
                this.delegate = index.iterator();
            }

            protected StoreIndexElement<CommitOp> computeNext() {
                StoreIndexElement el;
                Iterator d = this.delegate;
                do {
                    if (d.hasNext()) continue;
                    return (StoreIndexElement)this.endOfData();
                } while (!((CommitOp)(el = (StoreIndexElement)d.next()).content()).action().currentCommit());
                return el;
            }
        };
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> incrementalIndexFromCommit(@javax.annotation.Nonnull @Nonnull CommitObj commit) {
        return IndexesLogicImpl.deserializeIndex(commit.incrementalIndex());
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> buildCompleteIndex(@javax.annotation.Nonnull @Nonnull CommitObj commit, Optional<StoreIndex<CommitOp>> loadedIncrementalIndex) {
        StoreIndex<CommitOp> incremental;
        Preconditions.checkArgument((!commit.incompleteIndex() ? 1 : 0) != 0, (String)"Commit %s has no complete key index", (Object)commit.id());
        StoreIndex<CommitOp> index = incremental = loadedIncrementalIndex.orElseGet(() -> this.incrementalIndexFromCommit(commit));
        ObjId referenceIndexId = commit.referenceIndex();
        List<IndexStripe> commitStripes = commit.referenceIndexStripes();
        if (!commitStripes.isEmpty()) {
            Preconditions.checkState((referenceIndexId == null ? 1 : 0) != 0, (String)"Commit %s: must not have both pointer to a reference index and stripes", (Object)commit.id());
            StoreIndex<CommitOp> referenceIndex = this.referenceIndexFromStripes(commitStripes, commit.id());
            index = StoreIndexes.layeredIndex(referenceIndex, incremental);
        } else if (referenceIndexId != null) {
            StoreIndex<CommitOp> referenceIndex = this.buildReferenceIndexOnly(referenceIndexId, commit.id());
            index = StoreIndexes.layeredIndex(referenceIndex, incremental);
        }
        return index;
    }

    @Override
    @javax.annotation.Nullable
    @Nullable
    public StoreIndex<CommitOp> buildReferenceIndexOnly(@javax.annotation.Nonnull @Nonnull CommitObj commit) {
        ObjId referenceIndexId = commit.referenceIndex();
        List<IndexStripe> commitStripes = commit.referenceIndexStripes();
        if (!commitStripes.isEmpty()) {
            Preconditions.checkState((referenceIndexId == null ? 1 : 0) != 0, (String)"Commit %s: must not have both pointer to a reference index and stripes", (Object)commit.id());
            return this.referenceIndexFromStripes(commitStripes, commit.id());
        }
        if (referenceIndexId != null) {
            return this.buildReferenceIndexOnly(referenceIndexId, commit.id());
        }
        return null;
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public StoreIndex<CommitOp> buildReferenceIndexOnly(@javax.annotation.Nonnull @Nonnull ObjId indexId, @javax.annotation.Nonnull @Nonnull ObjId commitId) {
        return StoreIndexes.lazyStoreIndex(() -> this.loadReferenceIndex(indexId, commitId));
    }

    private StoreIndex<CommitOp> loadReferenceIndex(@javax.annotation.Nonnull @Nonnull ObjId indexId, @javax.annotation.Nonnull @Nonnull ObjId commitId) {
        StoreIndex<CommitOp> referenceIndex;
        Obj keyIndex;
        try {
            keyIndex = this.persist.fetchObj(indexId);
        }
        catch (ObjNotFoundException e) {
            throw new IllegalStateException(String.format("Commit %s references a reference index, which does not exist", indexId));
        }
        ObjType indexType = keyIndex.type();
        switch (indexType) {
            case INDEX_SEGMENTS: {
                IndexSegmentsObj split = (IndexSegmentsObj)keyIndex;
                List<IndexStripe> indexStripes = split.stripes();
                referenceIndex = this.referenceIndexFromStripes(indexStripes, commitId);
                break;
            }
            case INDEX: {
                referenceIndex = IndexesLogicImpl.deserializeIndex(((IndexObj)keyIndex).index()).setObjId(keyIndex.id());
                break;
            }
            default: {
                throw new IllegalStateException("Commit %s references a reference index, which is of unsupported key index type " + indexType);
            }
        }
        return referenceIndex;
    }

    static StoreIndex<CommitOp> deserializeIndex(ByteString serialized) {
        return StoreIndexes.deserializeStoreIndex(serialized, CommitOp.COMMIT_OP_SERIALIZER);
    }

    private StoreIndex<CommitOp> loadIndexSegment(@javax.annotation.Nonnull @Nonnull ObjId indexId) {
        IndexObj index;
        try {
            index = this.persist.fetchTypedObj(indexId, ObjType.INDEX, IndexObj.class);
        }
        catch (ObjNotFoundException e) {
            throw new IllegalStateException(String.format("Commit %s references a reference index, which does not exist", indexId));
        }
        return IndexesLogicImpl.deserializeIndex(index.index()).setObjId(indexId);
    }

    private StoreIndex<CommitOp>[] loadIndexSegments(@javax.annotation.Nonnull @Nonnull ObjId[] indexes) {
        try {
            Obj[] objs = this.persist.fetchObjs(indexes);
            StoreIndex[] r = new StoreIndex[indexes.length];
            for (int i = 0; i < objs.length; ++i) {
                Obj obj = objs[i];
                if (obj == null) continue;
                IndexObj index = (IndexObj)obj;
                r[i] = IndexesLogicImpl.deserializeIndex(index.index()).setObjId(indexes[i]);
            }
            return r;
        }
        catch (ObjNotFoundException e) {
            throw new IllegalStateException(String.format("Reference index segments %s not found", e.objIds()));
        }
    }

    private StoreIndex<CommitOp> referenceIndexFromStripes(List<IndexStripe> indexStripes, ObjId commitId) {
        ArrayList stripes = new ArrayList(indexStripes.size());
        ArrayList<StoreKey> firstLastKeys = new ArrayList<StoreKey>(indexStripes.size() * 2);
        StoreIndex[] loaded = new StoreIndex[indexStripes.size()];
        int i = 0;
        while (i < indexStripes.size()) {
            IndexStripe s = indexStripes.get(i);
            int idx = i++;
            stripes.add(StoreIndexes.lazyStoreIndex(() -> {
                StoreIndex<CommitOp> l = loaded[idx];
                if (l == null) {
                    LOGGER.debug("Individual fetch of stripe #{} of {} stripes for commit {}", new Object[]{idx, loaded.length, commitId});
                    loaded[idx] = l = this.loadIndexSegment(s.segment());
                }
                return l;
            }, s.firstKey(), s.lastKey()).setObjId(s.segment()));
            firstLastKeys.add(s.firstKey());
            firstLastKeys.add(s.lastKey());
        }
        if (stripes.size() == 1) {
            return (StoreIndex)stripes.get(0);
        }
        IndexLoader indexLoader = indexesToLoad -> {
            Preconditions.checkArgument((indexesToLoad.length == loaded.length ? 1 : 0) != 0);
            ObjId[] ids = new ObjId[indexesToLoad.length];
            int cnt = 0;
            for (int i = 0; i < indexesToLoad.length; ++i) {
                StoreIndex idx = indexesToLoad[i];
                if (idx == null) continue;
                ObjId segmentId = idx.getObjId();
                if (segmentId != null) {
                    ids[i] = idx.getObjId();
                    ++cnt;
                    continue;
                }
                LOGGER.warn("Reference index Segment #{} has no objId for commit {}", (Object)i, (Object)commitId);
            }
            LOGGER.debug("Fetching {} of {} index segments for commit {}", new Object[]{cnt, ids.length, commitId});
            StoreIndex[] indexes = this.loadIndexSegments(ids);
            for (int i = 0; i < indexes.length; ++i) {
                StoreIndex idx = indexes[i];
                if (idx != null) {
                    loaded[i] = idx;
                    continue;
                }
                if (ids[i] == null) continue;
                LOGGER.warn("Reference index Segment #{} has with id {} not loaded for commit {}", new Object[]{i, ids[i], commitId});
            }
            return indexes;
        };
        return StoreIndexes.indexFromSplits(stripes, firstLastKeys, indexLoader);
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public ObjId persistStripedIndex(@javax.annotation.Nonnull @Nonnull StoreIndex<CommitOp> stripedIndex) throws ObjTooLargeException {
        List<StoreIndex<CommitOp>> stripes = stripedIndex.stripes();
        if (stripes.isEmpty()) {
            return this.persistIndex(stripedIndex);
        }
        if (stripes.size() == 1) {
            return this.persistIndex(stripes.get(0));
        }
        ArrayList<Obj> toStore = new ArrayList<Obj>();
        List<IndexStripe> indexStripes = this.buildIndexStripes(stripes, toStore);
        IndexSegmentsObj referenceIndex = IndexSegmentsObj.indexSegments(indexStripes);
        toStore.add(referenceIndex);
        this.persist.storeObjs(toStore.toArray(new Obj[0]));
        return Objects.requireNonNull(referenceIndex.id());
    }

    @Override
    @javax.annotation.Nonnull
    @Nonnull
    public List<IndexStripe> persistIndexStripesFromIndex(@javax.annotation.Nonnull @Nonnull StoreIndex<CommitOp> stripedIndex) throws ObjTooLargeException {
        List<StoreIndex<CommitOp>> stripes = stripedIndex.stripes();
        ArrayList<Obj> toStore = new ArrayList<Obj>();
        List<IndexStripe> indexStripes = this.buildIndexStripes(stripes, toStore);
        this.persist.storeObjs(toStore.toArray(new Obj[0]));
        return indexStripes;
    }

    private List<IndexStripe> buildIndexStripes(List<StoreIndex<CommitOp>> stripes, List<Obj> toStore) {
        ArrayList<IndexStripe> indexStripes = new ArrayList<IndexStripe>(stripes.size());
        for (StoreIndex<CommitOp> indexSegment : stripes) {
            ObjId segId;
            if (!indexSegment.isModified()) {
                segId = Objects.requireNonNull(indexSegment.getObjId(), "Loaded index segment does not contain its ObjId");
            } else {
                IndexObj segment = IndexObj.index(indexSegment.serialize());
                toStore.add(segment);
                segId = segment.id();
            }
            StoreKey first = indexSegment.first();
            StoreKey last = indexSegment.last();
            Preconditions.checkState((first != null && last != null ? 1 : 0) != 0);
            indexStripes.add(IndexStripe.indexStripe(first, last, segId));
        }
        return indexStripes;
    }

    private ObjId persistIndex(StoreIndex<CommitOp> indexSegment) throws ObjTooLargeException {
        if (!indexSegment.isModified()) {
            return Objects.requireNonNull(indexSegment.getObjId(), "Loaded index segment does not contain its ObjId");
        }
        IndexObj segment = IndexObj.index(indexSegment.serialize());
        this.persist.storeObj(segment);
        return segment.id();
    }

    @Override
    public void completeIndexesInCommitChain(@javax.annotation.Nonnull @Nonnull ObjId commitId, Runnable progressCallback) throws ObjNotFoundException {
        ArrayDeque<ObjId> idsToProcess = new ArrayDeque<ObjId>();
        idsToProcess.add(commitId);
        while (!idsToProcess.isEmpty()) {
            ObjId id = (ObjId)idsToProcess.pollFirst();
            this.completeIndexesInCommitChain(id, idsToProcess, progressCallback);
        }
    }

    @VisibleForTesting
    void completeIndexesInCommitChain(@javax.annotation.Nonnull @Nonnull ObjId commitId, @javax.annotation.Nonnull @Nonnull Deque<ObjId> idsToProcess, Runnable progressCallback) throws ObjNotFoundException {
        CommitLogic commitLogic = Logics.commitLogic(this.persist);
        CommitObj head = commitLogic.fetchCommit(commitId);
        if (head == null) {
            return;
        }
        commitId = head.id();
        if (!head.incompleteIndex()) {
            return;
        }
        List<ObjId> commitsToUpdate = this.findCommitsWithIncompleteIndex(commitId);
        if (commitsToUpdate.isEmpty()) {
            return;
        }
        Collections.reverse(commitsToUpdate);
        int totalCommits = commitsToUpdate.size();
        ObjId oldestCommitId = commitsToUpdate.get(0);
        IntFunction<ObjId[]> prefetchIds = i -> commitsToUpdate.subList(i, Math.min(totalCommits, i + 100)).toArray(new ObjId[0]);
        this.persist.fetchObjs(prefetchIds.apply(0));
        CommitObj current = this.persist.fetchTypedObj(oldestCommitId, ObjType.COMMIT, CommitObj.class);
        CommitObj parent = ObjId.EMPTY_OBJ_ID.equals(current.directParent()) ? null : this.persist.fetchTypedObj(current.directParent(), ObjType.COMMIT, CommitObj.class);
        int parentsPerCommit = this.persist.config().parentsPerCommit();
        for (int i2 = 0; i2 < totalCommits; ++i2) {
            List<Object> indexStripes;
            ObjId referenceIndex;
            StoreIndex<CommitOp> newIndex;
            if (i2 > 0 && i2 % 100 == 0) {
                this.persist.fetchObjs(prefetchIds.apply(i2));
            }
            ObjId currentId = commitsToUpdate.get(i2);
            if (current == null) {
                try {
                    current = commitLogic.fetchCommit(currentId);
                }
                catch (ObjNotFoundException e) {
                    throw new IllegalStateException(String.format("Commit %s has been seen while walking the commit log, but no longer exists", currentId));
                }
            }
            Preconditions.checkState((current != null ? 1 : 0) != 0, (String)"Commit %s has been seen while walking the commit log, but no longer exists", (Object)currentId);
            progressCallback.run();
            idsToProcess.addAll(current.secondaryParents());
            if (parent != null) {
                newIndex = this.incrementalIndexForUpdate(parent, Optional.empty());
                referenceIndex = parent.referenceIndex();
                indexStripes = parent.referenceIndexStripes();
            } else {
                newIndex = StoreIndexes.newStoreIndex(CommitOp.COMMIT_OP_SERIALIZER);
                referenceIndex = null;
                indexStripes = Collections.emptyList();
            }
            this.commitOperations(current).forEach(newIndex::add);
            CommitObj.Builder c = CommitObj.commitBuilder().from(current).incompleteIndex(false).referenceIndex(referenceIndex).referenceIndexStripes(indexStripes).incrementalIndex(newIndex.serialize());
            if (parent != null) {
                int parents = Math.min(parentsPerCommit - 1, parent.tail().size());
                ArrayList<ObjId> tail = new ArrayList<ObjId>(parents + 1);
                tail.add(parent.id());
                tail.addAll(parent.tail().subList(0, parents));
                c.tail(tail);
            }
            parent = commitLogic.updateCommit(c.build());
            current = null;
        }
    }

    @VisibleForTesting
    List<ObjId> findCommitsWithIncompleteIndex(@javax.annotation.Nonnull @Nonnull ObjId commitId) {
        CommitObj c;
        ArrayList<ObjId> commitsToUpdate = new ArrayList<ObjId>();
        CommitLogic commitLogic = Logics.commitLogic(this.persist);
        PagedResult<CommitObj, ObjId> iter = commitLogic.commitLog(CommitLogQuery.commitLogQuery(commitId));
        while (iter.hasNext() && (c = (CommitObj)iter.next()).incompleteIndex()) {
            commitsToUpdate.add(c.id());
        }
        commitsToUpdate.trimToSize();
        return commitsToUpdate;
    }
}

