/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.logic.ImmutableRepositoryDescription;

@JsonSerialize(as=ImmutableRepositoryDescription.class)
@JsonDeserialize(as=ImmutableRepositoryDescription.class)
@Value.Immutable
@Value.Style(jdkOnly=true)
public interface RepositoryDescription {
    public static Builder builder() {
        return ImmutableRepositoryDescription.builder();
    }

    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant repositoryCreatedTime();

    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    public Instant oldestPossibleCommitTime();

    public Map<String, String> properties();

    public String defaultBranchName();

    @JsonSerialize(using=InstantSerializer.class)
    @JsonDeserialize(using=InstantDeserializer.class)
    @Nullable
    @jakarta.annotation.Nullable
    public Instant repositoryImportedTime();

    public static class InstantDeserializer
    extends StdDeserializer<Instant> {
        public InstantDeserializer() {
            this(null);
        }

        protected InstantDeserializer(Class<?> vc) {
            super(vc);
        }

        public Instant deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
            return Instant.parse(p.getText());
        }
    }

    public static class InstantSerializer
    extends StdSerializer<Instant> {
        private static final DateTimeFormatter FORMATTER = DateTimeFormatter.ISO_INSTANT;

        public InstantSerializer() {
            this(Instant.class);
        }

        protected InstantSerializer(Class<Instant> t) {
            super(t);
        }

        public void serialize(Instant value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(FORMATTER.format(value));
        }
    }

    public static interface Builder {
        public Builder repositoryCreatedTime(Instant var1);

        public Builder oldestPossibleCommitTime(Instant var1);

        public Builder putProperties(String var1, String var2);

        public Builder putAllProperties(Map<String, ? extends String> var1);

        public Builder defaultBranchName(String var1);

        public Builder repositoryImportedTime(Instant var1);

        public RepositoryDescription build();
    }
}

