/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import jakarta.annotation.Nonnull;
import java.util.Set;
import javax.annotation.Nullable;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;

public interface Persist {
    default public int hardObjectSizeLimit() {
        return Integer.MAX_VALUE;
    }

    default public int effectiveIndexSegmentSizeLimit() {
        return Math.min(this.config().maxSerializedIndexSize(), this.hardObjectSizeLimit() / 2);
    }

    default public int effectiveIncrementalIndexSizeLimit() {
        return Math.min(this.config().maxIncrementalIndexSize(), this.hardObjectSizeLimit() / 2);
    }

    @javax.annotation.Nonnull
    @Nonnull
    public String name();

    @javax.annotation.Nonnull
    @Nonnull
    public StoreConfig config();

    @javax.annotation.Nonnull
    @Nonnull
    public Reference addReference(@javax.annotation.Nonnull @Nonnull Reference var1) throws RefAlreadyExistsException;

    @javax.annotation.Nonnull
    @Nonnull
    public Reference markReferenceAsDeleted(@javax.annotation.Nonnull @Nonnull Reference var1) throws RefNotFoundException, RefConditionFailedException;

    public void purgeReference(@javax.annotation.Nonnull @Nonnull Reference var1) throws RefNotFoundException, RefConditionFailedException;

    @javax.annotation.Nonnull
    @Nonnull
    public Reference updateReferencePointer(@javax.annotation.Nonnull @Nonnull Reference var1, @javax.annotation.Nonnull @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException;

    @Nullable
    @jakarta.annotation.Nullable
    public Reference fetchReference(@javax.annotation.Nonnull @Nonnull String var1);

    @javax.annotation.Nonnull
    @Nonnull
    public Reference[] fetchReferences(@javax.annotation.Nonnull @Nonnull String[] var1);

    @javax.annotation.Nonnull
    @Nonnull
    public Obj fetchObj(@javax.annotation.Nonnull @Nonnull ObjId var1) throws ObjNotFoundException;

    @javax.annotation.Nonnull
    @Nonnull
    public <T extends Obj> T fetchTypedObj(@javax.annotation.Nonnull @Nonnull ObjId var1, ObjType var2, Class<T> var3) throws ObjNotFoundException;

    @javax.annotation.Nonnull
    @Nonnull
    public ObjType fetchObjType(@javax.annotation.Nonnull @Nonnull ObjId var1) throws ObjNotFoundException;

    @javax.annotation.Nonnull
    @Nonnull
    public Obj[] fetchObjs(@javax.annotation.Nonnull @Nonnull ObjId[] var1) throws ObjNotFoundException;

    default public boolean storeObj(@javax.annotation.Nonnull @Nonnull Obj obj) throws ObjTooLargeException {
        return this.storeObj(obj, false);
    }

    public boolean storeObj(@javax.annotation.Nonnull @Nonnull Obj var1, boolean var2) throws ObjTooLargeException;

    @javax.annotation.Nonnull
    @Nonnull
    public boolean[] storeObjs(@javax.annotation.Nonnull @Nonnull Obj[] var1) throws ObjTooLargeException;

    public void deleteObj(@javax.annotation.Nonnull @Nonnull ObjId var1);

    public void deleteObjs(@javax.annotation.Nonnull @Nonnull ObjId[] var1);

    public void upsertObj(@javax.annotation.Nonnull @Nonnull Obj var1) throws ObjTooLargeException;

    public void upsertObjs(@javax.annotation.Nonnull @Nonnull Obj[] var1) throws ObjTooLargeException;

    @javax.annotation.Nonnull
    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@javax.annotation.Nonnull @Nonnull Set<ObjType> var1);

    public void erase();
}

