/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableCommitObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface CommitObj
extends Obj {
    @Override
    default public ObjType type() {
        return ObjType.COMMIT;
    }

    public static Builder commitBuilder() {
        return ImmutableCommitObj.builder();
    }

    public long created();

    public long seq();

    public List<ObjId> tail();

    default public ObjId directParent() {
        List<ObjId> t = this.tail();
        return t.isEmpty() ? ObjId.EMPTY_OBJ_ID : t.get(0);
    }

    public List<ObjId> secondaryParents();

    public CommitHeaders headers();

    public String message();

    @Value.Default
    default public boolean incompleteIndex() {
        return false;
    }

    @Nullable
    @jakarta.annotation.Nullable
    public ObjId referenceIndex();

    public List<IndexStripe> referenceIndexStripes();

    default public boolean hasReferenceIndex() {
        return this.referenceIndex() != null || !this.referenceIndexStripes().isEmpty();
    }

    public ByteString incrementalIndex();

    @Value.Default
    default public CommitType commitType() {
        return CommitType.NORMAL;
    }

    public static interface Builder {
        @CanIgnoreReturnValue
        public Builder from(CommitObj var1);

        @CanIgnoreReturnValue
        public Builder id(@Nullable @jakarta.annotation.Nullable ObjId var1);

        @CanIgnoreReturnValue
        public Builder created(long var1);

        @CanIgnoreReturnValue
        public Builder seq(long var1);

        @CanIgnoreReturnValue
        public Builder addTail(ObjId var1);

        @CanIgnoreReturnValue
        public Builder tail(Iterable<? extends ObjId> var1);

        @CanIgnoreReturnValue
        public Builder addSecondaryParents(ObjId var1);

        @CanIgnoreReturnValue
        public Builder addAllSecondaryParents(Iterable<? extends ObjId> var1);

        @CanIgnoreReturnValue
        public Builder headers(CommitHeaders var1);

        @CanIgnoreReturnValue
        public Builder message(String var1);

        @CanIgnoreReturnValue
        public Builder referenceIndex(@Nullable @jakarta.annotation.Nullable ObjId var1);

        @CanIgnoreReturnValue
        public Builder addAllReferenceIndexStripes(Iterable<? extends IndexStripe> var1);

        @CanIgnoreReturnValue
        public Builder referenceIndexStripes(Iterable<? extends IndexStripe> var1);

        @CanIgnoreReturnValue
        public Builder addReferenceIndexStripes(IndexStripe var1);

        @CanIgnoreReturnValue
        public Builder incrementalIndex(ByteString var1);

        public Builder incompleteIndex(boolean var1);

        public Builder commitType(CommitType var1);

        public CommitObj build();
    }
}

