/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.google.common.base.Preconditions;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableContentValueObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface ContentValueObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.VALUE;
    }

    @Override
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=2)
    public String contentId();

    @Value.Parameter(order=3)
    public int payload();

    @Value.Parameter(order=4)
    public ByteString data();

    public static ContentValueObj contentValue(ObjId id, String contentId, int payload, ByteString data) {
        Preconditions.checkArgument((payload >= 0 && payload <= 127 ? 1 : 0) != 0);
        return ImmutableContentValueObj.of(id, contentId, payload, data);
    }

    public static ContentValueObj contentValue(String contentId, int payload, ByteString data) {
        return ContentValueObj.contentValue(Hashes.contentValueHash(contentId, payload, data), contentId, payload, data);
    }
}

