/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableIndexObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface IndexObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.INDEX;
    }

    @Override
    @Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=1)
    public ByteString index();

    @Nonnull
    public static IndexObj index(@Nullable ObjId id, @Nonnull ByteString index) {
        return ImmutableIndexObj.of(id, index);
    }

    @Nonnull
    public static IndexObj index(@Nonnull ByteString index) {
        return IndexObj.index(Hashes.indexHash(index), index);
    }
}

