/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableJsonBean;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableJsonObj;
import org.projectnessie.versioned.storage.common.objtypes.SimpleObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@JsonSerialize(as=ImmutableJsonObj.class)
@JsonDeserialize(as=ImmutableJsonObj.class)
@Value.Immutable
public interface JsonObj
extends Obj {
    public static final ObjType TYPE = new SimpleObjType<JsonObj>("json", "j", JsonObj.class);

    @Override
    @JsonIgnore
    default public ObjType type() {
        return TYPE;
    }

    @JsonUnwrapped
    public JsonBean bean();

    @JsonIgnore
    @Nullable
    @Value.Derived
    default public <T> T bean(Class<T> expectedType) {
        return expectedType.cast(this.bean().object());
    }

    public static JsonObj json(ObjId id, @Nonnull Object bean) {
        return JsonObj.json(id, bean.getClass(), bean);
    }

    public static JsonObj json(ObjId id, Class<?> type, @Nullable Object bean) {
        return JsonObj.json(id, type.getName(), bean);
    }

    public static JsonObj json(ObjId id, String type, @Nullable Object bean) {
        return ImmutableJsonObj.builder().id(id).bean(ImmutableJsonBean.builder().object(bean).type(type).build()).build();
    }

    @JsonSerialize(as=ImmutableJsonBean.class)
    @JsonDeserialize(as=ImmutableJsonBean.class)
    @Value.Immutable
    public static interface JsonBean {
        @JsonProperty(value="t")
        public String type();

        @JsonProperty(value="o")
        @JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, include=JsonTypeInfo.As.EXTERNAL_PROPERTY, property="t")
        @Nullable
        public Object object();
    }
}

