/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import jakarta.annotation.Nullable;
import java.nio.ByteBuffer;
import java.util.UUID;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.objtypes.Hashes;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableUniqueIdObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface UniqueIdObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.UNIQUE;
    }

    @Override
    @Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Value.Parameter(order=2)
    public String space();

    @Value.Parameter(order=3)
    public ByteString value();

    @Value.NonAttribute
    default public UUID valueAsUUID() {
        ByteBuffer buffer = this.value().asReadOnlyByteBuffer();
        long msb = buffer.getLong();
        long lsb = buffer.getLong();
        return new UUID(msb, lsb);
    }

    public static UniqueIdObj uniqueId(ObjId id, String space, ByteString value) {
        return ImmutableUniqueIdObj.of(id, space, value);
    }

    public static UniqueIdObj uniqueId(String space, ByteString value) {
        return UniqueIdObj.uniqueId(Hashes.uniqueIdHash(space, value), space, value);
    }

    public static UniqueIdObj uniqueId(String space, UUID value) {
        return UniqueIdObj.uniqueId(space, UniqueIdObj.uuidToBytes(value));
    }

    public static ByteString uuidToBytes(UUID value) {
        ByteBuffer buffer = ByteBuffer.allocate(16);
        buffer.putLong(value.getMostSignificantBits());
        buffer.putLong(value.getLeastSignificantBits());
        buffer.flip();
        return UnsafeByteOperations.unsafeWrap((ByteBuffer)buffer);
    }
}

