/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.function.Consumer;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterOutputStream;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.xerial.snappy.SnappyInputStream;
import org.xerial.snappy.SnappyOutputStream;

public final class Compressions {
    public static final int KEEP_UNCOMPRESSED = 8192;

    private Compressions() {
    }

    public static byte[] compressDefault(byte[] bytes, Consumer<Compression> compression) {
        if (bytes.length <= 8192) {
            compression.accept(Compression.NONE);
            return bytes;
        }
        Compression compr = Compression.SNAPPY;
        compression.accept(compr);
        return Compressions.compress(compr, bytes);
    }

    public static byte[] compress(Compression compression, byte[] uncompressed) {
        switch (compression) {
            case NONE: {
                return uncompressed;
            }
            case DEFLATE: {
                return Compressions.deflate(uncompressed);
            }
            case SNAPPY: {
                return Compressions.snappyCompress(uncompressed);
            }
        }
        throw new IllegalArgumentException("Compression " + compression + " not implemented");
    }

    public static byte[] uncompress(Compression compression, byte[] compressed) {
        switch (compression) {
            case NONE: {
                return compressed;
            }
            case DEFLATE: {
                return Compressions.inflate(compressed);
            }
            case SNAPPY: {
                return Compressions.snappyUncompress(compressed);
            }
        }
        throw new IllegalArgumentException("Compression " + compression + " not implemented");
    }

    private static byte[] deflate(byte[] uncompressed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(uncompressed.length);
        try (DeflaterOutputStream def = new DeflaterOutputStream((OutputStream)out, new Deflater(1));){
            ((OutputStream)def).write(uncompressed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private static byte[] inflate(byte[] compressed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(compressed.length * 2);
        try (InflaterOutputStream def = new InflaterOutputStream(out);){
            ((OutputStream)def).write(compressed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private static byte[] snappyCompress(byte[] uncompressed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(uncompressed.length);
        try (SnappyOutputStream def = new SnappyOutputStream((OutputStream)out);){
            def.write(uncompressed);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    private static byte[] snappyUncompress(byte[] compressed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(compressed.length * 2);
        try (SnappyInputStream input = new SnappyInputStream((InputStream)new ByteArrayInputStream(compressed));){
            input.transferTo(out);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }
}

