/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.List;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.RetryTimeoutException;
import org.projectnessie.versioned.storage.common.logic.PagedResult;
import org.projectnessie.versioned.storage.common.logic.ReferencesQuery;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;

public interface ReferenceLogic {
    @Nonnull
    public List<Reference> getReferences(@Nonnull List<String> var1);

    @Nonnull
    default public Reference getReference(@Nonnull String name) throws RefNotFoundException {
        List<Reference> refs = this.getReferences(Collections.singletonList(name));
        Reference ref = refs.get(0);
        if (ref == null) {
            throw new RefNotFoundException(name);
        }
        return ref;
    }

    @Nonnull
    public PagedResult<Reference, String> queryReferences(@Nonnull ReferencesQuery var1);

    @Nonnull
    public Reference createReference(@Nonnull String var1, @Nonnull ObjId var2, @Nullable ObjId var3) throws RefAlreadyExistsException, RetryTimeoutException;

    public void deleteReference(@Nonnull String var1, @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException, RetryTimeoutException;

    @Nonnull
    public Reference assignReference(@Nonnull Reference var1, @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException;
}

