/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.UpdateableObj;

public interface Persist {
    default public int hardObjectSizeLimit() {
        return Integer.MAX_VALUE;
    }

    default public int effectiveIndexSegmentSizeLimit() {
        return Math.min(this.config().maxSerializedIndexSize(), this.hardObjectSizeLimit() / 2);
    }

    default public int effectiveIncrementalIndexSizeLimit() {
        return Math.min(this.config().maxIncrementalIndexSize(), this.hardObjectSizeLimit() / 2);
    }

    @Nonnull
    public String name();

    @Nonnull
    public StoreConfig config();

    @Nonnull
    public Reference addReference(@Nonnull Reference var1) throws RefAlreadyExistsException;

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference var1) throws RefNotFoundException, RefConditionFailedException;

    public void purgeReference(@Nonnull Reference var1) throws RefNotFoundException, RefConditionFailedException;

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference var1, @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException;

    @Nullable
    public Reference fetchReference(@Nonnull String var1);

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] var1);

    @Nonnull
    public Obj fetchObj(@Nonnull ObjId var1) throws ObjNotFoundException;

    default public Obj getImmediate(@Nonnull ObjId id) {
        return null;
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId var1, ObjType var2, Class<T> var3) throws ObjNotFoundException;

    @Nonnull
    public ObjType fetchObjType(@Nonnull ObjId var1) throws ObjNotFoundException;

    @Nonnull
    public Obj[] fetchObjs(@Nonnull ObjId[] var1) throws ObjNotFoundException;

    default public boolean storeObj(@Nonnull Obj obj) throws ObjTooLargeException {
        return this.storeObj(obj, false);
    }

    public boolean storeObj(@Nonnull Obj var1, boolean var2) throws ObjTooLargeException;

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] var1) throws ObjTooLargeException;

    public void deleteObj(@Nonnull ObjId var1);

    public void deleteObjs(@Nonnull ObjId[] var1);

    public boolean deleteConditional(@Nonnull UpdateableObj var1);

    public boolean updateConditional(@Nonnull UpdateableObj var1, @Nonnull UpdateableObj var2) throws ObjTooLargeException;

    public void upsertObj(@Nonnull Obj var1) throws ObjTooLargeException;

    public void upsertObjs(@Nonnull Obj[] var1) throws ObjTooLargeException;

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> var1);

    public void erase();
}

