/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.UnsafeByteOperations;
import org.projectnessie.versioned.storage.common.logic.ImmutablePagingToken;
import org.projectnessie.versioned.storage.common.util.Hex;

@Value.Immutable
public interface PagingToken {
    @Value.Parameter(order=1)
    public ByteString token();

    @Value.NonAttribute
    default public boolean isEmpty() {
        return this.token().isEmpty();
    }

    @Nonnull
    default public String asString() {
        ByteString t = this.token();
        int size = t.size();
        StringBuilder sb = new StringBuilder(size * 2);
        for (int i = 0; i < size; ++i) {
            byte b = t.byteAt(i);
            sb.append(Hex.hexChar((byte)(b >> 4)));
            sb.append(Hex.hexChar(b));
        }
        return sb.toString();
    }

    @Nonnull
    public static PagingToken fromString(@Nonnull String tokenAsString) {
        int len = tokenAsString.length();
        if ((len & 1) == 1) {
            throw new IllegalArgumentException("Invalid token string representation");
        }
        int bytes = len >> 1;
        byte[] arr = new byte[bytes];
        int c = 0;
        for (int i = 0; i < bytes; ++i) {
            arr[i] = (byte)(Hex.nibble(tokenAsString.charAt(c++)) << 4 | Hex.nibble(tokenAsString.charAt(c++)));
        }
        return PagingToken.pagingToken(UnsafeByteOperations.unsafeWrap((byte[])arr));
    }

    @Nonnull
    public static PagingToken pagingToken(@Nonnull ByteString token) {
        return ImmutablePagingToken.of(token);
    }

    public static PagingToken emptyPagingToken() {
        return PagingToken.pagingToken(ByteString.EMPTY);
    }
}

