/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Set;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.UpdateableObj;

public class ObservingPersist
implements Persist {
    private final Persist delegate;
    private static final String PREFIX = "nessie.storage.persist";

    public ObservingPersist(Persist delegate) {
        this.delegate = delegate;
    }

    @Override
    public int hardObjectSizeLimit() {
        return this.delegate.hardObjectSizeLimit();
    }

    @Override
    public int effectiveIndexSegmentSizeLimit() {
        return this.delegate.effectiveIndexSegmentSizeLimit();
    }

    @Override
    public int effectiveIncrementalIndexSizeLimit() {
        return this.delegate.effectiveIncrementalIndexSizeLimit();
    }

    @Override
    @Nonnull
    public String name() {
        return this.delegate.name();
    }

    @Override
    @Nonnull
    public StoreConfig config() {
        return this.delegate.config();
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        return this.delegate.addReference(reference);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        return this.delegate.markReferenceAsDeleted(reference);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        this.delegate.purgeReference(reference);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        return this.delegate.updateReferencePointer(reference, newPointer);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nullable
    public Reference fetchReference(@Nonnull String name) {
        return this.delegate.fetchReference(name);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        return this.delegate.fetchReferences(names);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nullable
    public Reference fetchReferenceForUpdate(@Nonnull String name) {
        return this.delegate.fetchReferenceForUpdate(name);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Reference[] fetchReferencesForUpdate(@Nonnull String[] names) {
        return this.delegate.fetchReferencesForUpdate(names);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Obj fetchObj(@Nonnull ObjId id) throws ObjNotFoundException {
        return this.delegate.fetchObj(id);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public Obj getImmediate(@Nonnull ObjId id) {
        return this.delegate.getImmediate(id);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        return this.delegate.fetchTypedObj(id, type, typeClass);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public ObjType fetchObjType(@Nonnull ObjId id) throws ObjNotFoundException {
        return this.delegate.fetchObjType(id);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Obj[] fetchObjs(@Nonnull ObjId[] ids) throws ObjNotFoundException {
        return this.delegate.fetchObjs(ids);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public Obj[] fetchObjsIfExist(@Nonnull ObjId[] ids) {
        return this.delegate.fetchObjsIfExist(ids);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public <T extends Obj> T[] fetchTypedObjs(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        return this.delegate.fetchTypedObjs(ids, type, typeClass);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) {
        return this.delegate.fetchTypedObjsIfExist(ids, type, typeClass);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public boolean storeObj(@Nonnull Obj obj) throws ObjTooLargeException {
        return this.delegate.storeObj(obj);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        return this.delegate.storeObj(obj, ignoreSoftSizeRestrictions);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        return this.delegate.storeObjs(objs);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public void deleteObj(@Nonnull ObjId id) {
        this.delegate.deleteObj(id);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public void deleteObjs(@Nonnull ObjId[] ids) {
        this.delegate.deleteObjs(ids);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        this.delegate.upsertObj(obj);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        this.delegate.upsertObjs(objs);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        return this.delegate.deleteConditional(obj);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) throws ObjTooLargeException {
        return this.delegate.updateConditional(expected, newValue);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return this.delegate.scanAllObjects(returnedObjTypes);
    }

    @Override
    @WithSpan
    @Counted(value="nessie.storage.persist")
    @Timed(value="nessie.storage.persist", histogram=true)
    public void erase() {
        this.delegate.erase();
    }
}

