/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateCommit", generator="Immutables")
@Immutable
public final class ImmutableCreateCommit
implements CreateCommit {
    private final ObjId parentCommitId;
    private final ImmutableList<ObjId> secondaryParents;
    private final CommitHeaders headers;
    private final String message;
    private final ImmutableList<CreateCommit.Add> adds;
    private final ImmutableList<CreateCommit.Unchanged> unchanged;
    private final ImmutableList<CreateCommit.Remove> removes;
    private final CommitType commitType;

    private ImmutableCreateCommit(Builder builder) {
        this.parentCommitId = builder.parentCommitId;
        this.secondaryParents = builder.secondaryParents.build();
        this.headers = builder.headers;
        this.message = builder.message;
        this.adds = builder.adds.build();
        this.unchanged = builder.unchanged.build();
        this.removes = builder.removes.build();
        this.commitType = builder.commitType != null ? builder.commitType : Objects.requireNonNull(CreateCommit.super.commitType(), "commitType");
    }

    private ImmutableCreateCommit(ObjId parentCommitId, ImmutableList<ObjId> secondaryParents, CommitHeaders headers, String message, ImmutableList<CreateCommit.Add> adds, ImmutableList<CreateCommit.Unchanged> unchanged, ImmutableList<CreateCommit.Remove> removes, CommitType commitType) {
        this.parentCommitId = parentCommitId;
        this.secondaryParents = secondaryParents;
        this.headers = headers;
        this.message = message;
        this.adds = adds;
        this.unchanged = unchanged;
        this.removes = removes;
        this.commitType = commitType;
    }

    @Override
    public ObjId parentCommitId() {
        return this.parentCommitId;
    }

    public ImmutableList<ObjId> secondaryParents() {
        return this.secondaryParents;
    }

    @Override
    public CommitHeaders headers() {
        return this.headers;
    }

    @Override
    public String message() {
        return this.message;
    }

    public ImmutableList<CreateCommit.Add> adds() {
        return this.adds;
    }

    public ImmutableList<CreateCommit.Unchanged> unchanged() {
        return this.unchanged;
    }

    public ImmutableList<CreateCommit.Remove> removes() {
        return this.removes;
    }

    @Override
    public CommitType commitType() {
        return this.commitType;
    }

    public final ImmutableCreateCommit withParentCommitId(ObjId value) {
        if (this.parentCommitId == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "parentCommitId");
        return new ImmutableCreateCommit(newValue, this.secondaryParents, this.headers, this.message, this.adds, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withSecondaryParents(ObjId ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateCommit(this.parentCommitId, (ImmutableList<ObjId>)newValue, this.headers, this.message, this.adds, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withSecondaryParents(Iterable<? extends ObjId> elements) {
        if (this.secondaryParents == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateCommit(this.parentCommitId, (ImmutableList<ObjId>)newValue, this.headers, this.message, this.adds, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withHeaders(CommitHeaders value) {
        if (this.headers == value) {
            return this;
        }
        CommitHeaders newValue = Objects.requireNonNull(value, "headers");
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, newValue, this.message, this.adds, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, newValue, this.adds, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withAdds(CreateCommit.Add ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, (ImmutableList<CreateCommit.Add>)newValue, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withAdds(Iterable<? extends CreateCommit.Add> elements) {
        if (this.adds == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, (ImmutableList<CreateCommit.Add>)newValue, this.unchanged, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withUnchanged(CreateCommit.Unchanged ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, this.adds, (ImmutableList<CreateCommit.Unchanged>)newValue, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withUnchanged(Iterable<? extends CreateCommit.Unchanged> elements) {
        if (this.unchanged == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, this.adds, (ImmutableList<CreateCommit.Unchanged>)newValue, this.removes, this.commitType);
    }

    public final ImmutableCreateCommit withRemoves(CreateCommit.Remove ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, this.adds, this.unchanged, (ImmutableList<CreateCommit.Remove>)newValue, this.commitType);
    }

    public final ImmutableCreateCommit withRemoves(Iterable<? extends CreateCommit.Remove> elements) {
        if (this.removes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, this.adds, this.unchanged, (ImmutableList<CreateCommit.Remove>)newValue, this.commitType);
    }

    public final ImmutableCreateCommit withCommitType(CommitType value) {
        CommitType newValue = Objects.requireNonNull(value, "commitType");
        if (this.commitType == newValue) {
            return this;
        }
        return new ImmutableCreateCommit(this.parentCommitId, this.secondaryParents, this.headers, this.message, this.adds, this.unchanged, this.removes, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCreateCommit && this.equalTo(0, (ImmutableCreateCommit)another);
    }

    private boolean equalTo(int synthetic, ImmutableCreateCommit another) {
        return this.parentCommitId.equals(another.parentCommitId) && this.secondaryParents.equals(another.secondaryParents) && this.headers.equals(another.headers) && this.message.equals(another.message) && this.adds.equals(another.adds) && this.unchanged.equals(another.unchanged) && this.removes.equals(another.removes) && this.commitType.equals((Object)another.commitType);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.parentCommitId.hashCode();
        h += (h << 5) + this.secondaryParents.hashCode();
        h += (h << 5) + this.headers.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + this.adds.hashCode();
        h += (h << 5) + this.unchanged.hashCode();
        h += (h << 5) + this.removes.hashCode();
        h += (h << 5) + this.commitType.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CreateCommit").omitNullValues().add("parentCommitId", (Object)this.parentCommitId).add("secondaryParents", this.secondaryParents).add("headers", (Object)this.headers).add("message", (Object)this.message).add("adds", this.adds).add("unchanged", this.unchanged).add("removes", this.removes).add("commitType", (Object)this.commitType).toString();
    }

    public static ImmutableCreateCommit copyOf(CreateCommit instance) {
        if (instance instanceof ImmutableCreateCommit) {
            return (ImmutableCreateCommit)instance;
        }
        return ImmutableCreateCommit.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateCommit", generator="Immutables")
    @NotThreadSafe
    public static final class Builder
    implements CreateCommit.Builder {
        private static final long INIT_BIT_PARENT_COMMIT_ID = 1L;
        private static final long INIT_BIT_HEADERS = 2L;
        private static final long INIT_BIT_MESSAGE = 4L;
        private long initBits = 7L;
        @Nullable
        private ObjId parentCommitId;
        private ImmutableList.Builder<ObjId> secondaryParents = ImmutableList.builder();
        @Nullable
        private CommitHeaders headers;
        @Nullable
        private String message;
        private ImmutableList.Builder<CreateCommit.Add> adds = ImmutableList.builder();
        private ImmutableList.Builder<CreateCommit.Unchanged> unchanged = ImmutableList.builder();
        private ImmutableList.Builder<CreateCommit.Remove> removes = ImmutableList.builder();
        @Nullable
        private CommitType commitType;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateCommit instance) {
            Objects.requireNonNull(instance, "instance");
            this.parentCommitId(instance.parentCommitId());
            this.addAllSecondaryParents(instance.secondaryParents());
            this.headers(instance.headers());
            this.message(instance.message());
            this.addAllAdds(instance.adds());
            this.addAllUnchanged(instance.unchanged());
            this.addAllRemoves(instance.removes());
            this.commitType(instance.commitType());
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder parentCommitId(ObjId parentCommitId) {
            this.parentCommitId = Objects.requireNonNull(parentCommitId, "parentCommitId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addSecondaryParents(ObjId element) {
            this.secondaryParents.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSecondaryParents(ObjId ... elements) {
            this.secondaryParents.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secondaryParents(Iterable<? extends ObjId> elements) {
            this.secondaryParents = ImmutableList.builder();
            return this.addAllSecondaryParents(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSecondaryParents(Iterable<? extends ObjId> elements) {
            this.secondaryParents.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder headers(CommitHeaders headers) {
            this.headers = Objects.requireNonNull(headers, "headers");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addAdds(CreateCommit.Add element) {
            this.adds.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addAdds(CreateCommit.Add ... elements) {
            this.adds.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder adds(Iterable<? extends CreateCommit.Add> elements) {
            this.adds = ImmutableList.builder();
            return this.addAllAdds(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllAdds(Iterable<? extends CreateCommit.Add> elements) {
            this.adds.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addUnchanged(CreateCommit.Unchanged element) {
            this.unchanged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUnchanged(CreateCommit.Unchanged ... elements) {
            this.unchanged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder unchanged(Iterable<? extends CreateCommit.Unchanged> elements) {
            this.unchanged = ImmutableList.builder();
            return this.addAllUnchanged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUnchanged(Iterable<? extends CreateCommit.Unchanged> elements) {
            this.unchanged.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder addRemoves(CreateCommit.Remove element) {
            this.removes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addRemoves(CreateCommit.Remove ... elements) {
            this.removes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder removes(Iterable<? extends CreateCommit.Remove> elements) {
            this.removes = ImmutableList.builder();
            return this.addAllRemoves(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllRemoves(Iterable<? extends CreateCommit.Remove> elements) {
            this.removes.addAll(elements);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public final Builder commitType(CommitType commitType) {
            this.commitType = Objects.requireNonNull(commitType, "commitType");
            return this;
        }

        @Override
        public ImmutableCreateCommit build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCreateCommit(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("parentCommitId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("headers");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("message");
            }
            return "Cannot build CreateCommit, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

