/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import jakarta.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableTagObj;
import org.projectnessie.versioned.storage.common.objtypes.StandardObjType;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjIdHasher;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
public interface TagObj
extends Obj {
    @Override
    default public ObjType type() {
        return StandardObjType.TAG;
    }

    @Override
    @Nullable
    @Value.Parameter(order=1)
    public ObjId id();

    @Nullable
    @Value.Parameter(order=2)
    public String message();

    @Nullable
    @Value.Parameter(order=3)
    public CommitHeaders headers();

    @Nullable
    @Value.Parameter(order=4)
    public ByteString signature();

    public static TagObj tag(ObjId id, String message, CommitHeaders headers, ByteString signature) {
        return ImmutableTagObj.of(id, message, headers, signature);
    }

    public static TagObj tag(String message, CommitHeaders headers, ByteString signature) {
        ObjIdHasher hasher = ObjIdHasher.objIdHasher(StandardObjType.TAG);
        if (message != null) {
            hasher.hash(message);
        }
        if (headers != null) {
            hasher.hash(headers);
        }
        if (signature != null) {
            hasher.hash(signature.asReadOnlyByteBuffer());
        }
        return TagObj.tag(hasher.generate(), message, headers, signature);
    }
}

