/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Optional;
import org.projectnessie.versioned.storage.common.objtypes.GenericObj;
import org.projectnessie.versioned.storage.common.persist.Obj;

public interface UpdateableObj
extends Obj {
    public static Optional<String> extractVersionToken(Obj obj) {
        String versionToken = null;
        if (obj instanceof UpdateableObj) {
            versionToken = ((UpdateableObj)obj).versionToken();
        } else if (obj instanceof GenericObj) {
            GenericObj genericObj = (GenericObj)obj;
            versionToken = (String)genericObj.attributes().get("versionToken");
        }
        return Optional.ofNullable(versionToken);
    }

    @JsonIgnore
    @JacksonInject(value="nessie.storage.ObjVersion")
    public String versionToken();
}

