/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.stream.Stream;
import org.agrona.collections.Object2ObjectHashMap;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.logic.ImmutableMergeBase;
import org.projectnessie.versioned.storage.common.logic.ShallowCommit;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@Value.Immutable
public abstract class MergeBase {
    private final Object2ObjectHashMap<ObjId, ShallowCommit> commits = new Object2ObjectHashMap();

    public abstract Function<ObjId, CommitObj> loadCommit();

    public abstract ObjId targetCommitId();

    public abstract ObjId fromCommitId();

    @Value.Default
    public boolean respectMergeParents() {
        return true;
    }

    public static ImmutableMergeBase.Builder builder() {
        return ImmutableMergeBase.builder();
    }

    @Value.NonAttribute
    public ObjId identifyMergeBase() {
        List<ShallowCommit> mergeBases = this.identifyAllMergeBases();
        if (mergeBases == null || mergeBases.isEmpty()) {
            throw this.noCommonAncestor();
        }
        return mergeBases.get(0).id();
    }

    private List<ShallowCommit> identifyAllMergeBases() {
        ShallowCommit targetCommit = this.shallowCommit(this.targetCommitId());
        if (targetCommit == null) {
            this.shallowCommit(this.fromCommitId());
            return null;
        }
        ShallowCommit fromCommit = this.shallowCommit(this.fromCommitId());
        if (fromCommit == null) {
            return Collections.singletonList(targetCommit);
        }
        return this.findMergeBases(fromCommit, targetCommit);
    }

    private List<ShallowCommit> findMergeBases(ShallowCommit commitA, ShallowCommit commitB) {
        if (commitB.id().equals(commitA.id())) {
            return Lists.newArrayList((Object[])new ShallowCommit[]{commitA});
        }
        return this.flagReachableCommits(commitA, commitB);
    }

    private List<ShallowCommit> flagReachableCommits(ShallowCommit commitA, ShallowCommit commitB) {
        PriorityQueue<ShallowCommit> queue = new PriorityQueue<ShallowCommit>(Comparator.comparing(ShallowCommit::seq).reversed());
        ArrayList<ShallowCommit> result = new ArrayList<ShallowCommit>();
        commitA.setCommitA();
        queue.add(commitA);
        commitB.setCommitB();
        queue.add(commitB);
        while (queue.stream().anyMatch(ShallowCommit::isNotCandidate)) {
            ShallowCommit commit = Objects.requireNonNull(queue.poll());
            int reachabilityFlags = commit.reachabilityFlags();
            if (reachabilityFlags == 3) {
                if (commit.setResult()) {
                    result.add(commit);
                }
                reachabilityFlags |= 4;
            }
            int reachabilityFlagsFinal = reachabilityFlags;
            this.parentCommits(commit).filter(parent -> parent.setAllFlagsIfAnyMissing(reachabilityFlagsFinal)).forEach(queue::add);
        }
        return result;
    }

    private NoSuchElementException noCommonAncestor() {
        return new NoSuchElementException("No common ancestor in parents of " + String.valueOf(this.targetCommitId()) + " and " + String.valueOf(this.fromCommitId()));
    }

    private Stream<ShallowCommit> parentCommits(ShallowCommit commit) {
        return Arrays.stream(commit.parents()).map(this::shallowCommit).filter(Objects::nonNull);
    }

    private ShallowCommit shallowCommit(ObjId objId) {
        if (ObjId.EMPTY_OBJ_ID.equals(objId)) {
            return null;
        }
        return (ShallowCommit)this.commits.computeIfAbsent((Object)objId, id -> {
            ObjId[] parents;
            CommitObj commit = this.loadCommit().apply((ObjId)id);
            if (commit == null) {
                throw new NoSuchElementException("Commit '" + String.valueOf(id) + "' not found");
            }
            if (this.respectMergeParents()) {
                List<ObjId> secondary = commit.secondaryParents();
                parents = new ObjId[1 + secondary.size()];
                int end = parents.length - 1;
                for (int i = 0; i < end; ++i) {
                    parents[i] = secondary.get(i);
                }
                parents[end] = commit.directParent();
            } else {
                parents = new ObjId[]{commit.directParent()};
            }
            return new ShallowCommit(commit.id(), parents, commit.seq());
        });
    }
}

