/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Set;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Reference;

public interface Persist {
    default public int hardObjectSizeLimit() {
        return Integer.MAX_VALUE;
    }

    default public int effectiveIndexSegmentSizeLimit() {
        return Math.min(this.config().maxSerializedIndexSize(), this.hardObjectSizeLimit() / 2);
    }

    default public int effectiveIncrementalIndexSizeLimit() {
        return Math.min(this.config().maxIncrementalIndexSize(), this.hardObjectSizeLimit() / 2);
    }

    @Nonnull
    public String name();

    @Nonnull
    public StoreConfig config();

    @Nonnull
    public Reference addReference(@Nonnull Reference var1) throws RefAlreadyExistsException;

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference var1) throws RefNotFoundException, RefConditionFailedException;

    public void purgeReference(@Nonnull Reference var1) throws RefNotFoundException, RefConditionFailedException;

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference var1, @Nonnull ObjId var2) throws RefNotFoundException, RefConditionFailedException;

    @Nullable
    public Reference fetchReference(@Nonnull String var1);

    @Nullable
    default public Reference fetchReferenceForUpdate(@Nonnull String name) {
        return this.fetchReference(name);
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] var1);

    @Nonnull
    default public Reference[] fetchReferencesForUpdate(@Nonnull String[] names) {
        return this.fetchReferences(names);
    }

    @Nonnull
    default public Obj fetchObj(@Nonnull ObjId id) throws ObjNotFoundException {
        return this.fetchTypedObj(id, null, Obj.class);
    }

    default public Obj getImmediate(@Nonnull ObjId id) {
        return null;
    }

    @Nonnull
    default public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        return (T)this.fetchTypedObjs(new ObjId[]{id}, type, typeClass)[0];
    }

    @Nonnull
    default public ObjType fetchObjType(@Nonnull ObjId id) throws ObjNotFoundException {
        return this.fetchObj(id).type();
    }

    @Nonnull
    default public Obj[] fetchObjs(@Nonnull ObjId[] ids) throws ObjNotFoundException {
        return this.fetchTypedObjs(ids, null, Obj.class);
    }

    @Nonnull
    default public <T extends Obj> T[] fetchTypedObjs(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        Obj[] r = this.fetchTypedObjsIfExist(ids, type, typeClass);
        ArrayList<ObjId> notFound = null;
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (r[i] != null || id == null) continue;
            if (notFound == null) {
                notFound = new ArrayList<ObjId>();
            }
            notFound.add(id);
        }
        if (notFound != null) {
            throw new ObjNotFoundException(notFound);
        }
        return r;
    }

    default public Obj[] fetchObjsIfExist(@Nonnull ObjId[] ids) {
        return this.fetchTypedObjsIfExist(ids, null, Obj.class);
    }

    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] var1, ObjType var2, @Nonnull Class<T> var3);

    default public boolean storeObj(@Nonnull Obj obj) throws ObjTooLargeException {
        return this.storeObj(obj, false);
    }

    public boolean storeObj(@Nonnull Obj var1, boolean var2) throws ObjTooLargeException;

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] var1) throws ObjTooLargeException;

    public void deleteObj(@Nonnull ObjId var1);

    public void deleteObjs(@Nonnull ObjId[] var1);

    public boolean deleteConditional(@Nonnull UpdateableObj var1);

    public boolean updateConditional(@Nonnull UpdateableObj var1, @Nonnull UpdateableObj var2) throws ObjTooLargeException;

    public void upsertObj(@Nonnull Obj var1) throws ObjTooLargeException;

    public void upsertObjs(@Nonnull Obj[] var1) throws ObjTooLargeException;

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> var1);

    public void erase();
}

