/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.util;

import java.util.function.Supplier;

public final class SupplyOnce {
    private SupplyOnce() {
    }

    public static <T> Supplier<T> memoize(Supplier<T> loader) {
        return new NonLockingSupplyOnce<T>(loader);
    }

    private static final class NonLockingSupplyOnce<T>
    implements Supplier<T> {
        private int loaded;
        private Object result;
        private final Supplier<T> loader;

        private NonLockingSupplyOnce(Supplier<T> loader) {
            this.loader = loader;
        }

        @Override
        public T get() {
            switch (this.loaded) {
                case 1: {
                    return (T)this.result;
                }
                case 2: {
                    throw (RuntimeException)this.result;
                }
                case 0: {
                    return this.load();
                }
            }
            throw new IllegalStateException();
        }

        private T load() {
            try {
                this.loaded = 1;
                T obj = this.loader.get();
                this.result = obj;
                return obj;
            }
            catch (RuntimeException re) {
                this.loaded = 2;
                this.result = re;
                throw re;
            }
        }
    }
}

