/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.config;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.config.ImmutableAdjustable;

public interface StoreConfig {
    public static final String CONFIG_REPOSITORY_ID = "repository-id";
    public static final String DEFAULT_REPOSITORY_ID = "";
    public static final String CONFIG_PARENTS_PER_COMMIT = "parents-per-commit";
    public static final int DEFAULT_PARENTS_PER_COMMIT = 20;
    public static final String CONFIG_COMMIT_TIMEOUT_MILLIS = "commit-timeout-millis";
    public static final int DEFAULT_COMMIT_TIMEOUT_MILLIS = 5000;
    public static final String CONFIG_COMMIT_RETRIES = "commit-retries";
    public static final int DEFAULT_COMMIT_RETRIES = Integer.MAX_VALUE;
    public static final String CONFIG_RETRY_INITIAL_SLEEP_MILLIS_LOWER = "retry-initial-sleep-millis-lower";
    public static final int DEFAULT_RETRY_INITIAL_SLEEP_MILLIS_LOWER = 5;
    public static final String CONFIG_RETRY_INITIAL_SLEEP_MILLIS_UPPER = "retry-initial-sleep-millis-upper";
    public static final int DEFAULT_RETRY_INITIAL_SLEEP_MILLIS_UPPER = 25;
    public static final String CONFIG_RETRY_MAX_SLEEP_MILLIS = "retry-max-sleep-millis";
    public static final int DEFAULT_RETRY_MAX_SLEEP_MILLIS = 250;
    public static final String CONFIG_MAX_INCREMENTAL_INDEX_SIZE = "max-incremental-index-size";
    public static final int DEFAULT_MAX_INCREMENTAL_INDEX_SIZE = 51200;
    public static final String CONFIG_MAX_SERIALIZED_INDEX_SIZE = "max-serialized-index-size";
    public static final int DEFAULT_MAX_SERIALIZED_INDEX_SIZE = 204800;
    public static final String CONFIG_MAX_REFERENCE_STRIPES_PER_COMMIT = "max-reference-stripes-per-commit";
    public static final int DEFAULT_MAX_REFERENCE_STRIPES_PER_COMMIT = 50;
    public static final String CONFIG_ASSUMED_WALL_CLOCK_DRIFT_MICROS = "assumed-wall-clock-drift-micros";
    public static final long DEFAULT_ASSUMED_WALL_CLOCK_DRIFT_MICROS = 5000000L;
    public static final String CONFIG_NAMESPACE_VALIDATION = "namespace-validation";
    public static final boolean DEFAULT_NAMESPACE_VALIDATION = true;
    public static final String CONFIG_PREVIOUS_HEAD_COUNT = "ref-previous-head-count";
    public static final int DEFAULT_PREVIOUS_HEAD_COUNT = 20;
    public static final String CONFIG_PREVIOUS_HEAD_TIME_SPAN_SECONDS = "ref-previous-head-time-span-seconds";
    public static final long DEFAULT_PREVIOUS_HEAD_TIME_SPAN_SECONDS = 300L;
    public static final String CONFIG_REFERENCE_CACHE_TTL = "reference-cache-ttl";
    public static final String CONFIG_REFERENCE_NEGATIVE_CACHE_TTL = "reference-cache-negative-ttl";

    @Deprecated(forRemoval=true)
    @Value.Default
    default public boolean validateNamespaces() {
        return true;
    }

    @Value.Default
    default public String repositoryId() {
        return DEFAULT_REPOSITORY_ID;
    }

    @Value.Default
    default public int commitRetries() {
        return Integer.MAX_VALUE;
    }

    @Value.Default
    default public long commitTimeoutMillis() {
        return 5000L;
    }

    @Value.Default
    default public long retryInitialSleepMillisLower() {
        return 5L;
    }

    @Value.Default
    default public long retryInitialSleepMillisUpper() {
        return 25L;
    }

    @Value.Default
    default public long retryMaxSleepMillis() {
        return 250L;
    }

    @Value.Default
    default public int parentsPerCommit() {
        return 20;
    }

    @Value.Default
    default public int maxIncrementalIndexSize() {
        return 51200;
    }

    @Value.Default
    default public int maxSerializedIndexSize() {
        return 204800;
    }

    @Value.Default
    default public int maxReferenceStripesPerCommit() {
        return 50;
    }

    @Value.Default
    default public long assumedWallClockDriftMicros() {
        return 5000000L;
    }

    @Value.Default
    default public Clock clock() {
        return Clock.systemUTC();
    }

    @Value.Default
    default public int referencePreviousHeadCount() {
        return 20;
    }

    @Value.Default
    default public long referencePreviousHeadTimeSpanSeconds() {
        return 300L;
    }

    public Optional<Duration> referenceCacheTtl();

    public Optional<Duration> referenceCacheNegativeTtl();

    @Value.Redacted
    @Value.Auxiliary
    @Value.NonAttribute
    default public long currentTimeMicros() {
        Instant instant = this.clock().instant();
        long time = instant.getEpochSecond();
        long nano = instant.getNano();
        return TimeUnit.SECONDS.toMicros(time) + TimeUnit.NANOSECONDS.toMicros(nano);
    }

    @Value.Immutable
    public static interface Adjustable
    extends StoreConfig {
        public static Adjustable empty() {
            return ImmutableAdjustable.builder().build();
        }

        default public Adjustable from(StoreConfig config) {
            return ImmutableAdjustable.builder().from(this).from(config).build();
        }

        default public Adjustable fromFunction(Function<String, String> configFunction) {
            Adjustable a = this;
            String v = configFunction.apply(StoreConfig.CONFIG_REPOSITORY_ID);
            if (v != null) {
                a = a.withRepositoryId(v);
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_COMMIT_RETRIES)) != null) {
                a = a.withCommitRetries(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_COMMIT_TIMEOUT_MILLIS)) != null) {
                a = a.withCommitTimeoutMillis(Long.parseLong(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_RETRY_INITIAL_SLEEP_MILLIS_LOWER)) != null) {
                a = a.withRetryInitialSleepMillisLower(Long.parseLong(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_RETRY_INITIAL_SLEEP_MILLIS_UPPER)) != null) {
                a = a.withRetryInitialSleepMillisUpper(Long.parseLong(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_RETRY_MAX_SLEEP_MILLIS)) != null) {
                a = a.withRetryMaxSleepMillis(Long.parseLong(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_PARENTS_PER_COMMIT)) != null) {
                a = a.withParentsPerCommit(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_MAX_INCREMENTAL_INDEX_SIZE)) != null) {
                a = a.withMaxIncrementalIndexSize(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_MAX_SERIALIZED_INDEX_SIZE)) != null) {
                a = a.withMaxSerializedIndexSize(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_MAX_REFERENCE_STRIPES_PER_COMMIT)) != null) {
                a = a.withMaxReferenceStripesPerCommit(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_ASSUMED_WALL_CLOCK_DRIFT_MICROS)) != null) {
                a = a.withAssumedWallClockDriftMicros(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_NAMESPACE_VALIDATION)) != null) {
                a = a.withValidateNamespaces(Boolean.parseBoolean(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_PREVIOUS_HEAD_COUNT)) != null) {
                a = a.withReferencePreviousHeadCount(Integer.parseInt(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_PREVIOUS_HEAD_TIME_SPAN_SECONDS)) != null) {
                a = a.withReferencePreviousHeadTimeSpanSeconds(Long.parseLong(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_REFERENCE_CACHE_TTL)) != null) {
                a = a.withReferenceCacheTtl(Duration.parse(v.trim()));
            }
            if ((v = configFunction.apply(StoreConfig.CONFIG_REFERENCE_NEGATIVE_CACHE_TTL)) != null) {
                a = a.withReferenceCacheNegativeTtl(Duration.parse(v.trim()));
            }
            return a;
        }

        public Adjustable withRepositoryId(String var1);

        public Adjustable withCommitRetries(int var1);

        public Adjustable withCommitTimeoutMillis(long var1);

        public Adjustable withRetryInitialSleepMillisLower(long var1);

        public Adjustable withRetryInitialSleepMillisUpper(long var1);

        public Adjustable withRetryMaxSleepMillis(long var1);

        public Adjustable withParentsPerCommit(int var1);

        public Adjustable withMaxIncrementalIndexSize(int var1);

        public Adjustable withMaxSerializedIndexSize(int var1);

        public Adjustable withMaxReferenceStripesPerCommit(int var1);

        public Adjustable withAssumedWallClockDriftMicros(long var1);

        public Adjustable withValidateNamespaces(boolean var1);

        public Adjustable withClock(Clock var1);

        public Adjustable withReferencePreviousHeadCount(int var1);

        public Adjustable withReferencePreviousHeadTimeSpanSeconds(long var1);

        public Adjustable withReferenceCacheTtl(Duration var1);

        public Adjustable withReferenceCacheNegativeTtl(Duration var1);
    }
}

