/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.logic.ImmutableCommitStatus;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;

public interface ConsistencyLogic {
    public <R> R checkReference(Reference var1, CommitStatusCallback<R> var2);

    public <R> R checkCommit(ObjId var1, CommitStatusCallback<R> var2);

    @Value.Immutable
    public static interface CommitStatus {
        @Value.Parameter(order=1)
        public ObjId id();

        @Nullable
        @Value.Parameter(order=2)
        public CommitObj commit();

        @Value.Parameter(order=3)
        public boolean indexObjectsAvailable();

        @Value.Parameter(order=4)
        public boolean contentObjectsAvailable();

        public static CommitStatus commitStatus(ObjId id, CommitObj commit, boolean indexObjectsAvailable, boolean contentObjectsAvailable) {
            return ImmutableCommitStatus.of(id, commit, indexObjectsAvailable, contentObjectsAvailable);
        }
    }

    @FunctionalInterface
    public static interface CommitStatusCallback<R> {
        public R commitCallback(CommitStatus var1);
    }
}

