/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Optional;
import java.util.function.Predicate;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.ImmutableDiffQuery;
import org.projectnessie.versioned.storage.common.logic.PageableQuery;
import org.projectnessie.versioned.storage.common.logic.PagingToken;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;

@Value.Immutable
public interface DiffQuery
extends PageableQuery {
    @Override
    @Value.Parameter(order=1)
    public Optional<PagingToken> pagingToken();

    @Nullable
    @Value.Parameter(order=2)
    public CommitObj fromCommit();

    @Nullable
    @Value.Parameter(order=3)
    public CommitObj toCommit();

    @Nullable
    @Value.Parameter(order=4)
    public StoreKey start();

    @Nullable
    @Value.Parameter(order=5)
    public StoreKey end();

    @Value.Parameter(order=6)
    public boolean prefetch();

    @Nullable
    @Value.Parameter(order=7)
    public Predicate<StoreKey> filter();

    @Nonnull
    public static DiffQuery diffQuery(@Nullable PagingToken pagingToken, @Nullable CommitObj fromCommit, @Nullable CommitObj toCommit, @Nullable StoreKey start, @Nullable StoreKey end, boolean prefetch, @Nullable Predicate<StoreKey> filter) {
        return ImmutableDiffQuery.of(Optional.ofNullable(pagingToken), fromCommit, toCommit, start, end, prefetch, filter);
    }

    @Nonnull
    public static DiffQuery diffQuery(@Nullable CommitObj fromCommit, @Nullable CommitObj toCommit, boolean prefetch, @Nullable Predicate<StoreKey> filter) {
        return DiffQuery.diffQuery(null, fromCommit, toCommit, null, null, prefetch, filter);
    }
}

