/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.logic;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.UUID;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.logic.CreateCommit;
import org.projectnessie.versioned.storage.common.persist.ObjId;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CreateCommit.Remove", generator="Immutables")
@Immutable
public final class ImmutableRemove
implements CreateCommit.Remove {
    private final StoreKey key;
    private final int payload;
    private final ObjId expectedValue;
    @jakarta.annotation.Nullable
    private final UUID contentId;

    private ImmutableRemove(StoreKey key, int payload, ObjId expectedValue, @jakarta.annotation.Nullable UUID contentId) {
        this.key = Objects.requireNonNull(key, "key");
        this.payload = payload;
        this.expectedValue = Objects.requireNonNull(expectedValue, "expectedValue");
        this.contentId = contentId;
    }

    private ImmutableRemove(ImmutableRemove original, StoreKey key, int payload, ObjId expectedValue, @jakarta.annotation.Nullable UUID contentId) {
        this.key = key;
        this.payload = payload;
        this.expectedValue = expectedValue;
        this.contentId = contentId;
    }

    @Override
    public StoreKey key() {
        return this.key;
    }

    @Override
    public int payload() {
        return this.payload;
    }

    @Override
    public ObjId expectedValue() {
        return this.expectedValue;
    }

    @Override
    @jakarta.annotation.Nullable
    public UUID contentId() {
        return this.contentId;
    }

    public final ImmutableRemove withKey(StoreKey value) {
        if (this.key == value) {
            return this;
        }
        StoreKey newValue = Objects.requireNonNull(value, "key");
        return new ImmutableRemove(this, newValue, this.payload, this.expectedValue, this.contentId);
    }

    public final ImmutableRemove withPayload(int value) {
        if (this.payload == value) {
            return this;
        }
        return new ImmutableRemove(this, this.key, value, this.expectedValue, this.contentId);
    }

    public final ImmutableRemove withExpectedValue(ObjId value) {
        if (this.expectedValue == value) {
            return this;
        }
        ObjId newValue = Objects.requireNonNull(value, "expectedValue");
        return new ImmutableRemove(this, this.key, this.payload, newValue, this.contentId);
    }

    public final ImmutableRemove withContentId(@jakarta.annotation.Nullable UUID value) {
        if (this.contentId == value) {
            return this;
        }
        return new ImmutableRemove(this, this.key, this.payload, this.expectedValue, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRemove && this.equalTo(0, (ImmutableRemove)another);
    }

    private boolean equalTo(int synthetic, ImmutableRemove another) {
        return this.key.equals(another.key) && this.payload == another.payload && this.expectedValue.equals(another.expectedValue) && Objects.equals(this.contentId, another.contentId);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.payload;
        h += (h << 5) + this.expectedValue.hashCode();
        h += (h << 5) + Objects.hashCode(this.contentId);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"Remove").omitNullValues().add("key", (Object)this.key).add("payload", this.payload).add("expectedValue", (Object)this.expectedValue).add("contentId", (Object)this.contentId).toString();
    }

    public static ImmutableRemove of(StoreKey key, int payload, ObjId expectedValue, @jakarta.annotation.Nullable UUID contentId) {
        return new ImmutableRemove(key, payload, expectedValue, contentId);
    }

    public static ImmutableRemove copyOf(CreateCommit.Remove instance) {
        if (instance instanceof ImmutableRemove) {
            return (ImmutableRemove)instance;
        }
        return ImmutableRemove.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CreateCommit.Remove", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_PAYLOAD = 2L;
        private static final long INIT_BIT_EXPECTED_VALUE = 4L;
        private long initBits = 7L;
        @Nullable
        private StoreKey key;
        private int payload;
        @Nullable
        private ObjId expectedValue;
        @Nullable
        private UUID contentId;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CreateCommit.Remove instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.key());
            this.payload(instance.payload());
            this.expectedValue(instance.expectedValue());
            UUID contentIdValue = instance.contentId();
            if (contentIdValue != null) {
                this.contentId(contentIdValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(StoreKey key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder payload(int payload) {
            this.payload = payload;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedValue(ObjId expectedValue) {
            this.expectedValue = Objects.requireNonNull(expectedValue, "expectedValue");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(@jakarta.annotation.Nullable UUID contentId) {
            this.contentId = contentId;
            return this;
        }

        public ImmutableRemove build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRemove(null, this.key, this.payload, this.expectedValue, this.contentId);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("payload");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("expectedValue");
            }
            return "Cannot build Remove, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

