/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import java.util.Locale;

public enum Compression {
    NONE('N'),
    GZIP('G'),
    DEFLATE('D'),
    ZSTD('Z'),
    LZ4('L'),
    SNAPPY('S');

    private final char value;
    private final String valueString;

    public static Compression fromValue(String valueString) {
        if (valueString.length() == 1) {
            return Compression.fromValue(valueString.charAt(0));
        }
        return Compression.valueOf(valueString.toUpperCase(Locale.ROOT));
    }

    public static Compression fromValue(char value) {
        switch (value) {
            case 'N': {
                return NONE;
            }
            case 'G': {
                return GZIP;
            }
            case 'D': {
                return DEFLATE;
            }
            case 'Z': {
                return ZSTD;
            }
            case 'L': {
                return LZ4;
            }
            case 'S': {
                return SNAPPY;
            }
        }
        throw new IllegalArgumentException("Illegal value '" + value + "' for Compression");
    }

    private Compression(char value) {
        this.value = value;
        this.valueString = "" + value;
    }

    public char value() {
        return this.value;
    }

    public String valueString() {
        return this.valueString;
    }
}

