/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.objtypes;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.annotations.VisibleForTesting;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.Map;
import org.immutables.value.Value;
import org.projectnessie.versioned.storage.common.objtypes.ImmutableGenericObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;

@Value.Immutable
@Value.Style(jdkOnly=true)
@VisibleForTesting
public abstract class GenericObj
implements Obj {
    public static final String VERSION_TOKEN_ATTRIBUTE = "versionToken";

    @Override
    @JsonIgnore
    public abstract ObjType type();

    @Override
    @JsonIgnore
    public abstract ObjId id();

    @JsonAnyGetter
    @AllowNulls
    public abstract Map<String, Object> attributes();

    @JsonCreator
    static GenericObj create(@JacksonInject(value="nessie.storage.ObjType") ObjType objType, @JacksonInject(value="nessie.storage.ObjId") ObjId id, @JacksonInject(value="nessie.storage.ObjVersion") String versionToken, @JsonAnySetter Map<String, Object> attributes) {
        ImmutableGenericObj.Builder builder = ImmutableGenericObj.builder().type(objType).id(id).attributes(attributes);
        if (versionToken != null) {
            builder.putAttributes(VERSION_TOKEN_ATTRIBUTE, versionToken);
        }
        return builder.build();
    }

    @Documented
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    static @interface AllowNulls {
    }
}

