/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Map;
import java.util.UUID;
import org.projectnessie.versioned.storage.common.persist.Hashable;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjIdHasher;

final class ObjIdHasherImpl
implements ObjIdHasher {
    private final Hasher hasher;

    ObjIdHasherImpl(Hasher hasher) {
        this.hasher = hasher;
    }

    ObjIdHasherImpl() {
        this(Hashing.sha256().newHasher());
    }

    @Override
    public ObjIdHasher hash(boolean value) {
        this.hasher.putBoolean(value);
        return this;
    }

    @Override
    public ObjIdHasher hash(char value) {
        this.hasher.putChar(value);
        return this;
    }

    @Override
    public ObjIdHasher hash(int value) {
        this.hasher.putInt(value);
        return this;
    }

    @Override
    public ObjIdHasher hash(long value) {
        this.hasher.putLong(value);
        return this;
    }

    @Override
    public ObjIdHasher hash(float value) {
        this.hasher.putFloat(value);
        return this;
    }

    @Override
    public ObjIdHasher hash(double value) {
        this.hasher.putDouble(value);
        return this;
    }

    @Override
    public ObjIdHasher hash(Enum<?> value) {
        if (value != null) {
            this.hash(value.name());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(Boolean value) {
        if (value != null) {
            this.hasher.putBoolean(value.booleanValue());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(Integer value) {
        if (value != null) {
            this.hasher.putInt(value.intValue());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(Long value) {
        if (value != null) {
            this.hasher.putLong(value.longValue());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(Float value) {
        if (value != null) {
            this.hasher.putFloat(value.floatValue());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(Double value) {
        if (value != null) {
            this.hasher.putDouble(value.doubleValue());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(String value) {
        if (value != null) {
            this.hasher.putString((CharSequence)value, StandardCharsets.UTF_8);
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(byte[] value) {
        if (value != null) {
            this.hasher.putBytes(value);
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(ByteBuffer value) {
        if (value != null) {
            this.hasher.putBytes(value);
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(UUID value) {
        if (value != null) {
            this.hasher.putLong(value.getMostSignificantBits());
            this.hasher.putLong(value.getLeastSignificantBits());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(ObjId value) {
        if (value != null) {
            this.hasher.putBytes(value.asByteBuffer());
        }
        return this;
    }

    @Override
    public ObjIdHasher hash(Hashable value) {
        if (value != null) {
            value.hash(this);
        }
        return this;
    }

    @Override
    public ObjIdHasher hashCollection(Collection<? extends Hashable> value) {
        if (value != null) {
            value.forEach(this::hash);
        }
        return this;
    }

    @Override
    public ObjIdHasher hashUuidCollection(Collection<UUID> value) {
        if (value != null) {
            value.forEach(uuid -> this.hash(uuid.getMostSignificantBits()).hash(uuid.getLeastSignificantBits()));
        }
        return this;
    }

    @Override
    public ObjIdHasher hashIntCollection(Collection<Integer> value) {
        if (value != null) {
            value.forEach(this::hash);
        }
        return this;
    }

    @Override
    public ObjIdHasher hashLongCollection(Collection<Long> value) {
        if (value != null) {
            value.forEach(this::hash);
        }
        return this;
    }

    @Override
    public ObjIdHasher hashStringToStringMap(Map<String, String> map) {
        if (map != null) {
            map.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> this.hash((String)e.getKey()).hash((String)e.getValue()));
        }
        return this;
    }

    @Override
    public ObjId generate() {
        return ObjId.objIdFromByteArray(this.hasher.hash().asBytes());
    }
}

