/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.common.persist;

import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.Persist;

public interface ValidatingPersist
extends Persist {
    default public void verifySoftRestrictions(Obj obj) throws ObjTooLargeException {
        IndexObj s;
        ByteString index;
        if (obj instanceof CommitObj) {
            CommitObj c = (CommitObj)obj;
            ByteString serializedIndex = c.incrementalIndex();
            if (serializedIndex.size() > this.effectiveIncrementalIndexSizeLimit()) {
                throw new ObjTooLargeException(serializedIndex.size(), this.effectiveIncrementalIndexSizeLimit());
            }
        } else if (obj instanceof IndexObj && (index = (s = (IndexObj)obj).index()).size() > this.effectiveIndexSegmentSizeLimit()) {
            throw new ObjTooLargeException(index.size(), this.effectiveIndexSegmentSizeLimit());
        }
    }
}

