/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.mongodb.ErrorCategory;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoException;
import com.mongodb.MongoExecutionTimeoutException;
import com.mongodb.MongoInterruptedException;
import com.mongodb.MongoServerUnavailableException;
import com.mongodb.MongoSocketReadTimeoutException;
import com.mongodb.MongoTimeoutException;
import com.mongodb.MongoWriteException;
import com.mongodb.WriteError;
import com.mongodb.bulk.BulkWriteError;
import com.mongodb.bulk.BulkWriteInsert;
import com.mongodb.bulk.BulkWriteResult;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertOneModel;
import com.mongodb.client.model.ReplaceOneModel;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.Updates;
import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.agrona.collections.Object2IntHashMap;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.UnknownOperationResultException;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.ObjTypes;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.persist.UpdateableObj;
import org.projectnessie.versioned.storage.mongodb.MongoDBBackend;
import org.projectnessie.versioned.storage.mongodb.MongoDBSerde;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializers;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;

public class MongoDBPersist
implements Persist {
    private final StoreConfig config;
    private final MongoDBBackend backend;

    MongoDBPersist(MongoDBBackend backend, StoreConfig config) {
        this.config = config;
        this.backend = backend;
    }

    @Nonnull
    public String name() {
        return "MongoDB";
    }

    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    private Document idRefDoc(Reference reference) {
        return this.idRefDoc(reference.name());
    }

    private Document idRefDoc(String name) {
        Document idDoc = new Document();
        idDoc.put("r", (Object)this.config.repositoryId());
        idDoc.put("n", (Object)name);
        return idDoc;
    }

    private Document idObjDoc(ObjId id) {
        Document idDoc = new Document();
        idDoc.put("r", (Object)this.config.repositoryId());
        idDoc.put("i", (Object)MongoDBSerde.objIdToBinary(id));
        return idDoc;
    }

    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        byte[] previous;
        ObjId extendedInfoObj;
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        Document doc = new Document();
        doc.put("_id", (Object)this.idRefDoc(reference));
        doc.put("p", (Object)MongoDBSerde.objIdToBinary(reference.pointer()));
        doc.put("d", (Object)reference.deleted());
        long createdAtMicros = reference.createdAtMicros();
        if (createdAtMicros != 0L) {
            doc.put("c", (Object)createdAtMicros);
        }
        if ((extendedInfoObj = reference.extendedInfoObj()) != null) {
            doc.put("e", (Object)MongoDBSerde.objIdToBinary(extendedInfoObj));
        }
        if ((previous = ProtoSerialization.serializePreviousPointers((List)reference.previousPointers())) != null) {
            doc.put("h", (Object)new Binary(previous));
        }
        try {
            this.backend.refs().insertOne((Object)doc);
        }
        catch (MongoWriteException e) {
            if (e.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                throw new RefAlreadyExistsException(this.fetchReference(reference.name()));
            }
            throw MongoDBPersist.unhandledException((RuntimeException)((Object)e));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        return reference;
    }

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        UpdateResult result;
        reference = reference.withDeleted(false);
        try {
            result = this.backend.refs().updateOne(this.referenceCondition(reference), Updates.set((String)"d", (Object)true));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        if (result.getModifiedCount() != 1L) {
            Reference ex = this.fetchReference(reference.name());
            if (ex == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(ex);
        }
        return reference.withDeleted(true);
    }

    private Bson referenceCondition(Reference reference) {
        ArrayList<Bson> filters = new ArrayList<Bson>(5);
        filters.add(Filters.eq((String)"_id", (Object)this.idRefDoc(reference)));
        filters.add(Filters.eq((String)"p", (Object)MongoDBSerde.objIdToBinary(reference.pointer())));
        filters.add(Filters.eq((String)"d", (Object)reference.deleted()));
        long createdAt = reference.createdAtMicros();
        if (createdAt != 0L) {
            filters.add(Filters.eq((String)"c", (Object)createdAt));
        } else {
            filters.add(Filters.not((Bson)Filters.exists((String)"c")));
        }
        ObjId extendedInfoObj = reference.extendedInfoObj();
        if (extendedInfoObj != null) {
            filters.add(Filters.eq((String)"e", (Object)MongoDBSerde.objIdToBinary(extendedInfoObj)));
        } else {
            filters.add(Filters.not((Bson)Filters.exists((String)"e")));
        }
        return Filters.and(filters);
    }

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        UpdateResult result;
        reference = reference.withDeleted(false);
        Reference updated = reference.forNewPointer(newPointer, this.config);
        ArrayList<Bson> updates = new ArrayList<Bson>();
        updates.add(Updates.set((String)"p", (Object)MongoDBSerde.objIdToBinary(newPointer)));
        byte[] previous = ProtoSerialization.serializePreviousPointers((List)updated.previousPointers());
        if (previous != null) {
            updates.add(Updates.set((String)"h", (Object)new Binary(previous)));
        }
        try {
            result = this.backend.refs().updateOne(this.referenceCondition(reference), updates);
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        if (result.getModifiedCount() != 1L) {
            if (result.getMatchedCount() == 1L) {
                return updated;
            }
            Reference ex = this.fetchReference(reference.name());
            if (ex == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(ex);
        }
        return updated;
    }

    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        DeleteResult result;
        reference = reference.withDeleted(true);
        try {
            result = this.backend.refs().deleteOne(this.referenceCondition(reference));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        if (result.getDeletedCount() != 1L) {
            Reference ex = this.fetchReference(reference.name());
            if (ex == null) {
                throw new RefNotFoundException(reference.name());
            }
            throw new RefConditionFailedException(ex);
        }
    }

    public Reference fetchReference(@Nonnull String name) {
        FindIterable result;
        try {
            result = this.backend.refs().find(Filters.eq((String)"_id", (Object)this.idRefDoc(name)));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        Document doc = (Document)result.first();
        if (doc == null) {
            return null;
        }
        Binary prev = (Binary)doc.get((Object)"h", Binary.class);
        List previous = prev != null ? ProtoSerialization.deserializePreviousPointers((byte[])prev.getData()) : Collections.emptyList();
        return Reference.reference((String)name, (ObjId)MongoDBSerde.binaryToObjId((Binary)doc.get((Object)"p", Binary.class)), (boolean)doc.getBoolean((Object)"d"), (long)MongoDBPersist.refCreatedAt(doc), (ObjId)MongoDBSerde.binaryToObjId((Binary)doc.get((Object)"e", Binary.class)), (List)previous);
    }

    private static Long refCreatedAt(Document doc) {
        return doc.containsKey((Object)"c") ? doc.getLong((Object)"c") : 0L;
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        FindIterable result;
        List nameIdDocs = Arrays.stream(names).filter(Objects::nonNull).map(this::idRefDoc).collect(Collectors.toList());
        try {
            result = this.backend.refs().find(Filters.in((String)"_id", nameIdDocs));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        Reference[] r = new Reference[names.length];
        for (Document doc : result) {
            String name = ((Document)doc.get((Object)"_id", Document.class)).getString((Object)"n");
            Binary prev = (Binary)doc.get((Object)"h", Binary.class);
            List previous = prev != null ? ProtoSerialization.deserializePreviousPointers((byte[])prev.getData()) : Collections.emptyList();
            Reference reference = Reference.reference((String)name, (ObjId)MongoDBSerde.binaryToObjId((Binary)doc.get((Object)"p", Binary.class)), (boolean)doc.getBoolean((Object)"d"), (long)MongoDBPersist.refCreatedAt(doc), (ObjId)MongoDBSerde.binaryToObjId((Binary)doc.get((Object)"e", Binary.class)), (List)previous);
            for (int i = 0; i < names.length; ++i) {
                if (!name.equals(names[i])) continue;
                r[i] = reference;
            }
        }
        return r;
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        FindIterable result;
        try {
            result = type != null ? this.backend.objs().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idObjDoc(id)), Filters.eq((String)"y", (Object)type.shortName())})) : this.backend.objs().find(Filters.eq((String)"_id", (Object)this.idObjDoc(id)));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        Document doc = (Document)result.first();
        T obj = this.docToObj(id, doc, type, typeClass);
        if (obj == null) {
            throw new ObjNotFoundException(id);
        }
        return obj;
    }

    @Nonnull
    public ObjType fetchObjType(@Nonnull ObjId id) throws ObjNotFoundException {
        FindIterable result;
        try {
            result = this.backend.objs().find(Filters.eq((String)"_id", (Object)this.idObjDoc(id)));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        Document doc = (Document)result.first();
        if (doc == null) {
            throw new ObjNotFoundException(id);
        }
        return ObjTypes.forShortName((String)doc.getString((Object)"y"));
    }

    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) {
        ArrayList<Document> list = new ArrayList<Document>(ids.length);
        Object2IntHashMap idToIndex = new Object2IntHashMap(ids.length * 2, 0.65f, -1);
        Obj[] r = (Obj[])Array.newInstance(typeClass, ids.length);
        for (int i = 0; i < ids.length; ++i) {
            ObjId id = ids[i];
            if (id == null) continue;
            list.add(this.idObjDoc(id));
            idToIndex.put((Object)id, i);
        }
        if (!list.isEmpty()) {
            this.fetchObjsPage(r, list, (Object2IntHashMap<ObjId>)idToIndex, type, typeClass);
        }
        return r;
    }

    private <T extends Obj> void fetchObjsPage(Obj[] r, List<Document> list, Object2IntHashMap<ObjId> idToIndex, ObjType type, Class<T> typeClass) {
        FindIterable result;
        try {
            result = this.backend.objs().find(Filters.in((String)"_id", list));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        for (Document doc : result) {
            int idx;
            T obj = this.docToObj(doc, type, typeClass);
            if (obj == null || (idx = idToIndex.getValue((Object)obj.id())) == -1) continue;
            r[idx] = obj;
        }
    }

    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        Document doc = this.objToDoc(obj, ignoreSoftSizeRestrictions);
        try {
            this.backend.objs().insertOne((Object)doc);
        }
        catch (MongoWriteException e) {
            if (e.getError().getCategory() == ErrorCategory.DUPLICATE_KEY) {
                return false;
            }
            throw MongoDBPersist.handleMongoWriteException(e);
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        return true;
    }

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        ArrayList<InsertOneModel> docs = new ArrayList<InsertOneModel>(objs.length);
        for (Obj obj : objs) {
            if (obj == null) continue;
            docs.add(new InsertOneModel((Object)this.objToDoc(obj, false)));
        }
        boolean[] r = new boolean[objs.length];
        ArrayList inserts = new ArrayList(docs);
        while (!inserts.isEmpty()) {
            try {
                BulkWriteResult res = this.backend.objs().bulkWrite(inserts);
                for (BulkWriteInsert insert : res.getInserts()) {
                    ObjId id2 = MongoDBPersist.objIdFromBulkWriteInsert(insert);
                    r[MongoDBPersist.objIdIndex((Obj[])objs, (ObjId)id2)] = id2 != null;
                }
                break;
            }
            catch (MongoBulkWriteException e) {
                BulkWriteInsert insert;
                List errs = e.getWriteErrors();
                insert = errs.iterator();
                while (insert.hasNext()) {
                    BulkWriteError err = (BulkWriteError)insert.next();
                    if (err.getCategory() == ErrorCategory.DUPLICATE_KEY) continue;
                    throw MongoDBPersist.handleMongoWriteError((MongoException)e, (WriteError)err);
                }
                BulkWriteResult res = e.getWriteResult();
                inserts.clear();
                res.getInserts().stream().map(MongoDBPersist::objIdFromBulkWriteInsert).mapToInt(id -> MongoDBPersist.objIdIndex(objs, id)).mapToObj(docs::get).forEach(inserts::add);
            }
            catch (RuntimeException e) {
                throw MongoDBPersist.unhandledException(e);
            }
        }
        return r;
    }

    private static ObjId objIdFromDoc(Document doc) {
        return MongoDBSerde.binaryToObjId((Binary)((Document)doc.get((Object)"_id", Document.class)).get((Object)"i", Binary.class));
    }

    private static int objIdIndex(Obj[] objs, ObjId id) {
        for (int i = 0; i < objs.length; ++i) {
            if (!id.equals(objs[i].id())) continue;
            return i;
        }
        throw new IllegalArgumentException("ObjId " + id + " not in objs");
    }

    private static ObjId objIdFromBulkWriteInsert(BulkWriteInsert insert) {
        return ObjId.objIdFromByteArray((byte[])insert.getId().asDocument().getBinary((Object)"i").getData());
    }

    public void deleteObj(@Nonnull ObjId id) {
        try {
            this.backend.objs().deleteOne(Filters.eq((String)"_id", (Object)this.idObjDoc(id)));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
    }

    public void deleteObjs(@Nonnull ObjId[] ids) {
        List list = Stream.of(ids).filter(Objects::nonNull).map(this::idObjDoc).collect(Collectors.toList());
        if (list.isEmpty()) {
            return;
        }
        try {
            this.backend.objs().deleteMany(Filters.in((String)"_id", list));
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
    }

    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        UpdateResult result;
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        ReplaceOptions options = MongoDBPersist.upsertOptions();
        Document doc = this.objToDoc(obj, false);
        try {
            result = this.backend.objs().replaceOne(Filters.eq((String)"_id", (Object)this.idObjDoc(id)), (Object)doc, options);
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
        if (!result.wasAcknowledged()) {
            throw new RuntimeException("Upsert not acknowledged");
        }
    }

    private static ReplaceOptions upsertOptions() {
        ReplaceOptions options = new ReplaceOptions();
        options.upsert(true);
        return options;
    }

    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        ReplaceOptions options = MongoDBPersist.upsertOptions();
        ArrayList<ReplaceOneModel> docs = new ArrayList<ReplaceOneModel>(objs.length);
        for (Obj obj : objs) {
            if (obj == null) continue;
            ObjId id = obj.id();
            docs.add(new ReplaceOneModel(Filters.eq((String)"_id", (Object)this.idObjDoc(id)), (Object)this.objToDoc(obj, false), options));
        }
        ArrayList updates = new ArrayList(docs);
        if (!updates.isEmpty()) {
            BulkWriteResult res;
            try {
                res = this.backend.objs().bulkWrite(updates);
            }
            catch (RuntimeException e) {
                throw MongoDBPersist.unhandledException(e);
            }
            if (!res.wasAcknowledged()) {
                throw new RuntimeException("Upsert not acknowledged");
            }
        }
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        ObjId id = obj.id();
        ObjType type = obj.type();
        try {
            return this.backend.objs().findOneAndDelete(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idObjDoc(id)), Filters.eq((String)"y", (Object)type.shortName()), Filters.eq((String)"V", (Object)obj.versionToken())})) != null;
        }
        catch (RuntimeException e) {
            throw MongoDBPersist.unhandledException(e);
        }
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) throws ObjTooLargeException {
        ObjId id = expected.id();
        ObjType type = expected.type();
        String expectedVersion = expected.versionToken();
        Preconditions.checkArgument((id != null && id.equals(newValue.id()) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)expected.type().equals(newValue.type()));
        Preconditions.checkArgument((!expected.versionToken().equals(newValue.versionToken()) ? 1 : 0) != 0);
        Document doc = this.objToDoc((Obj)newValue, false);
        List updates = doc.entrySet().stream().filter(e -> !"_id".equals(e.getKey())).map(e -> Updates.set((String)((String)e.getKey()), e.getValue())).collect(Collectors.toList());
        Bson update = Updates.combine(updates);
        try {
            return this.backend.objs().findOneAndUpdate(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id", (Object)this.idObjDoc(id)), Filters.eq((String)"y", (Object)type.shortName()), Filters.eq((String)"V", (Object)expectedVersion)}), update) != null;
        }
        catch (RuntimeException e2) {
            throw MongoDBPersist.unhandledException(e2);
        }
    }

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes);
    }

    public void erase() {
        this.backend.eraseRepositories(Collections.singleton(this.config.repositoryId()));
    }

    private <T extends Obj> T docToObj(Document doc, ObjType type, Class<T> typeClass) {
        ObjId id = MongoDBPersist.objIdFromDoc(doc);
        return this.docToObj(id, doc, type, typeClass);
    }

    private <T extends Obj> T docToObj(@Nonnull ObjId id, Document doc, ObjType t, Class<T> typeClass) {
        if (doc == null) {
            return null;
        }
        ObjType type = ObjTypes.forShortName((String)doc.getString((Object)"y"));
        if (t != null && !t.equals(type)) {
            return null;
        }
        ObjSerializer<Obj> serializer = ObjSerializers.forType(type);
        Document inner = (Document)doc.get((Object)serializer.fieldName(), Document.class);
        String versionToken = doc.getString((Object)"V");
        return (T)serializer.docToObj(id, type, inner, versionToken);
    }

    private Document objToDoc(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        ObjType type = obj.type();
        ObjSerializer<Obj> serializer = ObjSerializers.forType(type);
        Document doc = new Document();
        Document inner = new Document();
        doc.put("_id", (Object)this.idObjDoc(id));
        doc.put("y", (Object)type.shortName());
        if (obj instanceof UpdateableObj) {
            doc.put("V", (Object)((UpdateableObj)obj).versionToken());
        }
        int incrementalIndexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIncrementalIndexSizeLimit();
        int indexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIndexSegmentSizeLimit();
        serializer.objToDoc(obj, inner, incrementalIndexSizeLimit, indexSizeLimit);
        doc.put(serializer.fieldName(), (Object)inner);
        return doc;
    }

    static RuntimeException unhandledException(RuntimeException e) {
        if (e instanceof MongoInterruptedException || e instanceof MongoTimeoutException || e instanceof MongoServerUnavailableException || e instanceof MongoSocketReadTimeoutException || e instanceof MongoExecutionTimeoutException) {
            return new UnknownOperationResultException((Throwable)e);
        }
        if (e instanceof MongoWriteException) {
            return MongoDBPersist.handleMongoWriteException((MongoWriteException)((Object)e));
        }
        if (e instanceof MongoBulkWriteException) {
            MongoBulkWriteException specific = (MongoBulkWriteException)((Object)e);
            for (BulkWriteError error : specific.getWriteErrors()) {
                switch (error.getCategory()) {
                    case EXECUTION_TIMEOUT: 
                    case UNCATEGORIZED: {
                        return new UnknownOperationResultException((Throwable)e);
                    }
                }
            }
        }
        return e;
    }

    static RuntimeException handleMongoWriteException(MongoWriteException e) {
        return MongoDBPersist.handleMongoWriteError((MongoException)e, e.getError());
    }

    static RuntimeException handleMongoWriteError(MongoException e, WriteError error) {
        switch (error.getCategory()) {
            case EXECUTION_TIMEOUT: 
            case UNCATEGORIZED: {
                return new UnknownOperationResultException((Throwable)e);
            }
        }
        return e;
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final MongoCursor<Document> result;

        public ScanAllObjectsIterator(Set<ObjType> returnedObjTypes) {
            List objTypeShortNames = returnedObjTypes.stream().map(ObjType::shortName).collect(Collectors.toList());
            try {
                this.result = MongoDBPersist.this.backend.objs().find(Filters.and((Bson[])new Bson[]{Filters.eq((String)"_id.r", (Object)MongoDBPersist.this.config.repositoryId()), Filters.in((String)"y", objTypeShortNames)})).iterator();
            }
            catch (RuntimeException e) {
                throw MongoDBPersist.unhandledException(e);
            }
        }

        protected Obj computeNext() {
            if (!this.result.hasNext()) {
                return (Obj)this.endOfData();
            }
            try {
                Document doc = (Document)this.result.next();
                return MongoDBPersist.this.docToObj(doc, null, Obj.class);
            }
            catch (RuntimeException e) {
                throw MongoDBPersist.unhandledException(e);
            }
        }

        public void close() {
            this.result.close();
        }
    }
}

