/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.mongodb.serializers;

import org.bson.Document;
import org.bson.types.Binary;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.mongodb.serializers.ObjSerializer;
import org.projectnessie.versioned.storage.serialize.SmileSerialization;

public class CustomObjSerializer
implements ObjSerializer<Obj> {
    public static final ObjSerializer<?> INSTANCE = new CustomObjSerializer();
    private static final String COL_CUSTOM = "x";
    private static final String COL_CUSTOM_DATA = "xd";
    private static final String COL_CUSTOM_COMPRESSION = "xC";

    private CustomObjSerializer() {
    }

    @Override
    public String fieldName() {
        return COL_CUSTOM;
    }

    @Override
    public void objToDoc(Obj obj, Document doc, int incrementalIndexLimit, int maxSerializedIndexSize) {
        doc.put(COL_CUSTOM_DATA, (Object)new Binary(SmileSerialization.serializeObj((Obj)obj, compression -> doc.put(COL_CUSTOM_COMPRESSION, (Object)compression.valueString()))));
    }

    @Override
    public Obj docToObj(ObjId id, ObjType type, Document doc, String versionToken) {
        byte[] data = ((Binary)doc.get((Object)COL_CUSTOM_DATA, Binary.class)).getData();
        return SmileSerialization.deserializeObj((ObjId)id, (String)versionToken, (byte[])data, (Class)type.targetClass(), (String)doc.getString((Object)COL_CUSTOM_COMPRESSION));
    }
}

