/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.rocksdbtests;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.rocksdb.ImmutableRocksDBBackendConfig;
import org.projectnessie.versioned.storage.rocksdb.RocksDBBackend;
import org.projectnessie.versioned.storage.rocksdb.RocksDBBackendConfig;
import org.projectnessie.versioned.storage.testextension.BackendTestFactory;

public final class RocksDBBackendTestFactory
implements BackendTestFactory {
    private Path rocksDir;
    private RocksDBBackend backend;

    public Backend createNewBackend() {
        return this.backend;
    }

    public String getName() {
        return "RocksDB";
    }

    public void start() throws Exception {
        this.rocksDir = Files.createTempDirectory("junit-nessie-rocksdb", new FileAttribute[0]);
        ImmutableRocksDBBackendConfig config = RocksDBBackendConfig.builder().databasePath(this.rocksDir).build();
        this.backend = new RocksDBBackend((RocksDBBackendConfig)config);
    }

    public void stop() throws Exception {
        RocksDBBackend b = this.backend;
        Path dir = this.rocksDir;
        this.backend = null;
        this.rocksDir = null;
        try {
            if (b != null) {
                b.close();
            }
        }
        finally {
            if (dir != null) {
                RocksDBBackendTestFactory.deleteTempDir(dir);
            }
        }
    }

    private static void deleteTempDir(Path dir) throws IOException {
        if (Files.notExists(dir, new LinkOption[0])) {
            return;
        }
        final ArrayList failures = new ArrayList();
        Files.walkFileTree(dir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attributes) {
                return this.tryDelete(file);
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                return this.tryDelete(dir);
            }

            private FileVisitResult tryDelete(Path path) {
                try {
                    Files.delete(path);
                }
                catch (NoSuchFileException noSuchFileException) {
                }
                catch (IOException e) {
                    failures.add(e);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        if (!failures.isEmpty()) {
            IOException e = new IOException("Could not delete temp-directory " + dir);
            failures.forEach(e::addSuppressed);
            throw e;
        }
    }

    public Map<String, String> getQuarkusConfig() {
        return Map.of("nessie.version.store.persist.rocks.database-path", this.rocksDir.toString());
    }
}

