/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.rocksdb;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.storage.rocksdb.RocksDBBackendBaseConfig;
import org.projectnessie.versioned.storage.rocksdb.RocksDBBackendConfig;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="RocksDBBackendConfig", generator="Immutables")
@Immutable
public final class ImmutableRocksDBBackendConfig
implements RocksDBBackendConfig {
    private final Path databasePath;

    private ImmutableRocksDBBackendConfig(Path databasePath) {
        this.databasePath = databasePath;
    }

    @Override
    public Path databasePath() {
        return this.databasePath;
    }

    public final ImmutableRocksDBBackendConfig withDatabasePath(Path value) {
        if (this.databasePath == value) {
            return this;
        }
        Path newValue = Objects.requireNonNull(value, "databasePath");
        return new ImmutableRocksDBBackendConfig(newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRocksDBBackendConfig && this.equalTo(0, (ImmutableRocksDBBackendConfig)another);
    }

    private boolean equalTo(int synthetic, ImmutableRocksDBBackendConfig another) {
        return this.databasePath.equals(another.databasePath);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.databasePath.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"RocksDBBackendConfig").omitNullValues().add("databasePath", (Object)this.databasePath).toString();
    }

    public static ImmutableRocksDBBackendConfig copyOf(RocksDBBackendConfig instance) {
        if (instance instanceof ImmutableRocksDBBackendConfig) {
            return (ImmutableRocksDBBackendConfig)instance;
        }
        return ImmutableRocksDBBackendConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="RocksDBBackendConfig", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_DATABASE_PATH = 1L;
        private long initBits = 1L;
        @Nullable
        private Path databasePath;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(RocksDBBackendBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(RocksDBBackendConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((short)0, instance);
            return this;
        }

        private void from(short _unused, Object object) {
            RocksDBBackendBaseConfig instance;
            long bits = 0L;
            if (object instanceof RocksDBBackendBaseConfig) {
                instance = (RocksDBBackendBaseConfig)object;
                if ((bits & 1L) == 0L) {
                    this.databasePath(instance.databasePath());
                    bits |= 1L;
                }
            }
            if (object instanceof RocksDBBackendConfig) {
                instance = (RocksDBBackendConfig)object;
                if ((bits & 1L) == 0L) {
                    this.databasePath(instance.databasePath());
                    bits |= 1L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder databasePath(Path databasePath) {
            this.databasePath = Objects.requireNonNull(databasePath, "databasePath");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableRocksDBBackendConfig build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableRocksDBBackendConfig(this.databasePath);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("databasePath");
            }
            return "Cannot build RocksDBBackendConfig, some of required attributes are not set " + String.valueOf(attributes);
        }
    }
}

