/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.rocksdb;

import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.common.util.Closing;
import org.projectnessie.versioned.storage.rocksdb.RocksDBBackendConfig;
import org.projectnessie.versioned.storage.rocksdb.RocksDBPersistFactory;
import org.projectnessie.versioned.storage.rocksdb.RocksDBRepo;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.DBOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TransactionDB;
import org.rocksdb.TransactionDBOptions;

public final class RocksDBBackend
implements Backend {
    public static final String CF_REFERENCES = "nessie_refs";
    public static final String CF_OBJECTS = "nessie_objects";
    private static final List<String> CF_ALL = Arrays.asList("nessie_refs", "nessie_objects");
    private final RocksDBBackendConfig config;
    private TransactionDB db;
    private ColumnFamilyHandle cfReferences;
    private ColumnFamilyHandle cfObjects;
    private final Map<String, RocksDBRepo> repositories = new ConcurrentHashMap<String, RocksDBRepo>();

    public RocksDBBackend(RocksDBBackendConfig config) {
        RocksDB.loadLibrary();
        this.config = config;
    }

    List<ColumnFamilyHandle> all() {
        return Arrays.asList(this.cfReferences, this.cfObjects);
    }

    TransactionDB db() {
        return this.db;
    }

    ColumnFamilyHandle refs() {
        return this.cfReferences;
    }

    ColumnFamilyHandle objs() {
        return this.cfObjects;
    }

    public synchronized void close() {
        if (this.db != null) {
            try {
                Closing.closeMultiple((AutoCloseable[])new AutoCloseable[]{this.cfObjects, this.cfReferences, this.db});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.db = null;
                this.cfReferences = null;
                this.cfObjects = null;
            }
        }
    }

    private synchronized void initialize() {
        if (this.db == null) {
            Path dbPath = this.config.databasePath();
            Preconditions.checkState((dbPath != null ? 1 : 0) != 0, (Object)"RocksDB instance is missing the databasePath option.");
            Preconditions.checkState((!Files.exists(dbPath, new LinkOption[0]) || Files.isDirectory(dbPath, new LinkOption[0]) ? 1 : 0) != 0, (String)"RocksDB cannot use databasePath %s.", (Object)dbPath);
            ArrayList<byte[]> columnFamilies = new ArrayList<byte[]>();
            columnFamilies.add(RocksDB.DEFAULT_COLUMN_FAMILY);
            CF_ALL.stream().map(s -> s.getBytes(StandardCharsets.UTF_8)).forEach(columnFamilies::add);
            List columnFamilyDescriptors = columnFamilies.stream().map(c -> new ColumnFamilyDescriptor(c, new ColumnFamilyOptions().optimizeUniversalStyleCompaction())).collect(Collectors.toList());
            try (DBOptions dbOptions = new DBOptions().setCreateIfMissing(true).setCreateMissingColumnFamilies(true);){
                ArrayList columnFamilyHandles = new ArrayList();
                this.db = TransactionDB.open((DBOptions)dbOptions, (TransactionDBOptions)new TransactionDBOptions(), (String)dbPath.toString(), columnFamilyDescriptors, columnFamilyHandles);
                HashMap<String, ColumnFamilyHandle> columnFamilyHandleMap = new HashMap<String, ColumnFamilyHandle>();
                for (int i = 0; i < CF_ALL.size(); ++i) {
                    String cf = CF_ALL.get(i);
                    columnFamilyHandleMap.put(cf, (ColumnFamilyHandle)columnFamilyHandles.get(i + 1));
                }
                this.cfReferences = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_REFERENCES);
                this.cfObjects = (ColumnFamilyHandle)columnFamilyHandleMap.get(CF_OBJECTS);
            }
            catch (RocksDBException e) {
                throw new RuntimeException("RocksDB failed to start", e);
            }
        }
    }

    public Optional<String> setupSchema() {
        this.initialize();
        return Optional.of("database path: " + String.valueOf(this.config.databasePath()));
    }

    @Nonnull
    public PersistFactory createFactory() {
        this.initialize();
        return new RocksDBPersistFactory(this);
    }

    RocksDBRepo repo(StoreConfig config) {
        return this.repositories.computeIfAbsent(config.repositoryId(), r -> new RocksDBRepo());
    }

    public void eraseRepositories(Set<String> repositoryIds) {
        if (repositoryIds == null || repositoryIds.isEmpty()) {
            return;
        }
        TransactionDB db = this.db();
        List prefixed = repositoryIds.stream().map(RocksDBBackend::keyPrefix).collect(Collectors.toList());
        this.all().forEach(cf -> {
            try (RocksIterator iter = db.newIterator(cf);){
                ArrayList<ByteString> deletes = new ArrayList<ByteString>();
                iter.seekToFirst();
                while (iter.isValid()) {
                    ByteString key2 = ByteString.copyFrom((byte[])iter.key());
                    if (prefixed.stream().anyMatch(arg_0 -> ((ByteString)key2).startsWith(arg_0))) {
                        deletes.add(key2);
                    }
                    iter.next();
                }
                deletes.forEach(key -> {
                    try {
                        db.delete(cf, key.toByteArray());
                    }
                    catch (RocksDBException e) {
                        throw RocksDBBackend.rocksDbException(e);
                    }
                });
            }
        });
    }

    static RuntimeException rocksDbException(RocksDBException e) {
        throw new RuntimeException("Unhandled RocksDB exception", e);
    }

    static ByteString keyPrefix(String repositoryId) {
        return ByteString.copyFromUtf8((String)(repositoryId + ":"));
    }
}

