/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.rocksdb;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import jakarta.annotation.Nonnull;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.exceptions.ObjNotFoundException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.exceptions.RefAlreadyExistsException;
import org.projectnessie.versioned.storage.common.exceptions.RefConditionFailedException;
import org.projectnessie.versioned.storage.common.exceptions.RefNotFoundException;
import org.projectnessie.versioned.storage.common.objtypes.UpdateableObj;
import org.projectnessie.versioned.storage.common.persist.CloseableIterator;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.ObjType;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.rocksdb.RocksDBBackend;
import org.projectnessie.versioned.storage.rocksdb.RocksDBRepo;
import org.projectnessie.versioned.storage.serialize.ProtoSerialization;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.TransactionDB;

class RocksDBPersist
implements Persist {
    private final RocksDBBackend backend;
    private final RocksDBRepo repo;
    private final StoreConfig config;
    private final ByteString keyPrefix;

    RocksDBPersist(RocksDBBackend backend, RocksDBRepo repo, StoreConfig config) {
        this.backend = backend;
        this.repo = repo;
        this.config = config;
        this.keyPrefix = RocksDBBackend.keyPrefix(config.repositoryId());
    }

    private byte[] dbKey(ByteString key) {
        return this.keyPrefix.concat(key).toByteArray();
    }

    private byte[] dbKey(String key) {
        return this.dbKey(ByteString.copyFromUtf8((String)key));
    }

    private byte[] dbKey(ObjId id) {
        return this.dbKey(id.asBytes());
    }

    @Nonnull
    public String name() {
        return "RocksDB";
    }

    @Nonnull
    public StoreConfig config() {
        return this.config;
    }

    public Reference fetchReference(@Nonnull String name) {
        try {
            RocksDBBackend v = this.backend;
            TransactionDB db = v.db();
            ColumnFamilyHandle cf = v.refs();
            byte[] key = this.dbKey(name);
            byte[] reference = db.get(cf, key);
            return ProtoSerialization.deserializeReference((byte[])reference);
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
    }

    @Nonnull
    public Reference[] fetchReferences(@Nonnull String[] names) {
        try {
            RocksDBBackend v = this.backend;
            TransactionDB db = v.db();
            ColumnFamilyHandle cf = v.refs();
            int num = names.length;
            Reference[] r = new Reference[num];
            ArrayList<ColumnFamilyHandle> handles = new ArrayList<ColumnFamilyHandle>(num);
            ArrayList<byte[]> keys = new ArrayList<byte[]>(num);
            for (String name : names) {
                if (name == null) continue;
                handles.add(cf);
                keys.add(this.dbKey(name));
            }
            if (!keys.isEmpty()) {
                List dbResult = db.multiGetAsList(handles, keys);
                int ri = 0;
                for (int i = 0; i < num; ++i) {
                    String name;
                    name = names[i];
                    if (name == null) continue;
                    byte[] reference = (byte[])dbResult.get(ri++);
                    r[i] = ProtoSerialization.deserializeReference((byte[])reference);
                }
            }
            return r;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
    }

    @Nonnull
    public Reference addReference(@Nonnull Reference reference) throws RefAlreadyExistsException {
        Preconditions.checkArgument((!reference.deleted() ? 1 : 0) != 0, (Object)"Deleted references must not be added");
        Lock l = this.repo.referencesLock(reference.name());
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.refs();
            byte[] key = this.dbKey(reference.name());
            byte[] existing = db.get(cf, key);
            if (existing != null) {
                throw new RefAlreadyExistsException(ProtoSerialization.deserializeReference((byte[])existing));
            }
            db.put(cf, key, ProtoSerialization.serializeReference((Reference)reference));
            Reference reference2 = reference;
            return reference2;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    @Nonnull
    public Reference markReferenceAsDeleted(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Lock l = this.repo.referencesLock(reference.name());
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.refs();
            byte[] key = this.dbKey(reference.name());
            RocksDBPersist.checkReference(reference, db, cf, key, false);
            Reference asDeleted = reference.withDeleted(true);
            db.put(cf, key, ProtoSerialization.serializeReference((Reference)asDeleted));
            Reference reference2 = asDeleted;
            return reference2;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    private static void checkReference(Reference expected, TransactionDB db, ColumnFamilyHandle cf, byte[] key, boolean expectDeleted) throws RocksDBException, RefNotFoundException, RefConditionFailedException {
        byte[] existing = db.get(cf, key);
        if (existing == null) {
            throw new RefNotFoundException(expected);
        }
        Reference ref = ProtoSerialization.deserializeReference((byte[])existing);
        if (ref.deleted() != expectDeleted || !ref.equals((Object)expected)) {
            throw new RefConditionFailedException(ref);
        }
    }

    public void purgeReference(@Nonnull Reference reference) throws RefNotFoundException, RefConditionFailedException {
        Lock l = this.repo.referencesLock(reference.name());
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.refs();
            byte[] key = this.dbKey(reference.name());
            RocksDBPersist.checkReference(reference.withDeleted(true), db, cf, key, true);
            db.delete(cf, key);
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    @Nonnull
    public Reference updateReferencePointer(@Nonnull Reference reference, @Nonnull ObjId newPointer) throws RefNotFoundException, RefConditionFailedException {
        Lock l = this.repo.referencesLock(reference.name());
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.refs();
            byte[] key = this.dbKey(reference.name());
            RocksDBPersist.checkReference(reference, db, cf, key, false);
            Reference updated = reference.forNewPointer(newPointer, this.config);
            db.put(cf, key, ProtoSerialization.serializeReference((Reference)updated));
            Reference reference2 = updated;
            return reference2;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    @Nonnull
    public <T extends Obj> T fetchTypedObj(@Nonnull ObjId id, ObjType type, @Nonnull Class<T> typeClass) throws ObjNotFoundException {
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            byte[] key = this.dbKey(id);
            byte[] obj = db.get(cf, key);
            if (obj == null) {
                throw new ObjNotFoundException(id);
            }
            Obj o = ProtoSerialization.deserializeObj((ObjId)id, (byte[])obj, null);
            if (o == null || type != null && !type.equals((Object)o.type())) {
                throw new ObjNotFoundException(id);
            }
            Obj typed = o;
            return (T)typed;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
    }

    public <T extends Obj> T[] fetchTypedObjsIfExist(@Nonnull ObjId[] ids, ObjType type, @Nonnull Class<T> typeClass) {
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            int num = ids.length;
            Obj[] r = (Obj[])Array.newInstance(typeClass, num);
            ArrayList<ColumnFamilyHandle> handles = new ArrayList<ColumnFamilyHandle>(num);
            ArrayList<byte[]> keys = new ArrayList<byte[]>(num);
            for (ObjId id : ids) {
                if (id == null) continue;
                handles.add(cf);
                keys.add(this.dbKey(id));
            }
            if (!keys.isEmpty()) {
                List dbResult = db.multiGetAsList(handles, keys);
                int ri = 0;
                for (int i = 0; i < num; ++i) {
                    Obj typed;
                    byte[] obj;
                    ObjId id;
                    id = ids[i];
                    if (id == null || (obj = (byte[])dbResult.get(ri++)) == null) continue;
                    Obj o = ProtoSerialization.deserializeObj((ObjId)id, (byte[])obj, null);
                    if (type != null && !type.equals((Object)o.type())) {
                        o = null;
                    }
                    r[i] = typed = o;
                }
            }
            return r;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
    }

    public boolean storeObj(@Nonnull Obj obj, boolean ignoreSoftSizeRestrictions) throws ObjTooLargeException {
        Preconditions.checkArgument((obj.id() != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Lock l = this.repo.objLock(obj.id());
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            byte[] key = this.dbKey(obj.id());
            byte[] existing = db.get(cf, key);
            if (existing != null) {
                boolean bl = false;
                return bl;
            }
            int incrementalIndexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIncrementalIndexSizeLimit();
            int indexSizeLimit = ignoreSoftSizeRestrictions ? Integer.MAX_VALUE : this.effectiveIndexSegmentSizeLimit();
            byte[] serialized = ProtoSerialization.serializeObj((Obj)obj, (int)incrementalIndexSizeLimit, (int)indexSizeLimit, (boolean)true);
            db.put(cf, key, serialized);
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    @Nonnull
    public boolean[] storeObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        boolean[] r = new boolean[objs.length];
        for (int i = 0; i < objs.length; ++i) {
            Obj o = objs[i];
            if (o == null) continue;
            r[i] = this.storeObj(o, false);
        }
        return r;
    }

    public void deleteObj(@Nonnull ObjId id) {
        Lock l = this.repo.objLock(id);
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            byte[] key = this.dbKey(id);
            db.delete(cf, key);
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    public void deleteObjs(@Nonnull ObjId[] ids) {
        for (ObjId id : ids) {
            if (id == null) continue;
            this.deleteObj(id);
        }
    }

    public void upsertObj(@Nonnull Obj obj) throws ObjTooLargeException {
        ObjId id = obj.id();
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (Object)"Obj to store must have a non-null ID");
        Lock l = this.repo.objLock(obj.id());
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            byte[] key = this.dbKey(id);
            byte[] serialized = ProtoSerialization.serializeObj((Obj)obj, (int)this.effectiveIncrementalIndexSizeLimit(), (int)this.effectiveIndexSegmentSizeLimit(), (boolean)true);
            db.put(cf, key, serialized);
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    public void upsertObjs(@Nonnull Obj[] objs) throws ObjTooLargeException {
        for (Obj obj : objs) {
            if (obj == null) continue;
            this.upsertObj(obj);
        }
    }

    public boolean deleteConditional(@Nonnull UpdateableObj obj) {
        ObjId id = obj.id();
        Lock l = this.repo.objLock(id);
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            byte[] key = this.dbKey(id);
            byte[] bytes = db.get(cf, key);
            if (bytes == null) {
                boolean bl = false;
                return bl;
            }
            Obj existing = ProtoSerialization.deserializeObj((ObjId)id, (byte[])bytes, null);
            if (!existing.type().equals((Object)obj.type())) {
                boolean bl = false;
                return bl;
            }
            UpdateableObj ex = (UpdateableObj)existing;
            if (!ex.versionToken().equals(obj.versionToken())) {
                boolean bl = false;
                return bl;
            }
            db.delete(cf, key);
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    public boolean updateConditional(@Nonnull UpdateableObj expected, @Nonnull UpdateableObj newValue) throws ObjTooLargeException {
        ObjId id = expected.id();
        Preconditions.checkArgument((id != null && id.equals(newValue.id()) ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)expected.type().equals((Object)newValue.type()));
        Preconditions.checkArgument((!expected.versionToken().equals(newValue.versionToken()) ? 1 : 0) != 0);
        Lock l = this.repo.objLock(id);
        try {
            RocksDBBackend b = this.backend;
            TransactionDB db = b.db();
            ColumnFamilyHandle cf = b.objs();
            byte[] key = this.dbKey(id);
            byte[] obj = db.get(cf, key);
            if (obj == null) {
                boolean bl = false;
                return bl;
            }
            Obj existing = ProtoSerialization.deserializeObj((ObjId)id, (byte[])obj, null);
            if (!existing.type().equals((Object)expected.type())) {
                boolean bl = false;
                return bl;
            }
            UpdateableObj ex = (UpdateableObj)existing;
            if (!ex.versionToken().equals(expected.versionToken())) {
                boolean bl = false;
                return bl;
            }
            byte[] serialized = ProtoSerialization.serializeObj((Obj)newValue, (int)this.effectiveIncrementalIndexSizeLimit(), (int)this.effectiveIndexSegmentSizeLimit(), (boolean)true);
            db.put(cf, key, serialized);
            boolean bl = true;
            return bl;
        }
        catch (RocksDBException e) {
            throw RocksDBBackend.rocksDbException(e);
        }
        finally {
            l.unlock();
        }
    }

    public void erase() {
        this.backend.eraseRepositories(Collections.singleton(this.config().repositoryId()));
    }

    @Nonnull
    public CloseableIterator<Obj> scanAllObjects(@Nonnull Set<ObjType> returnedObjTypes) {
        return new ScanAllObjectsIterator(returnedObjTypes::contains);
    }

    private class ScanAllObjectsIterator
    extends AbstractIterator<Obj>
    implements CloseableIterator<Obj> {
        private final Predicate<ObjType> filter;
        private final TransactionDB db;
        private final ColumnFamilyHandle cf;
        private final RocksIterator iter;
        private boolean first = true;
        private byte[] lastKey;

        ScanAllObjectsIterator(Predicate<ObjType> filter) {
            this.filter = filter;
            RocksDBBackend b = RocksDBPersist.this.backend;
            this.db = b.db();
            this.cf = b.objs();
            this.iter = this.db.newIterator(b.objs());
            this.iter.seekToFirst();
        }

        protected Obj computeNext() {
            Obj o;
            while (true) {
                ObjId id;
                byte[] obj;
                if (!this.iter.isValid()) {
                    return (Obj)this.endOfData();
                }
                if (this.first) {
                    this.first = false;
                } else {
                    this.iter.next();
                }
                byte[] k = this.iter.key();
                if (this.lastKey != null && Arrays.equals(this.lastKey, k)) continue;
                this.lastKey = k;
                ByteString key = ByteString.copyFrom((byte[])k);
                if (!key.startsWith(RocksDBPersist.this.keyPrefix)) continue;
                try {
                    obj = this.db.get(this.cf, k);
                }
                catch (RocksDBException e) {
                    throw RocksDBBackend.rocksDbException(e);
                }
                if (obj != null && this.filter.test((o = ProtoSerialization.deserializeObj((ObjId)(id = ProtoSerialization.deserializeObjId((ByteString)key.substring(RocksDBPersist.this.keyPrefix.size()))), (byte[])obj, null)).type())) break;
            }
            return o;
        }

        public void close() {
            this.iter.close();
        }
    }
}

