/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.testextension;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.CacheConfig;
import org.projectnessie.versioned.storage.cache.PersistCaches;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.testextension.BackendTestFactory;
import org.projectnessie.versioned.storage.testextension.NessiePersistCache;
import org.projectnessie.versioned.storage.testextension.PersistExtension;
import org.projectnessie.versioned.storage.testextension.ReusableTestBackend;

final class ClassPersistInstances {
    private final List<Persist> persistInstances = new ArrayList<Persist>();
    private final CacheBackend cacheBackend;
    private final BackendTestFactory backendTestFactory;
    private final Supplier<Backend> backendSupplier;
    private Backend backend;
    private PersistFactory persistFactory;

    ClassPersistInstances(ExtensionContext context) {
        ExtensionContext.Store rootStore = context.getRoot().getStore(PersistExtension.NAMESPACE);
        ReusableTestBackend reusableTestBackend = (ReusableTestBackend)rootStore.getOrComputeIfAbsent((Object)"reusable-backend", k -> new ReusableTestBackend(), ReusableTestBackend.class);
        this.backendSupplier = () -> reusableTestBackend.backend(context);
        NessiePersistCache nessiePersistCache = PersistExtension.annotationInstance(context, NessiePersistCache.class);
        this.cacheBackend = nessiePersistCache != null && nessiePersistCache.capacityMb() >= 0L ? PersistCaches.newBackend((CacheConfig)CacheConfig.builder().capacityMb(nessiePersistCache.capacityMb()).referenceTtl(Duration.ofMinutes(1L)).referenceNegativeTtl(Duration.ofMinutes(1L)).enableSoftReferences(nessiePersistCache.enableSoftReferences()).build()) : null;
        this.backendTestFactory = reusableTestBackend.backendTestFactory(context);
    }

    BackendTestFactory backendTestFactory() {
        return this.backendTestFactory;
    }

    Backend backend() {
        Backend b = this.backend;
        if (b == null) {
            b = this.backend = this.backendSupplier.get();
            b.setupSchema();
        }
        return b;
    }

    PersistFactory persistFactory() {
        PersistFactory p = this.persistFactory;
        if (p == null) {
            p = this.persistFactory = this.backend().createFactory();
        }
        return p;
    }

    void registerPersist(Persist persist) {
        this.persistInstances.add(persist);
    }

    void reinitialize() {
        this.persistInstances.forEach(p -> ClassPersistInstances.reinit(p, true));
    }

    static void reinit(Persist persist, boolean initialize) {
        persist.erase();
        if (initialize) {
            RepositoryLogic setup = Logics.repositoryLogic((Persist)persist);
            setup.initialize("main");
        }
    }

    public Persist newPersist(StoreConfig config) {
        Persist persist = this.persistFactory().newPersist(config);
        if (this.cacheBackend != null) {
            persist = this.cacheBackend.wrap(persist);
        }
        return persist;
    }
}

