/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.testextension;

import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.versioned.storage.cache.CacheBackend;
import org.projectnessie.versioned.storage.cache.PersistCaches;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.logic.Logics;
import org.projectnessie.versioned.storage.common.logic.RepositoryLogic;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.testextension.NessiePersistCache;
import org.projectnessie.versioned.storage.testextension.PersistExtension;
import org.projectnessie.versioned.storage.testextension.ReusableTestBackend;

final class ClassPersistInstances {
    private final List<Persist> persistInstances = new ArrayList<Persist>();
    private final CacheBackend cacheBackend;
    private final PersistFactory persistFactory;

    ClassPersistInstances(ExtensionContext context) {
        ExtensionContext.Store rootStore = context.getRoot().getStore(PersistExtension.NAMESPACE);
        ReusableTestBackend reusableTestBackend = (ReusableTestBackend)rootStore.getOrComputeIfAbsent((Object)"reusable-backend", k -> new ReusableTestBackend(), ReusableTestBackend.class);
        NessiePersistCache nessiePersistCache = PersistExtension.annotationInstance(context, NessiePersistCache.class);
        this.cacheBackend = nessiePersistCache != null ? PersistCaches.newBackend((long)nessiePersistCache.capacity()) : null;
        Backend backend = reusableTestBackend.backend(context);
        backend.setupSchema();
        this.persistFactory = backend.createFactory();
    }

    void registerPersist(Persist persist) {
        this.persistInstances.add(persist);
    }

    void reinitialize() {
        this.persistInstances.forEach(p -> ClassPersistInstances.reinit(p, true));
    }

    static void reinit(Persist persist, boolean initialize) {
        persist.erase();
        if (initialize) {
            RepositoryLogic setup = Logics.repositoryLogic((Persist)persist);
            setup.initialize("main");
        }
    }

    public Persist newPersist(StoreConfig config) {
        Persist persist = this.persistFactory.newPersist(config);
        if (this.cacheBackend != null) {
            persist = this.cacheBackend.wrap(persist);
        }
        return persist;
    }
}

