/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.testextension;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionConfigurationException;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.ReflectionUtils;
import org.projectnessie.versioned.storage.common.config.StoreConfig;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.Persist;
import org.projectnessie.versioned.storage.common.persist.PersistFactory;
import org.projectnessie.versioned.storage.testextension.BackendTestFactory;
import org.projectnessie.versioned.storage.testextension.ClassPersistInstances;
import org.projectnessie.versioned.storage.testextension.NessiePersist;
import org.projectnessie.versioned.storage.testextension.NessieStoreConfig;
import org.projectnessie.versioned.storage.testextension.UniqueMicrosClock;

public class PersistExtension
implements BeforeAllCallback,
BeforeEachCallback,
ParameterResolver {
    static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{PersistExtension.class});
    static final String KEY_STATICS = "static-nessie-persist";
    static final String KEY_REUSABLE_BACKEND = "reusable-backend";

    static <A extends Annotation> A annotationInstance(ExtensionContext context, Class<A> annotation) {
        Optional ann;
        Optional clazz;
        while (!(clazz = context.getTestClass()).isPresent() || !(ann = AnnotationUtils.findAnnotation((AnnotatedElement)((AnnotatedElement)clazz.get()), annotation)).isPresent()) {
            Optional p = context.getParent();
            if (!p.isPresent()) {
                return null;
            }
            context = (ExtensionContext)p.get();
        }
        return (A)((Annotation)ann.get());
    }

    public void beforeAll(ExtensionContext context) {
        Class testClass = context.getRequiredTestClass();
        ClassPersistInstances classPersistInstances = (ClassPersistInstances)context.getStore(NAMESPACE).getOrComputeIfAbsent((Object)KEY_STATICS, k -> new ClassPersistInstances(context), ClassPersistInstances.class);
        AnnotationUtils.findAnnotatedFields((Class)testClass, NessiePersist.class, ReflectionUtils::isStatic).forEach(field -> this.injectField(context, null, (Field)field, classPersistInstances::registerPersist));
    }

    public void beforeEach(ExtensionContext context) {
        ((ClassPersistInstances)context.getStore(NAMESPACE).get((Object)KEY_STATICS, ClassPersistInstances.class)).reinitialize();
        context.getRequiredTestInstances().getAllInstances().forEach(instance -> AnnotationUtils.findAnnotatedFields(instance.getClass(), NessiePersist.class, ReflectionUtils::isNotStatic).forEach(field -> this.injectField(context, instance, (Field)field, persist -> {
            NessiePersist annotation = field.getAnnotation(NessiePersist.class);
            ClassPersistInstances.reinit(persist, annotation.initializeRepo());
        })));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.isAnnotated(NessiePersist.class);
    }

    private void injectField(ExtensionContext context, Object instance, Field field, Consumer<Persist> newPersist) {
        this.assertValidFieldCandidate(field);
        try {
            NessiePersist nessiePersist = (NessiePersist)AnnotationUtils.findAnnotation((AnnotatedElement)field, NessiePersist.class).orElseThrow(IllegalStateException::new);
            Object assign = this.resolve(nessiePersist, field, field.getType(), context, false, newPersist);
            ((Field)ReflectionUtils.makeAccessible((AccessibleObject)field)).set(instance, assign);
        }
        catch (Throwable t) {
            ExceptionUtils.throwAsUncheckedException((Throwable)t);
        }
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext context) throws ParameterResolutionException {
        NessiePersist nessiePersist = (NessiePersist)parameterContext.findAnnotation(NessiePersist.class).orElseThrow(IllegalStateException::new);
        Parameter parameter = parameterContext.getParameter();
        return this.resolve(nessiePersist, parameter, parameter.getType(), context, true, persist -> {});
    }

    private Object resolve(NessiePersist nessiePersist, AnnotatedElement annotatedElement, Class<?> type, ExtensionContext context, boolean canReinit, Consumer<Persist> newPersist) {
        boolean wantsPersist = Persist.class.isAssignableFrom(type);
        boolean wantsPersistFactory = PersistFactory.class.isAssignableFrom(type);
        boolean wantsBackend = Backend.class.isAssignableFrom(type);
        boolean wantsBackendTestFactory = BackendTestFactory.class.isAssignableFrom(type);
        Preconditions.checkState((wantsPersist || wantsPersistFactory || wantsBackend || wantsBackendTestFactory ? 1 : 0) != 0, (String)"Cannot assign to %s", (Object)annotatedElement);
        if (wantsBackendTestFactory || wantsBackend || wantsPersistFactory) {
            ClassPersistInstances classPersistInstances = PersistExtension.classPersistInstances(context);
            if (wantsBackendTestFactory) {
                return classPersistInstances.backendTestFactory();
            }
            if (wantsBackend) {
                return classPersistInstances.backend();
            }
            return classPersistInstances.persistFactory();
        }
        Persist persist = PersistExtension.createPersist(nessiePersist, annotatedElement, context);
        if (canReinit) {
            ClassPersistInstances.reinit(persist, nessiePersist.initializeRepo());
        }
        newPersist.accept(persist);
        return persist;
    }

    static Map<String, String> extractConfig(ExtensionContext context, AnnotatedElement annotatedElement) {
        ArrayList configs = new ArrayList();
        Consumer<AnnotatedElement> collector = m -> configs.addAll(AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)m, NessieStoreConfig.class));
        collector.accept(annotatedElement);
        context.getTestMethod().ifPresent(collector);
        context.getTestClass().ifPresent(cls -> {
            while (cls != Object.class) {
                collector.accept((AnnotatedElement)cls);
                cls = cls.getSuperclass();
            }
        });
        return configs.stream().collect(Collectors.toMap(NessieStoreConfig::name, NessieStoreConfig::value));
    }

    static ClassPersistInstances classPersistInstances(ExtensionContext context) {
        return (ClassPersistInstances)context.getStore(NAMESPACE).get((Object)KEY_STATICS, ClassPersistInstances.class);
    }

    static Persist createPersist(NessiePersist persistAnnotation, AnnotatedElement annotatedElement, ExtensionContext context) {
        StoreConfig.Adjustable config = StoreConfig.Adjustable.empty();
        config = PersistExtension.extractCustomConfiguration(persistAnnotation, context).apply(config);
        Map<String, String> configMap = PersistExtension.extractConfig(context, annotatedElement);
        config = config.fromFunction(configMap::get);
        config = config.withClock((Clock)UniqueMicrosClock.SHARED_INSTANCE);
        return PersistExtension.classPersistInstances(context).newPersist((StoreConfig)config);
    }

    private static Function<StoreConfig.Adjustable, StoreConfig.Adjustable> extractCustomConfiguration(NessiePersist persistAnnotation, ExtensionContext context) {
        Function<StoreConfig.Adjustable, StoreConfig.Adjustable> applyCustomConfig = c -> c;
        if (!persistAnnotation.configMethod().isEmpty()) {
            Method configMethod = (Method)ReflectionUtils.findMethod((Class)context.getRequiredTestClass(), (String)persistAnnotation.configMethod(), (Class[])new Class[]{StoreConfig.class}).orElseThrow(() -> new IllegalArgumentException(String.format("%s.configMethod='%s' does not exist in %s", NessiePersist.class.getSimpleName(), persistAnnotation.configMethod(), context.getRequiredTestClass().getName())));
            ReflectionUtils.makeAccessible((AccessibleObject)configMethod);
            if (!Modifier.isStatic(configMethod.getModifiers()) || Modifier.isPrivate(configMethod.getModifiers()) || !StoreConfig.Adjustable.class.isAssignableFrom(configMethod.getReturnType())) {
                throw new IllegalArgumentException(String.format("%s.configMethod='%s' must have the signature 'static %s %s(%s)' in %s", NessiePersist.class.getSimpleName(), persistAnnotation.configMethod(), StoreConfig.Adjustable.class.getSimpleName(), persistAnnotation.configMethod(), StoreConfig.Adjustable.class.getSimpleName(), context.getRequiredTestClass().getName()));
            }
            applyCustomConfig = c -> {
                try {
                    return (StoreConfig.Adjustable)configMethod.invoke(null, c);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new RuntimeException(e);
                }
            };
        }
        return applyCustomConfig;
    }

    private void assertValidFieldCandidate(Field field) {
        if (!(field.getType().isAssignableFrom(Persist.class) || field.getType().isAssignableFrom(PersistFactory.class) || field.getType().isAssignableFrom(Backend.class) || field.getType().isAssignableFrom(BackendTestFactory.class))) {
            throw new ExtensionConfigurationException("Can only resolve fields of type " + Persist.class.getName() + " but was: " + field.getType().getName());
        }
        if (ReflectionUtils.isPrivate((Member)field)) {
            throw new ExtensionConfigurationException(String.format("field [%s] must not be private.", field));
        }
    }
}

