/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.testextension;

import java.util.Objects;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.projectnessie.versioned.storage.common.persist.Backend;
import org.projectnessie.versioned.storage.common.persist.BackendFactory;
import org.projectnessie.versioned.storage.common.persist.PersistLoader;
import org.projectnessie.versioned.storage.testextension.BackendTestFactory;
import org.projectnessie.versioned.storage.testextension.NessieBackend;
import org.projectnessie.versioned.storage.testextension.NessieBackendName;
import org.projectnessie.versioned.storage.testextension.PersistExtension;

final class ReusableTestBackend
implements ExtensionContext.Store.CloseableResource {
    private Class<? extends BackendTestFactory> backendType;
    private String backendName;
    private BackendTestFactory backendTestFactory;
    private Backend backend;

    ReusableTestBackend() {
    }

    BackendTestFactory backendTestFactory(ExtensionContext context) {
        NessieBackend nessieBackend;
        BackendTestFactory f = this.backendTestFactory;
        if (f == null && (nessieBackend = PersistExtension.annotationInstance(context, NessieBackend.class)) != null) {
            try {
                this.backendType = nessieBackend.value();
                f = this.backendTestFactory = this.backendType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                f.start();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return f;
    }

    Backend backend(ExtensionContext context) {
        Backend reusable = this.maybeReusable(context);
        if (reusable != null) {
            return reusable;
        }
        return this.createNewBackend(context);
    }

    private Backend createNewBackend(ExtensionContext context) {
        this.backendName = null;
        this.backendType = null;
        NessieBackend nessieBackend = PersistExtension.annotationInstance(context, NessieBackend.class);
        if (nessieBackend != null) {
            try {
                this.backendType = nessieBackend.value();
                BackendTestFactory f = this.backendTestFactory(context);
                this.backend = f.createNewBackend();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            NessieBackendName nessieBackendName = PersistExtension.annotationInstance(context, NessieBackendName.class);
            this.backendName = nessieBackendName != null ? nessieBackendName.value() : null;
            BackendFactory backendFactory = this.backendName != null ? PersistLoader.findFactoryByName((String)this.backendName) : PersistLoader.findAny();
            this.backend = backendFactory.buildBackend(backendFactory.newConfigInstance());
        }
        return this.backend;
    }

    private Backend maybeReusable(ExtensionContext context) {
        String name;
        if (this.backend == null) {
            return null;
        }
        NessieBackend nessieBackend = PersistExtension.annotationInstance(context, NessieBackend.class);
        Class<? extends BackendTestFactory> nessieBackendType = nessieBackend != null ? nessieBackend.value() : null;
        NessieBackendName nessieBackendName = PersistExtension.annotationInstance(context, NessieBackendName.class);
        String string = name = nessieBackendName != null ? nessieBackendName.value() : null;
        if (!Objects.equals(this.backendType, nessieBackendType) || !Objects.equals(name, this.backendName)) {
            try {
                this.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return null;
        }
        return this.backend;
    }

    public void close() throws Exception {
        this.backendName = null;
        this.backendType = null;
        try {
            if (this.backend != null) {
                this.backend.close();
            }
        }
        finally {
            this.backend = null;
            try {
                if (this.backendTestFactory != null) {
                    this.backendTestFactory.stop();
                }
            }
            finally {
                this.backendTestFactory = null;
            }
        }
    }
}

