/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.testextension;

import java.time.Clock;
import java.time.Instant;
import java.time.ZoneId;
import java.util.concurrent.TimeUnit;

final class UniqueMicrosClock
extends Clock {
    static final long MICROS_PER_SECOND = TimeUnit.SECONDS.toMicros(1L);
    private final Clock clock;
    static final UniqueMicrosClock SHARED_INSTANCE = new UniqueMicrosClock(Clock.systemUTC());
    private long lastSec;
    private long lastMicro;

    UniqueMicrosClock(Clock clock) {
        this.clock = clock;
    }

    UniqueMicrosClock() {
        this(Clock.systemUTC());
    }

    @Override
    public ZoneId getZone() {
        return this.clock.getZone();
    }

    @Override
    public Clock withZone(ZoneId zone) {
        return new UniqueMicrosClock(this.clock.withZone(zone));
    }

    @Override
    public synchronized Instant instant() {
        Instant i = this.clock.instant();
        long sec = i.getEpochSecond();
        long micro = TimeUnit.NANOSECONDS.toMicros(i.getNano());
        if (sec < this.lastSec) {
            sec = this.lastSec;
        }
        if (sec == this.lastSec && micro <= this.lastMicro) {
            micro = this.lastMicro + 1L;
            if (micro >= MICROS_PER_SECOND) {
                micro -= MICROS_PER_SECOND;
                ++sec;
            }
            i = Instant.ofEpochSecond(sec, TimeUnit.MICROSECONDS.toNanos(micro));
        }
        this.lastSec = sec;
        this.lastMicro = micro;
        return i;
    }
}

