/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.Ref;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractDuplicateTable
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractDuplicateTable(VersionStore store) {
        super(store);
    }

    @Test
    void duplicateTableOnBranches() throws Throwable {
        ContentKey key = ContentKey.of((String[])new String[]{"some-table"});
        BranchName branch0 = BranchName.of((String)"globalStateDuplicateTable-main");
        this.store().create((NamedRef)branch0, Optional.empty());
        Hash ancestor = this.store().commit(branch0, Optional.empty(), CommitMeta.fromMessage((String)"initial commit"), (List)ImmutableList.of((Object)Put.of((ContentKey)ContentKey.of((String[])new String[]{"unrelated-table"}), (Content)OnRefOnly.newOnRef("value"))));
        BranchName branch1 = BranchName.of((String)"globalStateDuplicateTable-branch1");
        BranchName branch2 = BranchName.of((String)"globalStateDuplicateTable-branch2");
        this.soft.assertThat((Object)this.store().create((NamedRef)branch1, Optional.of(ancestor))).isEqualTo((Object)ancestor);
        this.soft.assertThat((Object)this.store().create((NamedRef)branch2, Optional.of(ancestor))).isEqualTo((Object)ancestor);
        OnRefOnly valuebranch1 = OnRefOnly.newOnRef("create table");
        OnRefOnly valuebranch2 = OnRefOnly.newOnRef("create table");
        ImmutableList putForBranch1 = ImmutableList.of((Object)Put.of((ContentKey)key, (Content)valuebranch1));
        ImmutableList putForBranch2 = ImmutableList.of((Object)Put.of((ContentKey)key, (Content)valuebranch2));
        this.store().commit(branch1, Optional.empty(), CommitMeta.fromMessage((String)"create table"), (List)putForBranch1);
        this.soft.assertThat((Object)AbstractDuplicateTable.contentWithoutId(this.store().getValue((Ref)branch1, key))).isEqualTo((Object)valuebranch1);
        ThrowableAssert.ThrowingCallable createTableOnOtherBranch = () -> this.lambda$duplicateTableOnBranches$0(branch2, (List)putForBranch2);
        createTableOnOtherBranch.call();
        this.soft.assertThat((Object)AbstractDuplicateTable.contentWithoutId(this.store().getValue((Ref)branch2, key))).isEqualTo((Object)valuebranch2);
    }

    private /* synthetic */ void lambda$duplicateTableOnBranches$0(BranchName branch2, List putForBranch2) throws Throwable {
        this.store().commit(branch2, Optional.empty(), CommitMeta.fromMessage((String)"create table on other branch"), putForBranch2);
    }
}

