/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.tests;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.InstanceOfAssertFactories;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.SoftAssertions;
import org.assertj.core.api.ThrowableAssert;
import org.assertj.core.api.junit.jupiter.InjectSoftAssertions;
import org.assertj.core.api.junit.jupiter.SoftAssertionsExtension;
import org.assertj.core.groups.Tuple;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.junit.jupiter.params.provider.EnumSource;
import org.junit.jupiter.params.provider.MethodSource;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.Conflict;
import org.projectnessie.model.Content;
import org.projectnessie.model.ContentKey;
import org.projectnessie.model.Namespace;
import org.projectnessie.model.ReferenceConflicts;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Delete;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.Put;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.VersionStore;
import org.projectnessie.versioned.tests.AbstractNestedVersionStore;
import org.projectnessie.versioned.tests.AbstractVersionStoreTestBase;
import org.projectnessie.versioned.testworker.OnRefOnly;

@ExtendWith(value={SoftAssertionsExtension.class})
public abstract class AbstractNamespaceValidation
extends AbstractNestedVersionStore {
    @InjectSoftAssertions
    protected SoftAssertions soft;

    protected AbstractNamespaceValidation(VersionStore store) {
        super(store);
    }

    static Stream<ContentKey> contentKeys() {
        return Stream.of(ContentKey.of((String[])new String[]{"ns", "table"}), ContentKey.of((String[])new String[]{"ns", "table"}), ContentKey.of((String[])new String[]{"ns2", "ns", "table"}), ContentKey.of((String[])new String[]{"ns2", "ns", "table"}));
    }

    @ParameterizedTest
    @MethodSource(value={"contentKeys"})
    void commitWithNonExistingNamespace(ContentKey key) throws Exception {
        BranchName branch = BranchName.of((String)"commitWithNonExistingNamespace");
        this.store().create((NamedRef)branch, Optional.empty());
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"non-existing-ns"), Collections.singletonList(Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef("value"))))).isInstanceOf(ReferenceConflictException.class)).hasMessage("Namespace '%s' must exist.", new Object[]{key.getNamespace()}).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.NAMESPACE_ABSENT, key.getNamespace().toContentKey(), "namespace '" + key.getNamespace() + "' must exist"})});
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial commit"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"unrelated-table"}), (Content)OnRefOnly.newOnRef("value"))));
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"non-existing-ns"), Collections.singletonList(Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef("value"))))).isInstanceOf(ReferenceConflictException.class)).hasMessage("Namespace '%s' must exist.", new Object[]{key.getNamespace()}).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.NAMESPACE_ABSENT, key.getNamespace().toContentKey(), "namespace '" + key.getNamespace() + "' must exist"})});
    }

    @ParameterizedTest
    @MethodSource(value={"contentKeys"})
    void commitWithNonNamespace(ContentKey key) throws Exception {
        BranchName branch = BranchName.of((String)"commitWithNonNamespace");
        this.store().create((NamedRef)branch, Optional.empty());
        if (key.getElementCount() == 3) {
            this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial commit"), Collections.singletonList(Put.of((ContentKey)key.getParent().getParent(), (Content)Namespace.of((ContentKey)key.getParent().getParent()))));
        }
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"not a namespace"), Collections.singletonList(Put.of((ContentKey)key.getParent(), (Content)OnRefOnly.newOnRef("value"))));
        ((ListAssert)((ObjectAssert)((AbstractThrowableAssert)this.soft.assertThatThrownBy(() -> this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"non-existing-ns"), Collections.singletonList(Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef("value"))))).isInstanceOf(ReferenceConflictException.class)).hasMessage("Expecting the key '%s' to be a namespace, but is not a namespace (using a content object that is not a namespace as a namespace is forbidden).", new Object[]{key.getNamespace()}).asInstanceOf(InstanceOfAssertFactories.type(ReferenceConflictException.class))).extracting(ReferenceConflictException::getReferenceConflicts).extracting(ReferenceConflicts::conflicts, InstanceOfAssertFactories.list(Conflict.class))).extracting(new Function[]{Conflict::conflictType, Conflict::key, Conflict::message}).containsExactly((Object[])new Tuple[]{Assertions.tuple((Object[])new Object[]{Conflict.ConflictType.NOT_A_NAMESPACE, key.getNamespace().toContentKey(), "expecting the key '" + key.getNamespace() + "' to be a namespace, but is not a namespace (using a content object that is not a namespace as a namespace is forbidden)"})});
    }

    @ParameterizedTest
    @CsvSource(value={"true", "false"})
    void preventNamespaceDeletionWithChildren(boolean childNamespace) throws Exception {
        BranchName branch = BranchName.of((String)"branch");
        this.store().create((NamedRef)branch, Optional.empty());
        Namespace ns = Namespace.of((String[])new String[]{"ns"});
        ContentKey key = ContentKey.of((Namespace)ns, (String)"table");
        this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"initial"), Arrays.asList(Put.of((ContentKey)ns.toContentKey(), (Content)ns), Put.of((ContentKey)key, (Content)(childNamespace ? Namespace.of((ContentKey)key) : OnRefOnly.newOnRef("foo")))));
        this.soft.assertThatThrownBy(() -> this.store.commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"try delete ns"), Collections.singletonList(Delete.of((ContentKey)ns.toContentKey())))).isInstanceOf(ReferenceConflictException.class);
    }

    @ParameterizedTest
    @EnumSource(value=NamespaceValidationMergeTransplant.class)
    void mergeTransplantWithCommonButRemovedNamespace(NamespaceValidationMergeTransplant mode) throws Exception {
        ThrowableAssert.ThrowingCallable mergeTransplant;
        BranchName root = BranchName.of((String)"root");
        this.store().create((NamedRef)root, Optional.empty());
        Namespace ns = Namespace.of((String[])new String[]{"ns"});
        Namespace ns2 = Namespace.of((String[])new String[]{"ns2"});
        Hash rootHead = this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"create namespace"), mode.createNamespaceOnTarget ? Collections.singletonList(Put.of((ContentKey)ns2.toContentKey(), (Content)ns2)) : Arrays.asList(Put.of((ContentKey)ns.toContentKey(), (Content)ns), Put.of((ContentKey)ns2.toContentKey(), (Content)ns2)));
        BranchName branch = BranchName.of((String)"branch");
        this.store().create((NamedRef)branch, Optional.of(rootHead));
        if (mode.createNamespaceOnTarget) {
            this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"create namespace"), Collections.singletonList(Put.of((ContentKey)ns.toContentKey(), (Content)ns)));
        }
        ContentKey key = ContentKey.of((Namespace)ns, (String)"foo");
        Hash commit1 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"create table ns.foo"), Collections.singletonList(Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef("foo"))));
        Hash commit2 = this.store().commit(branch, Optional.empty(), CommitMeta.fromMessage((String)"create table ns2.bar"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((Namespace)ns2, (String)"bar"), (Content)OnRefOnly.newOnRef("bar"))));
        this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"unrelated"), Collections.singletonList(Put.of((ContentKey)ContentKey.of((String[])new String[]{"unrelated-table"}), (Content)OnRefOnly.newOnRef("bar"))));
        ThrowableAssert.ThrowingCallable throwingCallable = mergeTransplant = mode.merge ? () -> this.store().merge(this.store().hashOnReference((NamedRef)branch, Optional.empty()), root, Optional.empty(), AbstractVersionStoreTestBase.METADATA_REWRITER, mode.individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false) : () -> this.store().transplant(root, Optional.empty(), Arrays.asList(commit1, commit2), AbstractVersionStoreTestBase.METADATA_REWRITER, mode.individualCommits, Collections.emptyMap(), MergeType.NORMAL, false, false);
        if (mode.deleteNamespaceOnTarget) {
            this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"delete namespace"), Collections.singletonList(Delete.of((ContentKey)ns.toContentKey())));
        }
        if (mode.error) {
            ((AbstractThrowableAssert)this.soft.assertThatThrownBy(mergeTransplant).isInstanceOf(ReferenceConflictException.class)).hasMessage("Namespace '%s' must exist.", new Object[]{key.getNamespace()});
        } else {
            this.soft.assertThatCode(mergeTransplant).doesNotThrowAnyException();
        }
    }

    @Test
    void mustNotOverwriteNamespace() throws Exception {
        BranchName root = BranchName.of((String)"root");
        this.store().create((NamedRef)root, Optional.empty());
        ContentKey key = ContentKey.of((String[])new String[]{"key"});
        this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"create table ns.foo"), Collections.singletonList(Put.of((ContentKey)key, (Content)Namespace.of((ContentKey)key))));
        this.soft.assertThatThrownBy(() -> this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"create table ns.foo"), Collections.singletonList(Put.of((ContentKey)key, (Content)OnRefOnly.newOnRef("foo"))))).isInstanceOf(IllegalArgumentException.class);
    }

    @Test
    void deleteHierarchy() throws Exception {
        BranchName root = BranchName.of((String)"root");
        this.store().create((NamedRef)root, Optional.empty());
        List<Namespace> namespaces = Arrays.asList(Namespace.of((String[])new String[]{"a"}), Namespace.of((String[])new String[]{"a", "b"}), Namespace.of((String[])new String[]{"a", "b", "c"}), Namespace.of((String[])new String[]{"x"}), Namespace.of((String[])new String[]{"x", "y"}), Namespace.of((String[])new String[]{"x", "y", "z"}));
        List tables = namespaces.stream().flatMap(ns -> Stream.of(ContentKey.of((Namespace)ns, (String)"A"), ContentKey.of((Namespace)ns, (String)"B"), ContentKey.of((Namespace)ns, (String)"C"))).collect(Collectors.toList());
        this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"unrelated"), Stream.concat(tables.stream().map(t -> Put.of((ContentKey)t, (Content)OnRefOnly.newOnRef(t.toString()))), namespaces.stream().map(ns -> Put.of((ContentKey)ns.toContentKey(), (Content)ns))).collect(Collectors.toList()));
        this.soft.assertThatCode(() -> this.store().commit(root, Optional.empty(), CommitMeta.fromMessage((String)"delete all the things"), Stream.concat(namespaces.stream().map(ns -> Delete.of((ContentKey)ns.toContentKey())), tables.stream().map(Delete::of)).collect(Collectors.toList()))).doesNotThrowAnyException();
    }

    static enum NamespaceValidationMergeTransplant {
        MERGE_SQUASH(true, false, false, false, false),
        MERGE_INDIVIDUAL(true, false, false, true, false),
        MERGE_CREATE_SQUASH(true, true, false, false, false),
        MERGE_CREATE_INDIVIDUAL(true, true, false, true, false),
        MERGE_DELETE_SQUASH(true, false, true, false, true),
        MERGE_DELETE_INDIVIDUAL(true, false, true, true, true),
        TRANSPLANT_SQUASH(false, false, false, false, false),
        TRANSPLANT_INDIVIDUAL(false, false, false, true, false),
        TRANSPLANT_CREATE_SQUASH(true, true, false, false, false),
        TRANSPLANT_CREATE_INDIVIDUAL(true, true, false, true, false),
        TRANSPLANT_DELETE_SQUASH(false, false, true, false, true),
        TRANSPLANT_DELETE_INDIVIDUAL(false, false, true, true, true);

        final boolean merge;
        final boolean createNamespaceOnTarget;
        final boolean deleteNamespaceOnTarget;
        final boolean individualCommits;
        final boolean error;

        private NamespaceValidationMergeTransplant(boolean merge, boolean createNamespaceOnTarget, boolean deleteNamespaceOnTarget, boolean individualCommits, boolean error) {
            this.merge = merge;
            this.createNamespaceOnTarget = createNamespaceOnTarget;
            this.deleteNamespaceOnTarget = deleteNamespaceOnTarget;
            this.individualCommits = individualCommits;
            this.error = error;
        }
    }
}

